/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf.glyph;

import com.inet.pdfview.font.ttf.glyph.Glyf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GlyfSimpleDyn
extends Glyf {
    private final double advanceWidth;
    private List<TTFPoint> points = new ArrayList<TTFPoint>();
    private List<Integer> contourOffsets = new ArrayList<Integer>();

    public GlyfSimpleDyn(double advanceWidth) {
        this.advanceWidth = advanceWidth;
        this.setMaxX((short)Short.MIN_VALUE);
        this.setMaxY((short)Short.MIN_VALUE);
        this.setMinX((short)Short.MAX_VALUE);
        this.setMinY((short)Short.MAX_VALUE);
    }

    public void addContour() {
        this.contourOffsets.add(this.points.size());
    }

    public void addPoint(int x, int y, boolean onCurve) {
        this.points.add(new TTFPoint(x, y, onCurve));
        if (x < this.getMinX()) {
            this.setMinX((short)x);
        }
        if (x > this.getMaxX()) {
            this.setMaxX((short)x);
        }
        if (y < this.getMinY()) {
            this.setMinY((short)y);
        }
        if (y > this.getMaxY()) {
            this.setMaxY((short)y);
        }
    }

    public double getAdvanceWidth() {
        return this.advanceWidth;
    }

    public int getNumPoints() {
        return this.points.size();
    }

    @Override
    public short getNumContours() {
        return (short)this.contourOffsets.size();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        ByteBuffer buf = super.toByteBuffer();
        int n = this.contourOffsets.size();
        for (int i = 1; i < n; ++i) {
            buf.putShort((short)(this.contourOffsets.get(i) - 1));
        }
        buf.putShort((short)(this.points.size() - 1));
        buf.putShort((short)0);
        for (TTFPoint tTFPoint : this.points) {
            buf.put((byte)(tTFPoint.onCurve ? 1 : 0));
        }
        int lx = 0;
        for (TTFPoint p : this.points) {
            buf.putShort((short)(p.x - lx));
            lx = p.x;
        }
        boolean bl = false;
        for (TTFPoint p : this.points) {
            int n2;
            buf.putShort((short)(p.y - n2));
            n2 = p.y;
        }
        assert (buf.remaining() == 0);
        return buf;
    }

    @Override
    public short getLength() {
        short length = super.getLength();
        length = (short)(length + 2);
        length = (short)(length + 2 * this.getNumContours());
        length = (short)(length + 5 * this.getNumPoints());
        return length;
    }

    @Override
    public String toString() {
        return super.toString() + " advance:" + this.advanceWidth + "\n\t\tPoints: " + Arrays.toString(this.points.toArray());
    }

    public void done() {
        if (this.points.size() <= 1) {
            return;
        }
        if (this.points.size() > 1 && this.points.get(0).equals(this.points.get(this.points.size() - 1))) {
            this.points.remove(this.points.size() - 1);
        }
    }

    public static class TTFPoint {
        private int x;
        private int y;
        private boolean onCurve;

        public TTFPoint(int x, int y, boolean onCurve) {
            this.x = x;
            this.y = y;
            this.onCurve = onCurve;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean isOnCurve() {
            return this.onCurve;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TTFPoint)) {
                return false;
            }
            TTFPoint other = (TTFPoint)obj;
            return other.x == this.x && other.y == this.y && other.onCurve == this.onCurve;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + (this.onCurve ? "" : ", noc") + ")";
        }
    }
}

