/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf.cmap;

import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.font.ttf.cmap.CMap;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class CMapFormat4
extends CMap {
    public static final int START_OF_SYMBOLIC_RANGE = 61440;
    private boolean isSymbolic = true;
    public SortedSet<Segment> segments = Collections.synchronizedSortedSet(new TreeSet());

    public CMapFormat4(short language) {
        super((short)4, language);
        this.addSegment((short)-1, (short)-1, new char[]{'\u0000'});
    }

    private void addSegment(short startCode, short endCode, char[] map) {
        int endCodePoint = endCode & 0xFFFF;
        int startCodePoint = startCode & 0xFFFF;
        if (map.length != endCodePoint - startCodePoint + 1) {
            throw new IllegalArgumentException("Wrong number of entries in map");
        }
        if (this.segments.size() > 0) {
            Segment recent = this.segments.last();
            if (recent.endCode > endCodePoint) {
                throw new IllegalStateException("CMap segments not in ascending order.");
            }
        }
        this.segments.add(new Segment(startCode, endCode, map));
        if (startCodePoint < 61440) {
            this.isSymbolic = false;
        }
    }

    private void addSegment(short startCode, short endCode, short idDelta) {
        if (this.segments.size() > 0) {
            Segment recent = this.segments.last();
            if (recent.endCode > (endCode & 0xFFFF)) {
                throw new IllegalStateException("CMap segments not in ascending order.");
            }
        }
        this.segments.add(new Segment(startCode, endCode, idDelta));
        int startCodePoint = startCode & 0xFFFF;
        if (startCodePoint < 61440) {
            this.isSymbolic = false;
        }
    }

    public void insertSegment(short startCode, short endCode, short idDelta) {
        this.segments.add(new Segment(startCode, endCode, idDelta));
        int startCodePoint = startCode & 0xFFFF;
        if (startCodePoint < 61440) {
            this.isSymbolic = false;
        }
    }

    @Override
    public int getLength() {
        int size = 16;
        size += this.segments.size() * 8;
        for (Segment s : this.segments) {
            if (!s.hasMap()) continue;
            size += s.map.length * 2;
        }
        return size;
    }

    @Override
    public byte map(byte src) {
        char c = this.map((char)src);
        if (c < '\uffffff80' || c > '\u007f') {
            return 0;
        }
        return (byte)c;
    }

    @Override
    public char map(char src) {
        for (Segment s : this.segments) {
            if (s.endCode < src) continue;
            if (s.startCode <= src) {
                if (s.hasMap()) {
                    return s.map[src - s.startCode];
                }
                return (char)(src + s.idDelta);
            }
            return '\u0000';
        }
        return '\u0000';
    }

    @Override
    public char reverseMap(short glyphID) {
        for (Segment s : this.segments) {
            if (s.hasMap()) {
                for (int c = 0; c < s.map.length; ++c) {
                    if (s.map[c] != glyphID) continue;
                    return (char)(s.startCode + c);
                }
                continue;
            }
            int start = s.startCode + s.idDelta;
            int end = s.endCode + s.idDelta;
            if (glyphID < start || glyphID > end) continue;
            return (char)(glyphID - s.idDelta);
        }
        return '\u0000';
    }

    @Override
    public void setData(int length, IDataBuffer data) {
        int i;
        this.segments.clear();
        int segCount = data.getShort() / 2;
        data.getShort();
        data.getShort();
        data.getShort();
        short[] endCodes = new short[segCount];
        short[] startCodes = new short[segCount];
        short[] idDeltas = new short[segCount];
        short[] idRangeOffsets = new short[segCount];
        int glyphArrayPos = 16 + 8 * segCount;
        for (i = 0; i < segCount; ++i) {
            endCodes[i] = data.getShort();
        }
        data.getShort();
        for (i = 0; i < segCount; ++i) {
            startCodes[i] = data.getShort();
        }
        for (i = 0; i < segCount; ++i) {
            idDeltas[i] = data.getShort();
        }
        for (i = 0; i < segCount; ++i) {
            idRangeOffsets[i] = data.getShort();
            if (idRangeOffsets[i] <= 0) {
                this.addSegment(startCodes[i], endCodes[i], idDeltas[i]);
                continue;
            }
            int offset = data.position() - 2 + idRangeOffsets[i];
            if (offset < glyphArrayPos) {
                throw new IllegalStateException("Invalid character map offset: " + offset + " while minimum was " + glyphArrayPos);
            }
            int size = (endCodes[i] & 0xFFFF) - (startCodes[i] & 0xFFFF) + 1;
            char[] map = new char[size];
            data.mark();
            data.position(offset);
            for (int c = 0; c < size; ++c) {
                map[c] = data.getChar();
            }
            data.reset();
            this.addSegment(startCodes[i], endCodes[i], map);
        }
        this.addSegment((short)-1, (short)-1, new char[]{'\u0000'});
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer buf = ByteBuffer.allocate(this.getLength());
        buf.putShort(this.getFormat());
        buf.putShort((short)this.getLength());
        buf.putShort(this.getLanguage());
        buf.putShort((short)(this.getSegmentCount() * 2));
        buf.putShort(this.getSearchRange());
        buf.putShort(this.getEntrySelector());
        buf.putShort(this.getRangeShift());
        for (Segment s : this.segments) {
            buf.putShort((short)s.endCode);
        }
        buf.putShort((short)0);
        for (Segment s : this.segments) {
            buf.putShort((short)s.startCode);
        }
        for (Segment s : this.segments) {
            if (!s.hasMap()) {
                buf.putShort((short)s.idDelta);
                continue;
            }
            buf.putShort((short)0);
        }
        int glyphArrayOffset = 16 + 8 * this.getSegmentCount();
        for (Segment s : this.segments) {
            if (s.hasMap()) {
                buf.putShort((short)(glyphArrayOffset - buf.position()));
                buf.mark();
                buf.position(glyphArrayOffset);
                for (int c = 0; c < s.map.length; ++c) {
                    buf.putChar(s.map[c]);
                }
                buf.reset();
                glyphArrayOffset += s.map.length * 2;
                continue;
            }
            buf.putShort((short)0);
        }
        buf.position(glyphArrayOffset);
        buf.flip();
        return buf;
    }

    public int getSegmentCount() {
        return this.segments.size();
    }

    @Override
    public int getLastCode() {
        if (this.segments.size() <= 1) {
            return -1;
        }
        Segment[] sArray = this.segments.toArray(new Segment[this.segments.size()]);
        for (int i = sArray.length - 2; i >= 0; --i) {
            Segment last = sArray[i];
            if (last.hasMap()) {
                return last.endCode;
            }
            int code = last.endCode + last.idDelta;
            if (code >= 65535) continue;
            return code;
        }
        return -1;
    }

    private short getSearchRange() {
        double pow = Math.floor(Math.log(this.getSegmentCount()) / Math.log(2.0));
        double pow2 = Math.pow(2.0, pow);
        return (short)(2.0 * pow2);
    }

    public short getEntrySelector() {
        int sr2 = this.getSearchRange() / 2;
        return (short)(Math.log(sr2) / Math.log(2.0));
    }

    public short getRangeShift() {
        return (short)(2 * this.getSegmentCount() - this.getSearchRange());
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String indent = "        ";
        buf.append(super.toString());
        buf.append(indent + "SegmentCount : " + this.getSegmentCount() + "\n");
        buf.append(indent + "SearchRange  : " + this.getSearchRange() + "\n");
        buf.append(indent + "EntrySelector: " + this.getEntrySelector() + "\n");
        buf.append(indent + "RangeShift   : " + this.getRangeShift() + "\n");
        for (Segment s : this.segments) {
            buf.append(indent);
            buf.append("Segment: " + Integer.toHexString(s.startCode));
            buf.append("-" + Integer.toHexString(s.endCode) + " ");
            buf.append("hasMap: " + s.hasMap() + " ");
            if (!s.hasMap()) {
                buf.append("delta: " + s.idDelta);
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public boolean canBeSymbolic() {
        return this.isSymbolic;
    }

    class Segment
    implements Comparable<Segment> {
        int startCode;
        int endCode;
        char[] map;
        int idDelta;

        public Segment(short startCode, short endCode, char[] map) {
            this.endCode = 0xFFFF & endCode;
            this.startCode = 0xFFFF & startCode;
            this.map = map;
        }

        public Segment(short startCode, short endCode, int idDelta) {
            this.endCode = 0xFFFF & endCode;
            this.startCode = 0xFFFF & startCode;
            this.idDelta = idDelta;
        }

        public boolean hasMap() {
            return this.map != null;
        }

        public boolean equals(Object o) {
            return o instanceof Segment && this.compareTo((Segment)o) == 0;
        }

        @Override
        public int compareTo(Segment s) {
            if (s.endCode >= this.startCode && s.endCode <= this.endCode || s.startCode >= this.startCode && s.startCode <= this.endCode) {
                return 0;
            }
            if (this.endCode > s.endCode) {
                return 1;
            }
            if (this.endCode < s.endCode) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "start=" + Integer.toHexString(this.startCode) + ", end=" + Integer.toHexString(this.endCode) + ", " + (String)(this.hasMap() ? Arrays.toString(this.map) : "delta=" + this.idDelta);
        }
    }
}

