/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.logging.Logger;
import com.inet.pdfview.PDFFile;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.FlPoint;
import com.inet.pdfview.font.FontSupport;
import com.inet.pdfview.font.OutlineFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class Type1Font
extends OutlineFont {
    private static final byte[] EEXEC = "eexec".getBytes();
    private static final byte FIRST_HEADER_BYTE = -128;
    private static final int HEADER_SIZE = 6;
    private static final int NUMBER_OF_PARTS = 3;
    private boolean isaccentedCharacter;
    private BinaryDataHeader header;
    String[] chr2name;
    int password;
    byte[][] subrs;
    int lenIV;
    Map<String, Object> name2outline;
    Map<String, FlPoint> name2width;
    AffineTransform at;
    float[] stack = new float[100];
    int sloc = 0;
    float[] psStack = new float[3];
    int psLoc = 0;
    private String encodingType;
    public static final String WIN_ANSI = "WinAnsiEncoding";
    public static final String MAC_ROMAN = "MacRomanEncoding";
    private PDFFontToUnicodeMap toUnicode;
    private int style;
    static int ctr;
    int callcount = 0;

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only command line values used")
    public Type1Font(String baseName, PDFObject src, PDFFontDescriptor descriptor, String encodingType, PDFFontToUnicodeMap toUnicode, PDFDecrypter decryptor) throws PDFParseException {
        super(baseName, src, descriptor, encodingType);
        if (descriptor != null && descriptor.getFontFile() != null) {
            int start = descriptor.getFontFile().getDictRef("Length1").getIntValue();
            int len = descriptor.getFontFile().getDictRef("Length2").getIntValue();
            PDFXref xref = descriptor.getFontFile().getRefValue();
            if (xref == null) {
                decryptor = null;
            }
            byte[] fontData = descriptor.getFontFile().getStream(descriptor.getFontFile().getRefValue(), decryptor, true);
            this.readBinaryDataHeader(fontData);
            if (this.header != null) {
                start = this.header.headerOffset + 6;
                len = this.header.headerLength;
            } else {
                int newstartposition;
                boolean checkOK = Type1Font.checkStartPosition(start, fontData);
                if (!checkOK && (newstartposition = Type1Font.correctStartPos(fontData, start, this.getBaseFont())) != -1) {
                    if (newstartposition == start) {
                        PDFParser.LOGGER.error((Object)"Can not correct the end value of ASCI part in type1 font");
                    } else {
                        int fileLength = fontData.length;
                        int allowedLength = fileLength - newstartposition;
                        if (newstartposition < start) {
                            len += start - newstartposition;
                        }
                        if (len > allowedLength) {
                            len = allowedLength;
                        }
                        start = newstartposition;
                    }
                }
            }
            this.parseFont(fontData, start, len);
            if (DUMP_FONT_PATH != null) {
                Logger logger = PDFParser.LOGGER;
                File dumpFile = new File(DUMP_FONT_PATH, "embeddedType1_" + this.getBaseFont() + "_" + Integer.toHexString(Arrays.hashCode(fontData)) + ".pfb");
                if (logger.isDebug()) {
                    logger.debug((Object)("Type1Font " + String.valueOf(this.getClass()) + ", SAVED AS " + String.valueOf(dumpFile)));
                }
                try {
                    FileOutputStream out = new FileOutputStream(dumpFile);
                    out.write(fontData);
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.encodingType = encodingType;
        this.toUnicode = toUnicode;
        this.style = this.getStyleFromName(baseName);
        if (descriptor != null) {
            this.style |= descriptor.calculateStyle();
        }
    }

    boolean readBinaryDataHeader(byte[] fontData) {
        int headerOffset = 0;
        for (int p = 0; p < 3; ++p) {
            if (fontData[headerOffset] != -128) continue;
            byte headerType1 = fontData[headerOffset + 1];
            if (headerType1 < 1 || headerType1 > 3) {
                PDFParser.LOGGER.warn((Object)("Unknown header type of Type1Font: " + headerType1));
            }
            int sectionLength = 0;
            for (int i = 2; i < 6; ++i) {
                sectionLength += (fontData[headerOffset + i] & 0xFF) << (i - 2) * 8;
            }
            if (headerOffset + sectionLength > fontData.length) {
                PDFParser.LOGGER.error((Object)("Invalid length value in Type1Font header: " + sectionLength));
                return false;
            }
            if (p == 1) {
                this.header = new BinaryDataHeader(headerOffset, sectionLength);
            }
            headerOffset += sectionLength + 6;
        }
        return true;
    }

    static boolean checkStartPosition(int start, byte[] fontData) {
        int wsCount = 0;
        for (int i = 1; i < start; ++i) {
            byte b = fontData[start - i];
            if (b == 10 || b == 13 || b == 32) continue;
            wsCount = i - 1;
            break;
        }
        if (start >= fontData.length) {
            return false;
        }
        int eexecStartPos = start - wsCount - EEXEC.length;
        if (eexecStartPos <= 0) {
            return false;
        }
        boolean checkOK = true;
        for (int i = 0; i < EEXEC.length; ++i) {
            if (fontData[eexecStartPos + i] == EEXEC[i]) continue;
            checkOK = false;
            break;
        }
        return checkOK;
    }

    protected void parseFont(byte[] font, int start, int len) {
        this.name2width = new HashMap<String, FlPoint>();
        byte[] data = null;
        if (this.isASCII(font, start)) {
            byte[] bData = this.readASCII(font, start, start + len);
            data = this.decrypt(bData, 0, bData.length, 55665, 4);
        } else {
            data = this.decrypt(font, start, start + len, 55665, 4);
        }
        this.chr2name = this.readEncoding(font);
        int lenIVLoc = this.findSlashName(data, "lenIV");
        PSParser psp = new PSParser(data, 0);
        if (lenIVLoc < 0) {
            this.lenIV = 4;
        } else {
            psp.setLoc(lenIVLoc + 6);
            this.lenIV = Integer.parseInt(psp.readThing());
        }
        this.password = 4330;
        int matrixloc = this.findSlashName(font, "FontMatrix");
        if (matrixloc < 0) {
            if (PDFParser.LOGGER.isDebug()) {
                PDFParser.LOGGER.debug((Object)"No FontMatrix!");
            }
            this.at = new AffineTransform(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
        } else {
            PSParser psp2 = new PSParser(font, matrixloc + 11);
            float[] xf = psp2.readArray(6);
            this.at = new AffineTransform(xf);
        }
        this.subrs = this.readSubrs(data);
        this.name2outline = new TreeMap<String, byte[]>(this.readChars(data));
    }

    private String[] readEncoding(byte[] d) {
        byte[][] ary = this.readArray(d, "Encoding", "def");
        String[] res = new String[256];
        for (int i = 0; i < ary.length; ++i) {
            if (ary[i] != null) {
                if (ary[i][0] == 47) {
                    res[i] = new String(ary[i]).substring(1);
                    continue;
                }
                res[i] = new String(ary[i]);
                continue;
            }
            res[i] = null;
        }
        return res;
    }

    private byte[][] readSubrs(byte[] d) {
        return this.readArray(d, "Subrs", "index");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[][] readArray(byte[] d, String key, String end) {
        int i = this.findSlashName(d, key);
        if (i < 0) {
            return new byte[0][];
        }
        PSParser psp = new PSParser(d, i);
        psp.readThing();
        String type = psp.readThing();
        if (type.equals("StandardEncoding")) {
            byte[][] stdenc = new byte[FontSupport.standardEncoding.length][];
            for (i = 0; i < stdenc.length; ++i) {
                stdenc[i] = FontSupport.getName(FontSupport.standardEncoding[i]).getBytes();
            }
            return stdenc;
        }
        int len = Integer.parseInt(type);
        byte[][] out = new byte[len][];
        while (true) {
            String s;
            if ((s = psp.readThing()).equals("dup")) {
                int id = psp.readInteger();
                String elt = psp.readThing();
                byte[] line = elt.getBytes();
                if (Character.isDigit(elt.charAt(0))) {
                    int hold = Integer.parseInt(elt);
                    String special = psp.readThing();
                    if (special.equals("-|") || special.equals("RD")) {
                        psp.setLoc(psp.getLoc() + 1);
                        line = psp.getNEncodedBytes(hold, this.password, this.lenIV);
                    }
                }
                out[id] = line;
                if (id < len - 1) continue;
                return out;
            }
            if (s.equals(end)) return out;
        }
    }

    private byte[] decrypt(byte[] d, int start, int end, int key, int skip) {
        if (end - start - skip < 0) {
            skip = 0;
        }
        byte[] o = new byte[end - start - skip];
        int r = key;
        int c1 = 52845;
        int c2 = 22719;
        for (int ipos = start; ipos < end; ++ipos) {
            int c = d[ipos] & 0xFF;
            int p = (c ^ r >> 8) & 0xFF;
            r = (c + r) * c1 + c2 & 0xFFFF;
            if (ipos - start - skip < 0) continue;
            o[ipos - start - skip] = (byte)p;
        }
        return o;
    }

    private byte[] readASCII(byte[] data, int start, int end) {
        byte[] o = new byte[(end - start) / 2];
        int count = 0;
        int bit = 0;
        for (int loc = start; loc < end; ++loc) {
            char c = (char)(data[loc] & 0xFF);
            byte b = 0;
            if (c >= '0' && c <= '9') {
                b = (byte)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                b = (byte)(10 + (c - 97));
            } else {
                if (c < 'A' || c > 'F') continue;
                b = (byte)(10 + (c - 65));
            }
            if (bit++ % 2 == 0) {
                o[count] = (byte)(b << 4);
                continue;
            }
            int n = count++;
            o[n] = (byte)(o[n] | b);
        }
        return o;
    }

    private boolean isASCII(byte[] data, int start) {
        for (int i = start; i < start + 4; ++i) {
            char c = (char)(data[i] & 0xFF);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    private int findSlashName(byte[] d, String name) {
        for (int i = 0; i < d.length; ++i) {
            if (d[i] != 47) continue;
            boolean found = true;
            for (int j = 0; j < name.length(); ++j) {
                if (d[i + j + 1] == name.charAt(j)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    private HashMap<String, byte[]> readChars(byte[] d) {
        HashMap<String, byte[]> hm = new HashMap<String, byte[]>();
        int i = this.findSlashName(d, "CharStrings");
        if (i < 0) {
            return hm;
        }
        PSParser psp = new PSParser(d, i);
        while (true) {
            String s;
            char c;
            if ((c = (s = psp.readThing()).charAt(0)) == '/') {
                int len = Integer.parseInt(psp.readThing());
                String go = psp.readThing();
                if (!go.equals("-|") && !go.equals("RD")) continue;
                psp.setLoc(psp.getLoc() + 1);
                byte[] line = psp.getNEncodedBytes(len, this.password, this.lenIV);
                hm.put(s.substring(1), line);
                continue;
            }
            if (s.equals("end")) break;
        }
        return hm;
    }

    private float pop() {
        float val = 0.0f;
        if (this.sloc > 0) {
            val = this.stack[--this.sloc];
        }
        return val;
    }

    private void parse(byte[] cs, GeneralPathWrap gp, FlPoint pt, FlPoint wid) {
        int loc = 0;
        block29: while (loc < cs.length) {
            int v;
            if ((v = cs[loc++] & 0xFF) == 255) {
                this.stack[this.sloc++] = ((cs[loc] & 0xFF) << 24) + ((cs[loc + 1] & 0xFF) << 16) + ((cs[loc + 2] & 0xFF) << 8) + (cs[loc + 3] & 0xFF);
                loc += 4;
                continue;
            }
            if (v >= 251) {
                this.stack[this.sloc++] = -(v - 251 << 8) - (cs[loc] & 0xFF) - 108;
                ++loc;
                continue;
            }
            if (v >= 247) {
                this.stack[this.sloc++] = (v - 247 << 8) + (cs[loc] & 0xFF) + 108;
                ++loc;
                continue;
            }
            if (v >= 32) {
                this.stack[this.sloc++] = v - 139;
                continue;
            }
            block1 : switch (v) {
                case 0: {
                    throw new IllegalArgumentException("Bad command (" + v + ")");
                }
                case 1: {
                    this.sloc = 0;
                    break;
                }
                case 2: {
                    throw new IllegalArgumentException("Bad command (" + v + ")");
                }
                case 3: {
                    this.sloc = 0;
                    break;
                }
                case 4: {
                    pt.y += this.pop();
                    gp.moveTo(pt.x, pt.y);
                    this.sloc = 0;
                    break;
                }
                case 5: {
                    pt.y += this.pop();
                    pt.x += this.pop();
                    gp.lineTo(pt.x, pt.y);
                    this.sloc = 0;
                    break;
                }
                case 6: {
                    pt.x += this.pop();
                    gp.lineTo(pt.x, pt.y);
                    this.sloc = 0;
                    break;
                }
                case 7: {
                    pt.y += this.pop();
                    gp.lineTo(pt.x, pt.y);
                    this.sloc = 0;
                    break;
                }
                case 8: {
                    float y3 = this.pop();
                    float x3 = this.pop();
                    float y2 = this.pop();
                    float x2 = this.pop();
                    float y1 = this.pop();
                    float x1 = this.pop();
                    gp.curveTo(pt.x + x1, pt.y + y1, pt.x + x1 + x2, pt.y + y1 + y2, pt.x + x1 + x2 + x3, pt.y + y1 + y2 + y3);
                    pt.x += x1 + x2 + x3;
                    pt.y += y1 + y2 + y3;
                    this.sloc = 0;
                    break;
                }
                case 9: {
                    try {
                        gp.closePath();
                    }
                    catch (IllegalPathStateException e) {
                        PDFParser.LOGGER.warn((Object)e);
                    }
                    this.sloc = 0;
                    break;
                }
                case 10: {
                    int n = (int)this.pop();
                    if (this.subrs[n] == null) {
                        if (!PDFParser.LOGGER.isDebug()) break;
                        PDFParser.LOGGER.debug((Object)("No subroutine #" + n));
                        break;
                    }
                    ++this.callcount;
                    if (this.callcount > 10) {
                        if (PDFParser.LOGGER.isDebug()) {
                            PDFParser.LOGGER.debug((Object)"Call stack too large");
                        }
                    } else {
                        this.parse(this.subrs[n], gp, pt, wid);
                    }
                    --this.callcount;
                    break;
                }
                case 11: {
                    return;
                }
                case 12: {
                    v = cs[loc++] & 0xFF;
                    if (v == 6) {
                        char a = (char)this.pop();
                        char b = (char)this.pop();
                        float y = this.pop();
                        float x = this.pop();
                        this.buildAccentChar(x, y, a, b, gp);
                        this.sloc = 0;
                        break;
                    }
                    if (v == 7) {
                        wid.y = this.pop();
                        wid.x = this.pop();
                        pt.y = this.pop();
                        pt.x = this.pop();
                        this.sloc = 0;
                        break;
                    }
                    if (v == 12) {
                        float b = this.pop();
                        float a = this.pop();
                        this.stack[this.sloc++] = a / b;
                        break;
                    }
                    if (v == 33) {
                        pt.y = this.pop();
                        pt.x = this.pop();
                        gp.moveTo(pt.x, pt.y);
                        this.sloc = 0;
                        break;
                    }
                    if (v == 0) {
                        this.sloc = 0;
                        break;
                    }
                    if (v == 1) {
                        this.sloc = 0;
                        break;
                    }
                    if (v == 2) {
                        this.sloc = 0;
                        break;
                    }
                    if (v == 16) {
                        int cn = (int)this.pop();
                        int countargs = (int)this.pop();
                        switch (cn) {
                            case 0: {
                                this.psStack[this.psLoc++] = this.pop();
                                this.psStack[this.psLoc++] = this.pop();
                                this.pop();
                                break block1;
                            }
                            case 3: {
                                this.psStack[this.psLoc++] = 3.0f;
                                break block1;
                            }
                        }
                        for (int i = 0; i > countargs; --i) {
                            this.psStack[this.psLoc++] = this.pop();
                        }
                        continue block29;
                    }
                    if (v == 17) {
                        this.stack[this.sloc++] = this.psStack[this.psLoc - 1];
                        --this.psLoc;
                        break;
                    }
                    throw new IllegalArgumentException("Bad command (" + v + ")");
                }
                case 13: {
                    wid.x = this.pop();
                    wid.y = 0.0f;
                    pt.x = this.pop();
                    pt.y = 0.0f;
                    this.sloc = 0;
                    break;
                }
                case 14: {
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 21: {
                    pt.y += this.pop();
                    pt.x += this.pop();
                    gp.moveTo(pt.x, pt.y);
                    this.sloc = 0;
                    break;
                }
                case 22: {
                    pt.x += this.pop();
                    gp.moveTo(pt.x, pt.y);
                    this.sloc = 0;
                    break;
                }
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    if (!PDFParser.LOGGER.isDebug()) break;
                    PDFParser.LOGGER.debug((Object)("the command " + v + " is not valid in Type1 font"));
                    break;
                }
                case 30: {
                    float x3 = this.pop();
                    float y2 = this.pop();
                    float x2 = this.pop();
                    float y1 = this.pop();
                    float y3 = 0.0f;
                    float x1 = 0.0f;
                    gp.curveTo(pt.x, pt.y + y1, pt.x + x2, pt.y + y1 + y2, pt.x + x2 + x3, pt.y + y1 + y2);
                    pt.x += x2 + x3;
                    pt.y += y1 + y2;
                    this.sloc = 0;
                    break;
                }
                case 31: {
                    float y3 = this.pop();
                    float y2 = this.pop();
                    float x2 = this.pop();
                    float x1 = this.pop();
                    float x3 = 0.0f;
                    float y1 = 0.0f;
                    gp.curveTo(pt.x + x1, pt.y, pt.x + x1 + x2, pt.y + y2, pt.x + x1 + x2, pt.y + y2 + y3);
                    pt.x += x1 + x2;
                    pt.y += y2 + y3;
                    this.sloc = 0;
                }
            }
        }
    }

    private void buildAccentChar(float x, float y, char a, char b, GeneralPathWrap gp) {
        GeneralPath pathA;
        int indB = FontSupport.standardEncoding[b];
        String charNameB = FontSupport.getName(indB);
        int indA = FontSupport.standardEncoding[a];
        String charNameA = FontSupport.getName(indA);
        boolean aCodeFound = false;
        boolean bCodeFound = false;
        for (int i = 0; i < this.chr2name.length; ++i) {
            if (this.chr2name[i] == null) continue;
            if (!aCodeFound && charNameA.equals(this.chr2name[i])) {
                a = (char)i;
                if (bCodeFound) break;
                aCodeFound = true;
            }
            if (bCodeFound || !charNameB.equals(this.chr2name[i])) continue;
            b = (char)i;
            if (aCodeFound) break;
            bCodeFound = true;
        }
        if ((pathA = this.getOutline(a, this.getWidth(a, null))) == null) {
            return;
        }
        GeneralPath pathACopy = (GeneralPath)pathA.clone();
        try {
            pathACopy.transform(this.at.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        pathACopy.transform(AffineTransform.getTranslateInstance(x, y));
        GeneralPath pathBCopy = (GeneralPath)this.getOutline(b, this.getWidth(b, null)).clone();
        try {
            pathBCopy.transform(this.at.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        gp.append(pathBCopy, false);
        gp.append(pathACopy, false);
        this.isaccentedCharacter = true;
    }

    @Override
    public float getWidth(char code, String name) {
        if (this.getFirstChar() == -1 || this.getLastChar() == -1 || code < this.getFirstChar() || !this.widthArrayDefined()) {
            String key = this.chr2name[code & 0xFF];
            if (name != null) {
                key = name;
            }
            if (key != null && this.name2outline.containsKey(key)) {
                FlPoint width;
                if (!this.name2width.containsKey(key)) {
                    this.getOutline(key, 0.0f);
                }
                if ((width = this.name2width.get(key)) != null) {
                    return width.x / (float)this.getDefaultWidth();
                }
            }
            return 0.0f;
        }
        return super.getWidth(code, name);
    }

    private synchronized GeneralPath parseGlyph(byte[] cs, FlPoint advance, AffineTransform at) {
        GeneralPathWrap gp = new GeneralPathWrap();
        FlPoint curpoint = new FlPoint();
        this.sloc = 0;
        this.parse(cs, gp, curpoint, advance);
        gp.gp.transform(at);
        return gp.gp;
    }

    @Override
    @Nullable
    protected GeneralPath getOutline(String name, float width) {
        if (name == null || !this.name2outline.containsKey(name)) {
            return null;
        }
        Object obj = this.name2outline.get(name);
        if (obj instanceof PathWithWidth) {
            return ((PathWithWidth)obj).getPath(width);
        }
        byte[] cs = (byte[])obj;
        FlPoint advance = new FlPoint();
        GeneralPath gp = this.parseGlyph(cs, advance, this.at);
        PathWithWidth pww = new PathWithWidth(gp, advance);
        this.name2outline.put(name, pww);
        this.name2width.put(name, advance);
        if (this.isaccentedCharacter) {
            this.isaccentedCharacter = false;
            return gp;
        }
        return pww.getPath(width);
    }

    @Override
    protected GeneralPath getOutline(char src, float width) {
        return this.getOutline(this.chr2name[src & 0xFF], width);
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    @Override
    public PDFFontToUnicodeMap getUnicodeMapping() {
        return this.toUnicode;
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    static int correctStartPos(byte[] fontData, int startPos, String baseFont) {
        int checkLength = fontData.length - EEXEC.length + 1;
        int eexecPos = -1;
        for (int i = 0; i < checkLength; ++i) {
            boolean found = true;
            for (int j = 0; j < EEXEC.length; ++j) {
                if (fontData[i + j] == EEXEC[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            eexecPos = i;
            break;
        }
        int newstartposition = -1;
        if (eexecPos == -1) {
            PDFParser.LOGGER.error((Object)"End of ASCI part of type1 font is not found");
        } else {
            newstartposition = eexecPos + EEXEC.length;
            int wsCount = 0;
            int checklength = fontData.length - newstartposition;
            for (int i = 0; i < checklength; ++i) {
                byte ws = fontData[newstartposition + i];
                if (ws == 10 || ws == 13) continue;
                wsCount = i;
                break;
            }
            if (wsCount > 1) {
                PDFParser.LOGGER.warn((Object)("The number of white space characters after ASCII part " + wsCount + ". From that number only the first characeter will be considered as delimiter"));
                wsCount = 1;
            }
            if ((newstartposition += wsCount) >= fontData.length) {
                PDFParser.LOGGER.warn((Object)("Binary data not found  in Type1Font: " + baseFont));
                return -1;
            }
            if (newstartposition == startPos) {
                PDFParser.LOGGER.warn((Object)"Can not correct the end value of ASCI part in type1 font");
            }
        }
        return newstartposition;
    }

    boolean widthArrayDefined() {
        return true;
    }

    private static class BinaryDataHeader {
        int headerOffset;
        int headerLength;

        public BinaryDataHeader(int headerOffset, int headerLength) {
            this.headerOffset = headerOffset;
            this.headerLength = headerLength;
        }
    }

    class PSParser {
        byte[] data;
        int loc;

        public PSParser(byte[] data, int start) {
            this.data = data;
            this.loc = start;
        }

        public String readThing() {
            while (PDFFile.isWhiteSpace(this.data[this.loc])) {
                ++this.loc;
            }
            int start = this.loc;
            while (!PDFFile.isWhiteSpace(this.data[this.loc])) {
                ++this.loc;
            }
            String s = new String(this.data, start, this.loc - start);
            return s;
        }

        public int readInteger() {
            while (PDFFile.isWhiteSpace(this.data[this.loc])) {
                ++this.loc;
            }
            int start = this.loc;
            while (Character.isDigit(this.data[this.loc])) {
                ++this.loc;
            }
            return Integer.parseInt(new String(this.data, start, this.loc - start));
        }

        public float[] readArray(int count) {
            float[] ary = new float[count];
            int idx = 0;
            while (idx < count) {
                int index;
                String thing = this.readThing();
                if (thing.charAt(0) == '[') {
                    thing = thing.substring(1);
                }
                if ((index = thing.indexOf("]")) != -1) {
                    thing = thing.substring(0, index);
                }
                if (thing.length() == 0) continue;
                ary[idx++] = Float.valueOf(thing).floatValue();
            }
            return ary;
        }

        public int getLoc() {
            return this.loc;
        }

        public void setLoc(int loc) {
            this.loc = loc;
        }

        public byte[] getNEncodedBytes(int n, int key, int skip) {
            byte[] result = Type1Font.this.decrypt(this.data, this.loc, this.loc + n, key, skip);
            this.loc += n;
            return result;
        }
    }

    private static class GeneralPathWrap {
        private GeneralPath gp = new GeneralPath();
        private boolean closed = true;
        private boolean moveTo;
        private float moveX;
        private float moveY;

        private GeneralPathWrap() {
        }

        public void moveTo(float x, float y) {
            if (this.closed) {
                this.gp.moveTo(x, y);
            } else {
                this.moveTo = true;
                this.moveX = x;
                this.moveY = y;
            }
        }

        public void lineTo(float x, float y) {
            this.before();
            this.closed = false;
            this.gp.lineTo(x, y);
        }

        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.before();
            this.closed = false;
            this.gp.curveTo(x1, y1, x2, y2, x3, y3);
        }

        public void closePath() {
            this.before();
            this.closed = true;
            this.gp.closePath();
        }

        public void append(GeneralPath other, boolean b) {
            this.before();
            this.closed = false;
            this.gp.append(other, b);
        }

        private void before() {
            if (this.moveTo) {
                this.gp.lineTo(this.moveX, this.moveY);
                this.moveTo = false;
            }
        }
    }

    private class PathWithWidth {
        private GeneralPath gp;
        private FlPoint advance;
        private Map<Float, GeneralPath> pathes;

        public PathWithWidth(GeneralPath gp, FlPoint advance) {
            this.gp = gp;
            this.advance = advance;
        }

        public GeneralPath getPath(float width) {
            GeneralPath path;
            if (width == 0.0f || this.advance.x == 0.0f || Math.abs(width - this.advance.x) < 0.001f) {
                return this.gp;
            }
            Float key = Float.valueOf(width);
            if (this.pathes != null && (path = this.pathes.get(key)) != null) {
                return path;
            }
            path = (GeneralPath)this.gp.clone();
            Point2D.Float p = new Point2D.Float(this.advance.x, this.advance.y);
            Type1Font.this.at.transform(p, p);
            double scale = (double)width / ((Point2D)p).getX();
            AffineTransform xform = AffineTransform.getScaleInstance(scale, 1.0);
            path.transform(xform);
            if (this.pathes == null) {
                this.pathes = new HashMap<Float, GeneralPath>();
            }
            this.pathes.put(key, path);
            return path;
        }
    }
}

