/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.logging.Logger;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.command.PDFDrawTextCmd;
import com.inet.pdfview.command.PDFDrawTextCmds;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.CharCharMap;
import com.inet.pdfview.font.FlPoint;
import com.inet.pdfview.font.FontSupport;
import com.inet.pdfview.font.OutlineFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.PDFGlyph;
import com.inet.pdfview.font.cidcff.FontDict;
import com.inet.pdfview.font.cidcff.FontDictSelector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.NoninvertibleTransformException;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.SuppressFBWarnings;

public class Type1CFont
extends OutlineFont {
    private int errMessageFontMatrixInFdArrayNotDefinedCount;
    private byte[] data;
    private int pos;
    private float[] stack = new float[100];
    private int stackptr = 0;
    private String[] names;
    protected int[] glyphnames;
    protected int[] encoding = new int[256];
    private AffineTransform at = new AffineTransform(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
    private AffineTransform glyphTransform;
    private int num;
    private float fnum;
    private static int CMD = 0;
    private static int NUM = 1;
    private static int FLT = 2;
    private PDFFontToUnicodeMap toUnicodeMap;
    private boolean isCIDFont;
    private FontDict[] fontDicts;
    private FontDictSelector fontDictSelector;
    private int stemhints = 0;
    private float[] temps = new float[32];
    private int charsetbase = 0;
    private int encodingbase = 0;
    private int charstringbase = 0;
    private int privatebase = 0;
    private int privatesize = 0;
    private int gsubrbase = 0;
    private int lsubrbase = 0;
    private int gsubrsoffset = 0;
    private int lsubrsoffset = 0;
    private int nglyphs = 1;
    private int style = 0;
    private int fdarraybase;
    private int fdselectbase;

    public Type1CFont(String baseFont, PDFObject src, PDFFontDescriptor descriptor, String encodingType, PDFFontToUnicodeMap toUnicodeMap) throws PDFParseException {
        super(baseFont, src, descriptor, encodingType);
        this.toUnicodeMap = toUnicodeMap;
    }

    public Type1CFont(String baseFont, PDFObject src, PDFFontDescriptor descriptor, String encodingType, PDFDecrypter decryptor, PDFFontToUnicodeMap toUnicodeMap) throws PDFParseException {
        this(baseFont, src, descriptor, encodingType, toUnicodeMap);
        PDFObject dataObj = descriptor.getFontFile3();
        if (dataObj == null) {
            dataObj = descriptor.getFontFile2();
        }
        PDFXref ref = null;
        if (decryptor != null) {
            ref = dataObj.getRefValue();
        }
        this.data = dataObj.getStream(ref, decryptor, true);
        this.readData();
    }

    public Type1CFont(String baseFont, PDFObject src, PDFFontDescriptor descriptor, String encodingType, PDFFontToUnicodeMap toUnicodeMap, IDataBuffer fb) throws PDFParseException {
        this(baseFont, src, descriptor, encodingType, toUnicodeMap);
        this.data = new byte[fb.limit()];
        fb.get(this.data);
        this.readData();
    }

    public Type1CFont(String baseFont, PDFObject src, PDFFontDescriptor descriptor, String encodingType, PDFFontToUnicodeMap toUnicodeMap, byte[] data) throws PDFParseException {
        this(baseFont, src, descriptor, encodingType, toUnicodeMap);
        this.data = data;
        this.readData();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only command line values used")
    void readData() throws PDFParseException {
        this.pos = 0;
        if (DUMP_FONT_PATH != null) {
            File dumpFile = new File(DUMP_FONT_PATH, "embeddedType1C_" + this.getBaseFont() + "_" + Integer.toHexString(Arrays.hashCode(this.data)) + ".pfb");
            if (PDFParser.LOGGER.isDebug()) {
                PDFParser.LOGGER.debug((Object)("Type1CFont " + String.valueOf(this.getClass()) + ", SAVED AS " + String.valueOf(dumpFile)));
            }
            try {
                FileOutputStream out = new FileOutputStream(dumpFile);
                out.write(this.data);
                out.close();
            }
            catch (Exception ex) {
                PDFParser.LOGGER.error((Throwable)ex);
            }
        }
        this.parse();
    }

    private void printData() {
        Logger logger = PDFParser.LOGGER;
        char[] parts = new char[17];
        int partsloc = 0;
        StringBuilder debugText = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            int d = this.data[i] & 0xFF;
            parts[partsloc++] = d == 0 ? 46 : (d < 32 || d >= 127 ? 63 : (char)d);
            if (d < 16) {
                if (logger.isDebug()) {
                    debugText.append("0" + Integer.toHexString(d));
                }
            } else if (logger.isDebug()) {
                debugText.append(Integer.toHexString(d));
            }
            if ((i & 0xF) == 15) {
                if (logger.isDebug()) {
                    debugText.append("      " + new String(parts)).append("\n");
                }
                partsloc = 0;
                continue;
            }
            if ((i & 7) == 7) {
                if (logger.isDebug()) {
                    debugText.append("  ");
                }
                parts[partsloc++] = 32;
                continue;
            }
            if ((i & 1) != 1 || !logger.isDebug()) continue;
            debugText.append("  ");
        }
        if (logger.isDebug()) {
            logger.debug((Object)debugText.toString());
        }
    }

    private int readNext(boolean charstring) {
        this.num = this.data[this.pos++] & 0xFF;
        if (this.num == 12) {
            this.num = 1000 + (this.data[this.pos++] & 0xFF);
            return CMD;
        }
        if (this.num == 28) {
            this.num = (this.data[this.pos] << 8) + (this.data[this.pos + 1] & 0xFF);
            this.pos += 2;
            return NUM;
        }
        if (this.num == 29 && !charstring) {
            this.num = (this.data[this.pos] & 0xFF) << 24 | (this.data[this.pos + 1] & 0xFF) << 16 | (this.data[this.pos + 2] & 0xFF) << 8 | this.data[this.pos + 3] & 0xFF;
            this.pos += 4;
            return NUM;
        }
        if (this.num == 30 && !charstring) {
            this.readFNum();
            return FLT;
        }
        if (this.num < 32) {
            return CMD;
        }
        if (this.num < 247) {
            this.num -= 139;
            return NUM;
        }
        if (this.num < 251) {
            this.num = (this.num - 247) * 256 + (this.data[this.pos++] & 0xFF) + 108;
            return NUM;
        }
        if (this.num < 255) {
            this.num = -(this.num - 251) * 256 - (this.data[this.pos++] & 0xFF) - 108;
            return NUM;
        }
        if (!charstring) {
            this.printData();
            throw new RuntimeException("Got a 255 code while reading dict");
        }
        this.fnum = (float)((this.data[this.pos] & 0xFF) << 24 | (this.data[this.pos + 1] & 0xFF) << 16 | (this.data[this.pos + 2] & 0xFF) << 8 | this.data[this.pos + 3] & 0xFF) / 65536.0f;
        this.pos += 4;
        return FLT;
    }

    public void readFNum() {
        float f = 0.0f;
        boolean neg = false;
        int exp = 0;
        int eval = 0;
        float mul = 1.0f;
        byte work = this.data[this.pos++];
        while (true) {
            if (work == -35) {
                work = this.data[this.pos++];
            }
            int nyb = work >> 4 & 0xF;
            work = (byte)(work << 4 | 0xD);
            if (nyb < 10) {
                if (exp != 0) {
                    eval = eval * 10 + nyb;
                    continue;
                }
                if (mul == 1.0f) {
                    f = f * 10.0f + (float)nyb;
                    continue;
                }
                f += (float)nyb * mul;
                mul /= 10.0f;
                continue;
            }
            if (nyb == 10) {
                mul = 0.1f;
                continue;
            }
            if (nyb == 11) {
                exp = 1;
                continue;
            }
            if (nyb == 12) {
                exp = -1;
                continue;
            }
            if (nyb != 14) break;
            neg = true;
        }
        this.fnum = (float)(neg ? -1 : 1) * f * (float)Math.pow(10.0, eval * exp);
    }

    private int readInt(int len) {
        int n = 0;
        if (this.data.length < len + this.pos) {
            throw new ArrayIndexOutOfBoundsException(len + this.pos);
        }
        for (int i = 0; i < len; ++i) {
            n = n << 8 | this.data[this.pos++] & 0xFF;
        }
        return n;
    }

    private int readByte() {
        return this.data[this.pos++] & 0xFF;
    }

    public int getIndexSize(int loc) throws EOFException {
        int hold = this.pos;
        this.pos = loc;
        int count = this.readInt(2);
        if (count == 0) {
            return 2;
        }
        int encsz = this.readByte();
        this.pos += count * encsz;
        int end = this.readInt(encsz);
        this.pos = hold;
        return 2 + (count + 1) * encsz + end;
    }

    Range getIndexEntry(int index, int id) throws EOFException {
        int hold = this.pos;
        this.pos = index;
        int count = this.readInt(2);
        int encsz = this.readByte();
        this.pos += encsz * id;
        int from = this.readInt(encsz);
        Range r = new Range(from + 2 + index + encsz * (count + 1), this.readInt(encsz) - from);
        this.pos = hold;
        return r;
    }

    private void readDict(Range r) throws EOFException {
        this.pos = r.getStart();
        while (this.pos < r.getEnd()) {
            int cmd = this.readCommand(false);
            if (cmd == 15) {
                this.charsetbase = (int)this.stack[0];
            } else if (cmd == 16) {
                this.encodingbase = (int)this.stack[0];
            } else if (cmd == 17) {
                this.charstringbase = (int)this.stack[0];
            } else if (cmd == 18) {
                this.privatesize = (int)this.stack[0];
                this.privatebase = (int)this.stack[1];
            } else if (cmd == 19) {
                this.lsubrbase = (int)this.stack[0];
                this.lsubrbase += this.privatebase;
                this.lsubrsoffset = this.calcoffset(this.lsubrbase);
            } else if (cmd != 1006) {
                if (cmd == 1007) {
                    this.at = this.stackptr == 4 ? new AffineTransform(this.stack[0], this.stack[1], this.stack[2], this.stack[3], 0.0f, 0.0f) : new AffineTransform(this.stack[0], this.stack[1], this.stack[2], this.stack[3], this.stack[4], this.stack[5]);
                } else if (cmd == 1030) {
                    this.isCIDFont = true;
                    if (this.stackptr < 3) {
                        throw new IllegalStateException("stack size for ros command is too small");
                    }
                } else if (cmd == 1036) {
                    this.fdarraybase = (int)this.stack[0];
                } else if (cmd == 1037) {
                    this.fdselectbase = (int)this.stack[0];
                } else if (cmd >= 22 && cmd <= 27 || cmd == 31 || cmd == 255 || cmd == 1015 || cmd == 1016 || cmd >= 1024 && cmd <= 1029 || cmd > 1039) {
                    PDFParser.LOGGER.debug((Object)("Type1CFont CMD not specified because it is '-Reserved-' " + cmd));
                } else if (cmd == 10) {
                    PDFParser.LOGGER.debug((Object)("Type1CFont CMD (StdHW) not implemented " + cmd + "\tStack => " + Arrays.toString(this.stack)));
                } else if (cmd == 11) {
                    PDFParser.LOGGER.debug((Object)("Type1CFont CMD (StdVW) not implemented " + cmd + "\tStack => " + Arrays.toString(this.stack)));
                } else if (cmd == 20) {
                    PDFParser.LOGGER.debug((Object)("Type1CFont CMD (defaultWidthX) not implemented " + cmd + "\tStack => " + Arrays.toString(this.stack)));
                } else if (cmd == 21) {
                    PDFParser.LOGGER.debug((Object)("Type1CFont CMD (nominalWidthX) not implemented " + cmd + "\tStack => " + Arrays.toString(this.stack)));
                } else {
                    PDFParser.LOGGER.debug((Object)("Type1CFont CMD not implemented " + cmd + "\tStack => " + Arrays.toString(this.stack)));
                }
            }
            this.stackptr = 0;
        }
    }

    private void readFontDict(Range r, FontDict fontDict) {
        this.glyphTransform = null;
        this.pos = r.getStart();
        while (this.pos < r.getEnd()) {
            int cmd = this.readCommand(false);
            switch (cmd) {
                case 18: {
                    int privatesize = (int)this.stack[0];
                    fontDict.setSizeOfPrivateDict(privatesize);
                    int privatebase = (int)this.stack[1];
                    fontDict.setLocationOfPrivateDict(privatebase);
                    break;
                }
                case 1038: {
                    break;
                }
                case 1007: {
                    if (this.stackptr == 4) {
                        this.glyphTransform = new AffineTransform(this.stack[0], this.stack[1], this.stack[2], this.stack[3], 0.0f, 0.0f);
                        break;
                    }
                    if (this.stackptr < 6) break;
                    this.glyphTransform = new AffineTransform(this.stack[0], this.stack[1], this.stack[2], this.stack[3], this.stack[4], this.stack[5]);
                    break;
                }
                default: {
                    if (!PDFParser.LOGGER.isDebug()) break;
                    PDFParser.LOGGER.debug((Object)("invalid command in FontDictionary: " + cmd));
                }
            }
            this.stackptr = 0;
        }
    }

    private void readPrivateDict(Range r, FontDict fontDict) throws EOFException {
        this.pos = r.getStart();
        while (this.pos < r.getEnd()) {
            int cmd = this.readCommand(false);
            switch (cmd) {
                case 19: {
                    int lsubrbase = (int)this.stack[0];
                    fontDict.setSubrOffset(lsubrbase);
                    int currPos = this.pos;
                    this.pos = lsubrbase + fontDict.getLocationOfPrivateDict();
                    int sbrCount = this.readInt(2);
                    this.pos = currPos;
                    fontDict.setSubrBias(sbrCount);
                }
            }
            this.stackptr = 0;
        }
    }

    private int readCommand(boolean charstring) {
        int t;
        while ((t = this.readNext(charstring)) != CMD) {
            this.stack[this.stackptr++] = t == NUM ? (float)this.num : this.fnum;
        }
        return this.num;
    }

    private void readEncodingData(int base) {
        if (base == 0) {
            System.arraycopy(FontSupport.standardEncoding, 0, this.encoding, 0, FontSupport.standardEncoding.length);
        } else if (base == 1) {
            System.arraycopy(FontSupport.expertEncoding, 0, this.encoding, 0, FontSupport.expertEncoding.length);
        } else {
            this.pos = base;
            int encodingtype = this.readByte();
            if ((encodingtype & 0x7F) == 0) {
                int ncodes = this.readByte();
                int i = 1;
                while (i < ncodes + 1) {
                    int idx = this.readByte() & 0xFF;
                    this.encoding[idx] = i++;
                }
            } else if ((encodingtype & 0x7F) == 1) {
                int nranges = this.readByte();
                int p = 1;
                for (int i = 0; i < nranges; ++i) {
                    int start = this.readByte();
                    int more = this.readByte();
                    for (int j = start; j < start + more + 1; ++j) {
                        this.encoding[j] = p++;
                    }
                }
            } else if (PDFParser.LOGGER.isDebug()) {
                PDFParser.LOGGER.debug((Object)("Bad encoding type: " + encodingtype));
            }
        }
    }

    @Override
    public PDFDrawTextCmd.UnicodeConvertResult decodeText(String text, boolean isAlreadyTwoByte, boolean forDrawString) {
        if (forDrawString || this.encodingbase != 0) {
            return super.decodeText(text, isAlreadyTwoByte, forDrawString);
        }
        if (this.getUnicodeMapping() == null && this.getEncoding() == null && (this.encodingType == null || this.encodingType.contains("Standard"))) {
            ArrayList<PDFDrawTextCmds.ContentModification> changes = null;
            StringBuilder sb = new StringBuilder();
            char[] chars = text.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                char mapped = this.mapCharacter(this.encodingbase, c);
                if (mapped != '\uffff') {
                    sb.append(mapped);
                    continue;
                }
                if (changes == null) {
                    changes = new ArrayList<PDFDrawTextCmds.ContentModification>();
                }
                changes.add(new PDFDrawTextCmds.ContentModification(i, 0));
            }
            return new PDFDrawTextCmd.UnicodeConvertResult(sb.toString(), changes);
        }
        return super.decodeText(text, isAlreadyTwoByte, forDrawString);
    }

    @Override
    public char mapCharacter(char src, boolean forDrawString) {
        PDFFontToUnicodeMap map;
        if (forDrawString) {
            char character;
            CharCharMap extraCharacters;
            CharCharMap charCharMap = extraCharacters = this.getParent() == null ? this.getExtraCharacters() : this.getParent().getExtraCharacters();
            if (extraCharacters != null && (character = extraCharacters.get(src)) != '\uffff') {
                return character;
            }
        }
        if ((map = this.getUnicodeMapping()) != null) {
            StringBuilder sb = new StringBuilder();
            map.addUnicodeValues(src, sb, this);
            if (sb.length() == 1) {
                return sb.charAt(0);
            }
            return '\uffff';
        }
        if (this.getEncoding() != null) {
            Character charFromEncoding = this.getEncoding().getCharFromEncoding(src);
            if (charFromEncoding != null) {
                return charFromEncoding.charValue();
            }
            char index = (char)this.mapGIDtoCID(src);
            if (index < FontSupport.STD_STRINGS_ASTEXT.length) {
                return FontSupport.STD_STRINGS_ASTEXT[index].charAt(0);
            }
            if (RETURN_ZERO_IF_NULL) {
                return '\u0000';
            }
            if (RETURN_FFFF_IF_NULL) {
                return '\uffff';
            }
        }
        if (this.getParent() != null) {
            return this.getParent().mapCharacter(src, forDrawString);
        }
        return src;
    }

    public char mapCharacter(int base, char c) {
        if (c < this.encoding.length) {
            int index = this.encoding[c];
            if (index < FontSupport.STD_STRINGS_ASTEXT.length) {
                return FontSupport.STD_STRINGS_ASTEXT[index].charAt(0);
            }
            PDFParser.LOGGER.debug((Object)("Type1CFont - Bad SID for character : " + c));
        } else {
            PDFParser.LOGGER.debug((Object)("Type1CFont - Bad encoding for character : " + c));
        }
        return c;
    }

    private void readGlyphNames(int base) throws EOFException {
        block10: {
            int t;
            block11: {
                block9: {
                    if (base == 0) {
                        this.glyphnames = new int[229];
                        for (int i = 0; i < this.glyphnames.length; ++i) {
                            this.glyphnames[i] = i;
                        }
                        return;
                    }
                    if (base == 1) {
                        this.glyphnames = FontSupport.type1CExpertCharset;
                        return;
                    }
                    if (base == 2) {
                        this.glyphnames = FontSupport.type1CExpertSubCharset;
                        return;
                    }
                    this.glyphnames = new int[this.nglyphs];
                    this.glyphnames[0] = 0;
                    this.pos = base;
                    t = this.readByte();
                    if (t != 0) break block9;
                    for (int i = 1; i < this.nglyphs; ++i) {
                        this.glyphnames[i] = this.readInt(2);
                    }
                    break block10;
                }
                if (t != 1) break block11;
                int n = 1;
                while (n < this.nglyphs) {
                    int sid = this.readInt(2);
                    int range = this.readByte() + 1;
                    int endOfRange = Math.min(this.nglyphs - n, range);
                    for (int i = 0; i < endOfRange; ++i) {
                        this.glyphnames[n++] = sid++;
                    }
                }
                break block10;
            }
            if (t != 2) break block10;
            int n = 1;
            while (n < this.nglyphs) {
                int sid = this.readInt(2);
                int range = this.readInt(2) + 1;
                int endOfRange = Math.min(this.nglyphs - n, range);
                for (int i = 0; i < endOfRange; ++i) {
                    this.glyphnames[n++] = sid++;
                }
            }
        }
    }

    private void readNames(int base) throws EOFException {
        this.pos = base;
        int nextra = this.readInt(2);
        this.names = new String[nextra];
        for (int i = 0; i < nextra; ++i) {
            Range r = this.getIndexEntry(base, i);
            this.names[i] = new String(this.data, r.getStart(), r.getLen());
        }
    }

    private void parse() throws PDFParseException {
        try {
            int majorVersion = this.readByte();
            int minorVersion = this.readByte();
            int hdrsz = this.readByte();
            int offsize = this.readByte();
            int fnames = hdrsz;
            int topdicts = fnames + this.getIndexSize(fnames);
            int theNames = topdicts + this.getIndexSize(topdicts);
            this.gsubrbase = theNames + this.getIndexSize(theNames);
            this.gsubrsoffset = this.calcoffset(this.gsubrbase);
            this.readNames(theNames);
            this.style |= this.getStyleFromName(this.getBaseFont());
            for (String name : this.names) {
                this.style |= this.getStyleFromName(name);
            }
            this.pos = topdicts;
            if (this.readInt(2) != 1) {
                throw new PDFParseException("Type1C font object contains multiple fonts");
            }
            Range r = this.getIndexEntry(fnames, 0);
            this.readDict(this.getIndexEntry(topdicts, 0));
            if (!this.isCIDFont) {
                try {
                    this.readDict(new Range(this.privatebase, this.privatesize));
                }
                catch (Exception ex) {
                    PDFParser.LOGGER.error((Throwable)ex);
                }
            }
            this.pos = this.charstringbase;
            this.nglyphs = this.readInt(2);
            this.readGlyphNames(this.charsetbase);
            if (this.isCIDFont) {
                this.readFontDicts();
                this.readFontDictSelector();
            } else {
                this.readEncodingData(this.encodingbase);
            }
        }
        catch (EOFException e) {
            throw PDFParseException.create(e);
        }
    }

    private int getNameIndex(String name) {
        int val = FontSupport.findName(name, FontSupport.STD_STRINGS);
        if (val == -1) {
            PDFFontDescriptor descr = this.getDescriptor();
            if (val == -1) {
                val = FontSupport.findName(name, this.names) + FontSupport.STD_STRINGS.length;
            }
        }
        return val;
    }

    private synchronized GeneralPath readGlyph(int base, int offset) throws EOFException {
        if (offset >= this.nglyphs) {
            if (!this.isGeneratingAWT()) {
                PDFParser.LOGGER.error((Object)String.format("glyph index %d is greater than glyph count %d", offset, this.nglyphs));
            } else if (PDFParser.LOGGER.isDebug() && !this.isCheckUnicodeMappingErrorIssued()) {
                PDFParser.LOGGER.debug((Object)String.format("glyph index %d is greater than glyph count %d", offset, this.nglyphs));
                this.setCheckUnicodeMappingErrorIssued();
            }
            return null;
        }
        GeneralPath gp = new GeneralPath();
        try {
            FlPoint pt = new FlPoint();
            Range r = this.getIndexEntry(base, offset);
            int hold = this.pos;
            this.stackptr = 0;
            this.stemhints = 0;
            gp.moveTo(0.0f, 0.0f);
            this.parseGlyph(r, gp, pt, offset);
            this.pos = hold;
        }
        catch (IllegalPathStateException | ArrayIndexOutOfBoundsException ex) {
            PDFParser.LOGGER.error((Throwable)ex);
        }
        if (this.glyphTransform != null) {
            this.glyphTransform.concatenate(this.at);
        } else {
            if (this.isCIDFont && this.errMessageFontMatrixInFdArrayNotDefinedCount == 0) {
                Logger logger = PDFParser.LOGGER;
                if (logger.isDebug()) {
                    logger.debug((Object)"FontMatrix in FDArray dictionary is not defined");
                }
                this.errMessageFontMatrixInFdArrayNotDefinedCount = 1;
            }
            this.glyphTransform = this.at;
        }
        gp.transform(this.glyphTransform);
        this.glyphTransform = null;
        return gp;
    }

    public int calcoffset(int base) throws EOFException {
        int count = this.getObjectCount(base);
        if (count < 1240) {
            return 107;
        }
        if (count < 33900) {
            return 1131;
        }
        return 32768;
    }

    public int getObjectCount(int loc) throws EOFException {
        int hold = this.pos;
        this.pos = loc;
        int count = this.readInt(2);
        this.pos = hold;
        return count;
    }

    public String getSID(int id) {
        if (id < FontSupport.STD_STRINGS.length) {
            return FontSupport.STD_STRINGS[id];
        }
        return this.names[id -= FontSupport.STD_STRINGS.length];
    }

    private void buildAccentChar(float x, float y, char b, char a, GeneralPath gp) {
        int[] originalEncoding = this.encoding;
        int originalEncodingBase = this.encodingbase;
        this.encoding = FontSupport.standardEncoding;
        this.encodingbase = 0;
        GeneralPath pathA = this.getOutline(a, this.getWidth(a, null));
        GeneralPath pathB = this.getOutline(b, this.getWidth(b, null));
        try {
            AffineTransform inverse = this.at.createInverse();
            if (pathB != null) {
                pathB.transform(inverse);
                gp.append(pathB, false);
            } else {
                PDFParser.LOGGER.warn((Object)("Glyph for Tpye1C Font " + a + " part B has not outline!"));
            }
            if (pathA != null) {
                AffineTransform xformA = AffineTransform.getTranslateInstance(x, y);
                xformA.concatenate(inverse);
                pathA.transform(xformA);
                gp.append(pathA, false);
            } else {
                PDFParser.LOGGER.warn((Object)("Glyph for Tpye1C Font " + a + " part A has not outline!"));
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        this.encoding = originalEncoding;
        this.encodingbase = originalEncodingBase;
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="Not for security, only for random choice")
    void parseGlyph(Range r, GeneralPath gp, FlPoint pt, int glyph) throws EOFException {
        this.pos = r.getStart();
        block48: while (this.pos < r.getEnd()) {
            int cmd = this.readCommand(true);
            int hold = 0;
            switch (cmd) {
                case 1: 
                case 3: {
                    this.stemhints += this.stackptr / 2;
                    this.stackptr = 0;
                    continue block48;
                }
                case 4: {
                    if (this.stackptr > 1) {
                        this.stack[0] = this.stack[1];
                    }
                    pt.y += this.stack[0];
                    if (pt.open) {
                        gp.closePath();
                    }
                    pt.open = false;
                    gp.moveTo(pt.x, pt.y);
                    this.stackptr = 0;
                    continue block48;
                }
                case 5: {
                    int i = 0;
                    while (i < this.stackptr) {
                        pt.x += this.stack[i++];
                        pt.y += this.stack[i++];
                        gp.lineTo(pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 6: {
                    int i = 0;
                    while (i < this.stackptr) {
                        if ((i & 1) == 0) {
                            pt.x += this.stack[i++];
                        } else {
                            pt.y += this.stack[i++];
                        }
                        gp.lineTo(pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 7: {
                    int i = 0;
                    while (i < this.stackptr) {
                        if ((i & 1) == 0) {
                            pt.y += this.stack[i++];
                        } else {
                            pt.x += this.stack[i++];
                        }
                        gp.lineTo(pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 8: {
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    int i = 0;
                    while (i < this.stackptr) {
                        x1 = pt.x + this.stack[i++];
                        y1 = pt.y + this.stack[i++];
                        x2 = x1 + this.stack[i++];
                        y2 = y1 + this.stack[i++];
                        pt.x = x2 + this.stack[i++];
                        pt.y = y2 + this.stack[i++];
                        gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 10: {
                    int i;
                    hold = this.pos;
                    if (this.isCIDFont && glyph != 0) {
                        int arg = (int)this.stack[--this.stackptr];
                        int fdIndex = this.fontDictSelector.getFontDictId(glyph);
                        FontDict fd = this.fontDicts[fdIndex];
                        int subrOffset = fd.getLocationOfPrivateDict() + fd.getSubrOffset();
                        int subrIndex = fd.getSubrIndex(arg);
                        Range lsubr = this.getIndexEntry(subrOffset, subrIndex);
                        this.parseGlyph(lsubr, gp, pt, glyph);
                    } else {
                        i = (int)(this.stack[--this.stackptr] + (float)this.lsubrsoffset);
                        Range lsubr = this.getIndexEntry(this.lsubrbase, i);
                        this.parseGlyph(lsubr, gp, pt, 0);
                    }
                    this.pos = hold;
                    continue block48;
                }
                case 11: {
                    return;
                }
                case 14: {
                    if (this.stackptr == 5 || this.stackptr == 4) {
                        char a = (char)this.stack[this.stackptr - 1];
                        this.buildAccentChar(this.stack[this.stackptr - 4], this.stack[this.stackptr - 3], (char)this.stack[this.stackptr - 2], a, gp);
                    }
                    if (pt.open) {
                        gp.closePath();
                    }
                    pt.open = false;
                    this.stackptr = 0;
                    continue block48;
                }
                case 18: {
                    this.stemhints += this.stackptr / 2;
                    this.stackptr = 0;
                    continue block48;
                }
                case 19: 
                case 20: {
                    this.stemhints += this.stackptr / 2;
                    this.pos += (this.stemhints - 1) / 8 + 1;
                    this.stackptr = 0;
                    continue block48;
                }
                case 21: {
                    if (this.stackptr > 2) {
                        this.stack[0] = this.stack[1];
                        this.stack[1] = this.stack[2];
                    }
                    pt.x += this.stack[0];
                    pt.y += this.stack[1];
                    if (pt.open) {
                        gp.closePath();
                    }
                    gp.moveTo(pt.x, pt.y);
                    pt.open = false;
                    this.stackptr = 0;
                    continue block48;
                }
                case 22: {
                    if (this.stackptr > 1) {
                        this.stack[0] = this.stack[1];
                    }
                    pt.x += this.stack[0];
                    if (pt.open) {
                        gp.closePath();
                    }
                    gp.moveTo(pt.x, pt.y);
                    pt.open = false;
                    this.stackptr = 0;
                    continue block48;
                }
                case 23: {
                    this.stemhints += this.stackptr / 2;
                    this.stackptr = 0;
                    continue block48;
                }
                case 24: {
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    int i = 0;
                    while (i < this.stackptr - 2) {
                        x1 = pt.x + this.stack[i++];
                        y1 = pt.y + this.stack[i++];
                        x2 = x1 + this.stack[i++];
                        y2 = y1 + this.stack[i++];
                        pt.x = x2 + this.stack[i++];
                        pt.y = y2 + this.stack[i++];
                        gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    }
                    pt.x += this.stack[i++];
                    pt.y += this.stack[i++];
                    gp.lineTo(pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 25: {
                    int i = 0;
                    while (i < this.stackptr - 6) {
                        pt.x += this.stack[i++];
                        pt.y += this.stack[i++];
                        gp.lineTo(pt.x, pt.y);
                    }
                    float x1 = pt.x + this.stack[i++];
                    float y1 = pt.y + this.stack[i++];
                    float x2 = x1 + this.stack[i++];
                    float y2 = y1 + this.stack[i++];
                    pt.x = x2 + this.stack[i++];
                    pt.y = y2 + this.stack[i++];
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 26: {
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    int i = 0;
                    if ((this.stackptr & 1) == 1) {
                        pt.x += this.stack[i++];
                    }
                    while (i < this.stackptr) {
                        x1 = pt.x;
                        y1 = pt.y + this.stack[i++];
                        x2 = x1 + this.stack[i++];
                        y2 = y1 + this.stack[i++];
                        pt.x = x2;
                        pt.y = y2 + this.stack[i++];
                        gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 27: {
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    int i = 0;
                    if ((this.stackptr & 1) == 1) {
                        pt.y += this.stack[i++];
                    }
                    while (i < this.stackptr) {
                        x1 = pt.x + this.stack[i++];
                        y1 = pt.y;
                        x2 = x1 + this.stack[i++];
                        y2 = y1 + this.stack[i++];
                        pt.x = x2 + this.stack[i++];
                        pt.y = y2;
                        gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 29: {
                    hold = this.pos;
                    int i = (int)(this.stack[--this.stackptr] + (float)this.gsubrsoffset);
                    Range gsubr = this.getIndexEntry(this.gsubrbase, i);
                    this.parseGlyph(gsubr, gp, pt, glyph);
                    this.pos = hold;
                    continue block48;
                }
                case 30: {
                    hold = 4;
                }
                case 31: {
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    int i = 0;
                    while (i < this.stackptr) {
                        boolean hv = (i + hold & 4) == 0;
                        x1 = pt.x + (hv ? this.stack[i++] : 0.0f);
                        y1 = pt.y + (hv ? 0.0f : this.stack[i++]);
                        x2 = x1 + this.stack[i++];
                        y2 = y1 + this.stack[i++];
                        pt.x = x2 + (hv ? 0.0f : this.stack[i++]);
                        pt.y = y2 + (hv ? this.stack[i++] : 0.0f);
                        if (i == this.stackptr - 1) {
                            if (hv) {
                                pt.x += this.stack[i++];
                            } else {
                                pt.y += this.stack[i++];
                            }
                        }
                        gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    }
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 1000: {
                    this.stackptr = 0;
                    continue block48;
                }
                case 1003: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = x1 != 0.0f && y1 != 0.0f ? 1.0f : 0.0f;
                    continue block48;
                }
                case 1004: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = x1 != 0.0f || y1 != 0.0f ? 1.0f : 0.0f;
                    continue block48;
                }
                case 1005: {
                    float x1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = x1 == 0.0f ? 1.0f : 0.0f;
                    continue block48;
                }
                case 1009: {
                    this.stack[this.stackptr - 1] = Math.abs(this.stack[this.stackptr - 1]);
                    continue block48;
                }
                case 1010: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = x1 + y1;
                    continue block48;
                }
                case 1011: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = y1 - x1;
                    continue block48;
                }
                case 1012: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = y1 / x1;
                    continue block48;
                }
                case 1014: {
                    this.stack[this.stackptr - 1] = -this.stack[this.stackptr - 1];
                    continue block48;
                }
                case 1015: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = x1 == y1 ? 1.0f : 0.0f;
                    continue block48;
                }
                case 1018: {
                    --this.stackptr;
                    continue block48;
                }
                case 1020: {
                    float x1;
                    int i = (int)this.stack[--this.stackptr];
                    this.temps[i] = x1 = this.stack[--this.stackptr];
                    continue block48;
                }
                case 1021: {
                    int i = (int)this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = this.temps[i];
                    continue block48;
                }
                case 1022: {
                    if (this.stack[this.stackptr - 2] > this.stack[this.stackptr - 1]) {
                        this.stack[this.stackptr - 4] = this.stack[this.stackptr - 3];
                    }
                    this.stackptr -= 3;
                    continue block48;
                }
                case 1023: {
                    this.stack[this.stackptr++] = (float)Math.random();
                    continue block48;
                }
                case 1024: {
                    float x1 = this.stack[--this.stackptr];
                    float y1 = this.stack[--this.stackptr];
                    this.stack[this.stackptr++] = y1 * x1;
                    continue block48;
                }
                case 1026: {
                    this.stack[this.stackptr - 1] = (float)Math.sqrt(this.stack[this.stackptr - 1]);
                    continue block48;
                }
                case 1027: {
                    float x1 = this.stack[this.stackptr - 1];
                    this.stack[this.stackptr++] = x1;
                    continue block48;
                }
                case 1028: {
                    float x1 = this.stack[this.stackptr - 1];
                    this.stack[this.stackptr - 1] = this.stack[this.stackptr - 2];
                    this.stack[this.stackptr - 2] = x1;
                    continue block48;
                }
                case 1029: {
                    int i = (int)this.stack[this.stackptr - 1];
                    if (i < 0) {
                        i = 0;
                    }
                    this.stack[this.stackptr - 1] = this.stack[this.stackptr - 2 - i];
                    continue block48;
                }
                case 1030: {
                    int i = (int)this.stack[--this.stackptr];
                    int n = (int)this.stack[--this.stackptr];
                    i = i > 0 ? (i %= n) : n - -i % n;
                    if (i <= 0) continue block48;
                    float[] roll = new float[n];
                    System.arraycopy(this.stack, this.stackptr - 1 - i, roll, 0, i);
                    System.arraycopy(this.stack, this.stackptr - 1 - n, roll, i, n - i);
                    System.arraycopy(roll, 0, this.stack, this.stackptr - 1 - n, n);
                    continue block48;
                }
                case 1034: {
                    float ybase;
                    float x1 = pt.x + this.stack[0];
                    float y1 = ybase = pt.y;
                    float x2 = x1 + this.stack[1];
                    float y2 = y1 + this.stack[2];
                    pt.x = x2 + this.stack[3];
                    pt.y = y2;
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    x1 = pt.x + this.stack[4];
                    y1 = pt.y;
                    x2 = x1 + this.stack[5];
                    y2 = ybase;
                    pt.x = x2 + this.stack[6];
                    pt.y = y2;
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 1035: {
                    float x1 = pt.x + this.stack[0];
                    float y1 = pt.y + this.stack[1];
                    float x2 = x1 + this.stack[2];
                    float y2 = y1 + this.stack[3];
                    pt.x = x2 + this.stack[4];
                    pt.y = y2 + this.stack[5];
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    x1 = pt.x + this.stack[6];
                    y1 = pt.y + this.stack[7];
                    x2 = x1 + this.stack[8];
                    y2 = y1 + this.stack[9];
                    pt.x = x2 + this.stack[10];
                    pt.y = y2 + this.stack[11];
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 1036: {
                    float ybase = pt.y;
                    float x1 = pt.x + this.stack[0];
                    float y1 = pt.y + this.stack[1];
                    float x2 = x1 + this.stack[2];
                    float y2 = y1 + this.stack[3];
                    pt.x = x2 + this.stack[4];
                    pt.y = y2;
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    x1 = pt.x + this.stack[5];
                    y1 = pt.y;
                    x2 = x1 + this.stack[6];
                    y2 = y1 + this.stack[7];
                    pt.x = x2 + this.stack[8];
                    pt.y = ybase;
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
                case 1037: {
                    float ybase = pt.y;
                    float xbase = pt.x;
                    float x1 = pt.x + this.stack[0];
                    float y1 = pt.y + this.stack[1];
                    float x2 = x1 + this.stack[2];
                    float y2 = y1 + this.stack[3];
                    pt.x = x2 + this.stack[4];
                    pt.y = y2 + this.stack[5];
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    x1 = pt.x + this.stack[6];
                    y1 = pt.y + this.stack[7];
                    x2 = x1 + this.stack[8];
                    y2 = y1 + this.stack[9];
                    if (Math.abs(x2 - xbase) > Math.abs(y2 - ybase)) {
                        pt.x = x2 + this.stack[10];
                        pt.y = ybase;
                    } else {
                        pt.x = xbase;
                        pt.y = y2 + this.stack[10];
                    }
                    gp.curveTo(x1, y1, x2, y2, pt.x, pt.y);
                    pt.open = true;
                    this.stackptr = 0;
                    continue block48;
                }
            }
            if (!PDFParser.LOGGER.isDebug()) continue;
            PDFParser.LOGGER.debug((Object)("ERROR! TYPE1C CHARSTRING CMD IS " + cmd));
        }
    }

    @Override
    protected GeneralPath getOutline(String name, float width) {
        try {
            int index = this.getNameIndex(name);
            if (index != -1) {
                for (int i = 0; i < this.glyphnames.length; ++i) {
                    if (this.glyphnames[i] != index) continue;
                    return this.readGlyph(this.charstringbase, i);
                }
            }
            return this.readGlyph(this.charstringbase, 0);
        }
        catch (EOFException e) {
            PDFParser.LOGGER.warn((Object)e);
            return null;
        }
    }

    @Override
    public PDFGlyph getGlyph(char src, String name, boolean isTwoByteChars) {
        char namedSrc;
        if (".notdef" == name && (namedSrc = (char)this.mapGIDtoCID(src)) != src) {
            name = FontSupport.getName(namedSrc);
        }
        return super.getGlyph(src, name, isTwoByteChars);
    }

    public int mapGIDtoCID(char gid) {
        if (gid < this.getFirstChar() || gid > this.getLastChar()) {
            return 65535;
        }
        int index = gid - this.getFirstChar() + 1;
        return index >= 0 && index < this.glyphnames.length ? this.glyphnames[index] : 65535;
    }

    @Override
    protected GeneralPath getOutline(char src, float width) {
        try {
            char index = src;
            if (this.encoding == null) {
                for (int i = 0; i < this.glyphnames.length; ++i) {
                    if (this.glyphnames[i] != index) continue;
                    return this.readGlyph(this.charstringbase, i);
                }
            } else if (this.encodingbase == 0 || this.encodingbase == 1) {
                for (int i = 0; i < this.glyphnames.length; ++i) {
                    if (this.glyphnames[i] != this.encoding[index]) continue;
                    return this.readGlyph(this.charstringbase, i);
                }
            } else if (index >= '\u0000' && index < this.encoding.length) {
                return this.readGlyph(this.charstringbase, this.encoding[index]);
            }
        }
        catch (EOFException e) {
            PDFParser.LOGGER.warn((Object)e);
        }
        return null;
    }

    @Override
    public PDFFontToUnicodeMap getUnicodeMapping() {
        return this.toUnicodeMap;
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    private void readFontDicts() throws EOFException {
        int i;
        this.pos = this.fdarraybase;
        int fontDictCout = this.readInt(2);
        this.fontDicts = new FontDict[fontDictCout];
        for (i = 0; i < fontDictCout; ++i) {
            this.fontDicts[i] = new FontDict();
            this.readFontDict(this.getIndexEntry(this.fdarraybase, i), this.fontDicts[i]);
        }
        for (i = 0; i < fontDictCout; ++i) {
            Range range = new Range(this.fontDicts[i].getLocationOfPrivateDict(), this.fontDicts[i].getSizeOfPrivateDict());
            this.readPrivateDict(range, this.fontDicts[i]);
        }
    }

    private void readFontDictSelector() throws EOFException {
        this.pos = this.fdselectbase;
        int format = this.readInt(1);
        this.fontDictSelector = new FontDictSelector(this.nglyphs);
        switch (format) {
            case 0: {
                for (int i = 0; i < this.nglyphs; ++i) {
                    this.fontDictSelector.setFontDict(i, this.readInt(1));
                }
                break;
            }
            case 3: {
                int numberOfRanges = this.readInt(2);
                if (numberOfRanges == 0) break;
                int firstGlyphIndex = this.readInt(2);
                for (int i = 0; i < numberOfRanges; ++i) {
                    int fontDictIndex = this.readInt(1);
                    int startIndexOfTheNextGroup = this.readInt(2);
                    this.fontDictSelector.setFontDict(firstGlyphIndex, startIndexOfTheNextGroup, fontDictIndex);
                    firstGlyphIndex = startIndexOfTheNextGroup;
                }
                break;
            }
            default: {
                PDFParser.LOGGER.error((Object)("Unsupported FD Select format in Font1C: " + format));
            }
        }
    }

    private String getCmdName(int cmd) {
        switch (cmd) {
            case 1: {
                return "hstem";
            }
            case 3: {
                return "vstem";
            }
            case 4: {
                return "vmoveto";
            }
            case 5: {
                return "rlineto";
            }
            case 6: {
                return "hlineto";
            }
            case 7: {
                return "vlineto";
            }
            case 8: {
                return "rrcurveto";
            }
            case 10: {
                return "callsubr";
            }
            case 11: {
                return "return";
            }
            case 14: {
                return "endchar";
            }
            case 18: {
                return "hstemhm";
            }
            case 19: {
                return "hintmask";
            }
            case 20: {
                return "cntrmask";
            }
            case 21: {
                return "rmoveto";
            }
            case 22: {
                return "hmoveto";
            }
            case 23: {
                return "vstemhm";
            }
            case 24: {
                return "rcurveline";
            }
            case 25: {
                return "rlinecurve";
            }
            case 26: {
                return "vvcurveto";
            }
            case 27: {
                return "hhcurveto";
            }
            case 29: {
                return "callgsubr";
            }
            case 30: {
                return "vhcurveto";
            }
            case 31: {
                return "hvcurveto";
            }
            case 1000: {
                return "old dotsection command.  ignore.";
            }
            case 1003: {
                return "and";
            }
            case 1004: {
                return "or";
            }
            case 1005: {
                return "not";
            }
            case 1009: {
                return "abs";
            }
            case 1010: {
                return "add";
            }
            case 1011: {
                return "sub";
            }
            case 1012: {
                return "div";
            }
            case 1014: {
                return "neg";
            }
            case 1015: {
                return "eq";
            }
            case 1018: {
                return "drop";
            }
            case 1020: {
                return "put";
            }
            case 1021: {
                return "get";
            }
            case 1022: {
                return "ifelse";
            }
            case 1023: {
                return "random";
            }
            case 1024: {
                return "mul";
            }
            case 1026: {
                return "sqrt";
            }
            case 1027: {
                return "dup";
            }
            case 1028: {
                return "exch";
            }
            case 1029: {
                return "index";
            }
            case 1030: {
                return "roll";
            }
            case 1034: {
                return "hflex";
            }
            case 1035: {
                return "flex";
            }
            case 1036: {
                return "hflex1";
            }
            case 1037: {
                return "flex1";
            }
        }
        return "notdefined";
    }

    boolean isCIDType1C() {
        return this.isCIDFont;
    }

    GeneralPath readGlyph(int glyphIndex) throws EOFException {
        return this.readGlyph(this.charstringbase, glyphIndex);
    }

    private class Range {
        private int start;
        private int len;

        public Range(int start, int len) {
            this.start = start;
            this.len = len;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getLen() {
            return this.len;
        }

        public final int getEnd() {
            return this.start + this.len;
        }
    }
}

