/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFPage;
import com.inet.pdfview.command.PDFShapeCmd;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class PDFGlyph {
    private char src;
    private String name;
    private Point2D advance;
    private GeneralPath shape;
    private PDFPage page;

    public PDFGlyph(char src, String name, GeneralPath shape, Point2D.Float advance) {
        this.shape = shape;
        this.advance = advance;
        this.src = src;
        this.name = name;
    }

    public PDFGlyph(char src, String name, PDFPage page, Point2D advance) {
        this.page = page;
        this.advance = advance;
        this.src = src;
        this.name = name;
    }

    public char getChar() {
        return this.src;
    }

    public String getName() {
        return this.name;
    }

    public GeneralPath getShape() {
        return this.shape;
    }

    public PDFPage getPage() {
        return this.page;
    }

    public Point2D addCommands(PDFPage cmds, AffineTransform transform, int mode) {
        if (this.shape != null) {
            GeneralPath outline = (GeneralPath)this.shape.createTransformedShape(transform);
            cmds.addCommand(new PDFShapeCmd(outline, mode, true, cmds.getPageIndex()));
        } else if (this.page != null) {
            cmds.addCommands(this.page, transform);
        }
        return this.advance;
    }

    public Point2D getAdvance() {
        return this.advance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.advance == null ? 0 : this.advance.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.src;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PDFGlyph other = (PDFGlyph)obj;
        if (this.advance == null ? other.advance != null : !this.advance.equals(other.advance)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.src == other.src;
    }

    public void setSrcCode(char src) {
        this.src = src;
    }
}

