/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFTextFormat;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.ExtensionCharacterMap;
import com.inet.pdfview.font.FontSupport;
import com.inet.pdfview.font.PDFCIDMap;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFGlyph;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class PDFFontToUnicodeMap {
    private static Charset DEFAULT_CHARSET;
    public static final char UNKNOWCHARACTER = '\uef80';
    public static final int COMPLIANCE_FORM = 0;
    public static final int NAMED_INDENTITY_H = 1;
    public static final int NAMED_INDENTITY_V = 2;
    public static final int NAMED_UNDEFINED = 3;
    public static final int DERIVED_FROM_CMAP = 4;
    private static final int CHAR_NOT_DEFINED = -1;
    private static final int REPLACEMENT_CHAR = 65533;
    static final int START_MULTICHAR_CODE = 65536;
    private int type = 0;
    private int position;
    private int[] mapCharCodeToUnicode;
    private List<char[]> srcCode2MultiCharsCode = new ArrayList<char[]>();
    private PDFCIDMap cidMap;
    private boolean[] charCodeSizeAvailable = new boolean[4];
    private int minChar = -1;
    private int maxChar = -1;
    private int[][] spaceRanges;
    private int[][] spaceHighRanges;
    private int[][] spaceLowRanges;
    private int[] rangeByteCounts;
    private ExtensionCharacterMap indirectExtensionMap;
    private boolean hasCmap = true;

    private PDFFontToUnicodeMap() {
    }

    public PDFFontToUnicodeMap(PDFObject toUnicodeObj, PDFDecrypter decryptor, ExtensionCharacterMap indirectMap) throws PDFParseException {
        this.indirectExtensionMap = indirectMap;
        try {
            if (toUnicodeObj.getType() == 4) {
                String name = toUnicodeObj.getStringValue();
                if ("Identity-H".equals(name)) {
                    this.setType(1);
                } else if ("Identity-V".equals(name)) {
                    this.setType(2);
                } else {
                    this.setType(3);
                    PDFParser.LOGGER.error((Object)("Unknown type of to unicode mapping:" + name));
                }
                return;
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        byte[] arr = null;
        try {
            PDFXref ref = null;
            if (decryptor != null) {
                ref = toUnicodeObj.getRefValue();
            }
            arr = toUnicodeObj.getStream(ref, decryptor, false);
        }
        catch (Throwable th) {
            throw PDFParseException.create(th);
        }
        this.parse(arr);
    }

    public PDFFontToUnicodeMap(byte[] arr) {
        this.parse(arr);
    }

    public PDFFontToUnicodeMap(int[] cidToUnicode) {
        this.minChar = 0;
        this.maxChar = cidToUnicode.length - 1;
        this.mapCharCodeToUnicode = cidToUnicode;
        this.type = 4;
    }

    public static PDFFontToUnicodeMap getNamedMapping(String mappingName) {
        PDFFontToUnicodeMap map = new PDFFontToUnicodeMap();
        if ("Identity-H".equals(mappingName)) {
            map.setType(1);
        } else if ("Identity-V".equals(mappingName)) {
            map.setType(2);
        } else {
            map.setType(3);
            PDFParser.LOGGER.error((Object)"Unknown type of to unicode mapping");
        }
        return map;
    }

    public boolean isHasCmap() {
        return this.hasCmap;
    }

    private void parse(byte[] arr) {
        if (arr != null) {
            int startpos;
            String toUnicode = new String(arr, DEFAULT_CHARSET);
            String patternStr = "/CMapName\\s*/Identity-H\\s*def";
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(toUnicode);
            boolean isNamedIdentity = matcher.find();
            int i0 = toUnicode.indexOf("begincodespacerange");
            if (i0 == -1) {
                if (isNamedIdentity) {
                    this.type = 1;
                    return;
                }
                throw new IllegalStateException("invalid map: string 'begincodespacerange' has not been found in " + toUnicode);
            }
            int numberOfCodeSpaceRanges = PDFFontToUnicodeMap.getPreviousNumber(toUnicode, i0, "begincodespacerange");
            this.position = i0 + "begincodespacerange".length();
            this.spaceRanges = new int[numberOfCodeSpaceRanges][2];
            this.spaceLowRanges = new int[numberOfCodeSpaceRanges][2];
            this.spaceHighRanges = new int[numberOfCodeSpaceRanges][2];
            this.rangeByteCounts = new int[numberOfCodeSpaceRanges];
            for (int i = 0; i < numberOfCodeSpaceRanges; ++i) {
                int countOfBytes1;
                int countOfBytes0 = this.readParameter(toUnicode, this.spaceRanges[i], 0);
                if (countOfBytes0 != (countOfBytes1 = this.readParameter(toUnicode, this.spaceRanges[i], 1))) {
                    throw new IllegalStateException("byte count is not valid: " + countOfBytes0 + "<>" + countOfBytes1);
                }
                this.rangeByteCounts[i] = countOfBytes0;
                int[] spaceRange = this.spaceRanges[i];
                int leftRange = spaceRange[0];
                int rightRange = spaceRange[1];
                int leftLowByte = leftRange & 0xFF;
                int leftHighByte = leftRange >> 8 & 0xFF;
                int rightLowByte = rightRange & 0xFF;
                int rightHighByte = rightRange >> 8 & 0xFF;
                this.spaceLowRanges[i][0] = leftLowByte;
                this.spaceLowRanges[i][1] = rightLowByte;
                this.spaceHighRanges[i][0] = leftHighByte;
                this.spaceHighRanges[i][1] = rightHighByte;
            }
            if (toUnicode.indexOf("endcodespacerange") == -1) {
                throw new IllegalStateException("invalid map: cannot find 'endcodespacerange' in " + toUnicode);
            }
            ArrayList<BFRange> bfRangeList = new ArrayList<BFRange>();
            int fromPos = 0;
            int numberOfBfRanges = 0;
            while ((startpos = toUnicode.indexOf("beginbfrange", fromPos)) != -1) {
                numberOfBfRanges = PDFFontToUnicodeMap.getPreviousNumber(toUnicode, startpos, "beginbfrange");
                int[] bfAttr = new int[2];
                this.position = startpos + "beginbfrange".length();
                for (int i = 0; i < numberOfBfRanges; ++i) {
                    int countOfBytes0 = this.readParameter(toUnicode, bfAttr, 0);
                    this.setByteCount(countOfBytes0);
                    this.readParameter(toUnicode, bfAttr, 1);
                    BFRange bfRange2 = this.readBF2(toUnicode, bfAttr[0], bfAttr[1]);
                    bfRangeList.add(bfRange2);
                    this.checkMinAndMaxSrcCode(bfAttr[0]);
                    this.checkMinAndMaxSrcCode(bfAttr[1]);
                }
                fromPos = toUnicode.indexOf("endbfrange", startpos);
                if (fromPos != -1) continue;
                throw new IllegalStateException("invalid map: cannot find 'endbfrange' in " + toUnicode);
            }
            ArrayList<BFRange> bfCharList = new ArrayList<BFRange>();
            fromPos = 0;
            int numberOfbfChars = 0;
            while ((startpos = toUnicode.indexOf("beginbfchar", fromPos)) != -1) {
                numberOfbfChars = PDFFontToUnicodeMap.getPreviousNumber(toUnicode, startpos, "beginbfchar");
                int[] bfAttr = new int[2];
                this.position = startpos + "beginbfchar".length();
                boolean potentiallyCorruptRange = false;
                for (int i = 0; i < numberOfbfChars; ++i) {
                    int countOfBytes0 = this.readParameter(toUnicode, bfAttr, 0);
                    if (countOfBytes0 == 0) {
                        potentiallyCorruptRange = true;
                        break;
                    }
                    this.setByteCount(countOfBytes0);
                    BFRange bfRange2 = this.readBF2(toUnicode, bfAttr[0], bfAttr[0]);
                    bfCharList.add(bfRange2);
                    this.checkMinAndMaxSrcCode(bfAttr[0]);
                }
                if ((fromPos = toUnicode.indexOf("endbfchar", startpos)) != -1) continue;
                if (potentiallyCorruptRange) break;
                throw new IllegalStateException("invalid map: cannot find 'endbfchar' in " + toUnicode);
            }
            if (numberOfBfRanges == 0 && numberOfbfChars == 0) {
                try {
                    this.cidMap = new PDFCIDMap(arr);
                    if (this.cidMap.isEmpty()) {
                        this.hasCmap = false;
                        this.cidMap = null;
                        this.mapCharCodeToUnicode = new int[0];
                    }
                }
                catch (IOException ex) {
                    PDFParser.LOGGER.error((Throwable)ex);
                }
            } else {
                int i;
                int size = this.minChar != -1 && this.maxChar != -1 ? this.maxChar - this.minChar + 1 : 0;
                this.mapCharCodeToUnicode = new int[size];
                for (i = 0; i < size; ++i) {
                    this.mapCharCodeToUnicode[i] = -1;
                }
                for (i = 0; i < bfRangeList.size(); ++i) {
                    BFRange bfRange = (BFRange)bfRangeList.get(i);
                    bfRange.writeRangeInArray(this);
                }
                for (i = 0; i < bfCharList.size(); ++i) {
                    BFRange bfRange = (BFRange)bfCharList.get(i);
                    int srcCode = bfRange.getFirstSrcCode();
                    char[] chars = bfRange.getFirstCodeData();
                    if (chars.length == 0) {
                        throw new IllegalStateException("fbchar is not defined");
                    }
                    if (chars.length == 1) {
                        this.setUnicodeMappingCode(srcCode, chars[0]);
                        continue;
                    }
                    this.addCharArray(srcCode, chars);
                }
            }
            if (this.indirectExtensionMap != null) {
                this.extendMappingToUnicode();
            }
        }
    }

    public static int getPreviousNumber(String str, int maxIndex, String rangeName) {
        int index;
        for (index = maxIndex - 1; index >= 0 && Character.isWhitespace(str.charAt(index)); --index) {
        }
        maxIndex = index;
        while (index >= 0 && Character.isDigit(str.charAt(index))) {
            --index;
        }
        if (index < maxIndex) {
            int value = Integer.parseInt(str.substring(index + 1, maxIndex + 1));
            return value;
        }
        throw new RuntimeException("invalid number parameter of " + rangeName);
    }

    private int readParameter(String toUnicode, int[] arr, int index) {
        char ch;
        while (Character.isWhitespace(toUnicode.charAt(this.position))) {
            ++this.position;
        }
        int startpos = this.position;
        StringBuilder strBuilder = new StringBuilder();
        if ((ch = toUnicode.charAt(this.position++)) == '<') {
            while (this.position < toUnicode.length() && ((ch = toUnicode.charAt(this.position++)) >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F')) {
                strBuilder.append(ch);
            }
            while (Character.isWhitespace(ch)) {
                ch = toUnicode.charAt(this.position++);
            }
            if (ch == '>') {
                int res;
                arr[index] = res = this.parseCharacter(strBuilder);
                return (this.position - startpos - 2) / 2;
            }
        } else if (ch == '[') {
            this.readArray();
            arr[index] = 0;
            return 0;
        }
        return 0;
    }

    private void readArray() {
        throw new UnsupportedOperationException("arrays in bfRanges are not implemented");
    }

    public int getUnicodeValue(int ch) {
        switch (this.getType()) {
            case 0: {
                if (this.cidMap != null) {
                    return this.cidMap.map((char)ch);
                }
                if (ch == 3328) {
                    ch = 13;
                }
                if (ch >= this.minChar && ch < this.minChar + this.mapCharCodeToUnicode.length) {
                    ch = this.mapCharCodeToUnicode[ch - this.minChar];
                    break;
                }
                if (PDFParser.LOGGER.isDebug()) {
                    PDFParser.LOGGER.debug((Object)("invalid character code: " + ch + " possible: [" + this.minChar + "," + (this.minChar + this.mapCharCodeToUnicode.length) + ")"));
                }
                ch = 0;
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                ch = 0;
            }
        }
        return ch;
    }

    public int[] getMapCharCodeToUnicode() {
        return this.mapCharCodeToUnicode;
    }

    public int getMinChar() {
        return this.minChar;
    }

    public int getMaxChar() {
        return this.maxChar;
    }

    public int[][] getSpaceRanges() {
        return this.spaceRanges;
    }

    private int parseCharacter(StringBuilder strBuilder) {
        if (strBuilder.length() % 4 == 3) {
            strBuilder.append('0');
        }
        if (strBuilder.length() <= 4) {
            return Integer.parseInt(strBuilder.toString(), 16);
        }
        int charCount = strBuilder.length() / 4;
        if (charCount == 1) {
            return Integer.parseInt(strBuilder.toString().substring(0, 4), 16);
        }
        char[] charArray = this.getCharArray(strBuilder);
        int res = this.srcCode2MultiCharsCode.size() + 65536;
        this.srcCode2MultiCharsCode.add(charArray);
        return res;
    }

    private char[] getCharArray(StringBuilder strBuilder) {
        char[] cb = null;
        int cbPos = 0;
        boolean isFirst = true;
        char recent = ' ';
        int start = 0;
        int charCount = strBuilder.length() - 1;
        for (int i = 0; i <= charCount; ++i) {
            char c = strBuilder.charAt(i);
            if (c != ' ' && i - start != 3 && i != charCount) continue;
            if (i == start) {
                ++start;
                continue;
            }
            if (isFirst) {
                recent = (char)Integer.parseInt(strBuilder.substring(start, i + (c == ' ' ? 0 : 1)), 16);
                isFirst = false;
            } else {
                if (cb == null) {
                    cb = new char[charCount / 2];
                    cb[cbPos++] = recent;
                }
                cb[cbPos++] = (char)Integer.parseInt(strBuilder.substring(start, i + (c == ' ' ? 0 : 1)), 16);
            }
            start = i + (c == ' ' ? 0 : 1);
        }
        if (cb != null) {
            char[] result = new char[cbPos];
            System.arraycopy(cb, 0, result, 0, cbPos);
            return result;
        }
        return new char[]{recent};
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public int addUnicodeValues(char srcCode, StringBuilder strBuilder, @Nullable PDFFont font) {
        switch (this.getType()) {
            case 0: {
                if (this.cidMap != null) {
                    strBuilder.append(this.cidMap.map(srcCode));
                    return 1;
                }
                if (srcCode == '\u0d00') {
                    srcCode = (char)13;
                }
                if (srcCode >= this.minChar && srcCode < this.minChar + this.mapCharCodeToUnicode.length) {
                    int res = this.mapCharCodeToUnicode[srcCode - this.minChar];
                    if (res == -1) {
                        if (font != null) {
                            String mapped;
                            PDFGlyph theGlyph;
                            Character charFromEncoding;
                            if (font.getEncoding() != null && (charFromEncoding = font.getEncoding().getCharFromEncoding(srcCode)) != null) {
                                strBuilder.append(charFromEncoding.charValue());
                                return 1;
                            }
                            List<PDFGlyph> glyphs = font.getGlyphs(new PDFTextFormat.TextWrapper("" + srcCode, true, null));
                            if (glyphs != null && glyphs.size() == 1 && (theGlyph = glyphs.get(0)) != null && theGlyph.getName() != null && (mapped = FontSupport.getCharForStandardName(theGlyph.getName())) != null) {
                                strBuilder.append(mapped);
                                return 1;
                            }
                        }
                        strBuilder.append('\uef80');
                        return 1;
                    }
                    if (res != 65533) {
                        if ((res & 0x10000) != 0) {
                            char[] charArray = this.srcCode2MultiCharsCode.get(res - 65536);
                            strBuilder.append(charArray);
                            return charArray.length;
                        }
                        strBuilder.append((char)res);
                        return 1;
                    }
                    strBuilder.append(this.mapOnNoMatch(srcCode, font));
                    return -1;
                }
                strBuilder.append(this.mapOnNoMatch(srcCode, font));
                return -1;
            }
            case 4: {
                if (srcCode < this.mapCharCodeToUnicode.length) {
                    strBuilder.append((char)this.mapCharCodeToUnicode[srcCode]);
                    return 1;
                }
                strBuilder.append(srcCode);
                return -1;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        strBuilder.append(srcCode);
        return 1;
    }

    private char mapOnNoMatch(char c, @Nullable PDFFont font) {
        Character charFromEncoding;
        if (font != null && font.getEncoding() != null && (charFromEncoding = font.getEncoding().getCharFromEncoding(c)) != null) {
            return charFromEncoding.charValue();
        }
        if (this.mapCharCodeToUnicode.length > 0 && c > '\u0000') {
            char fallback = (char)(c + this.mapCharCodeToUnicode[0] - this.minChar);
            return fallback;
        }
        return c;
    }

    public int findGlyphCode(char chr) {
        switch (this.getType()) {
            case 0: {
                if (this.cidMap != null) {
                    return this.cidMap.reverseMap(chr);
                }
                for (int i = 0; i < this.mapCharCodeToUnicode.length; ++i) {
                    if (this.mapCharCodeToUnicode[i] != chr) continue;
                    return i + this.minChar;
                }
                return chr;
            }
            case 4: {
                for (int i = 0; i < this.mapCharCodeToUnicode.length; ++i) {
                    if (this.mapCharCodeToUnicode[i] != chr) continue;
                    return i;
                }
                return chr;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        return chr;
    }

    private BFRange readBF2(String toUnicode, int first, int last) {
        while (Character.isWhitespace(toUnicode.charAt(this.position))) {
            ++this.position;
        }
        StringBuilder strBuilder = new StringBuilder();
        char ch = toUnicode.charAt(this.position);
        ArrayList<char[]> charList = null;
        if (ch == '[') {
            charList = new ArrayList<char[]>();
            ++this.position;
        }
        int len = toUnicode.length();
        while (this.position < len) {
            while (Character.isWhitespace(toUnicode.charAt(this.position))) {
                ++this.position;
            }
            if ((ch = toUnicode.charAt(this.position++)) == '<') {
                while (this.position < toUnicode.length() && ((ch = toUnicode.charAt(this.position++)) >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F' || ch == ' ')) {
                    strBuilder.append(ch);
                }
                while (Character.isWhitespace(ch)) {
                    ch = toUnicode.charAt(this.position++);
                }
                if (ch == '>') {
                    char[] arr = this.getCharArray(strBuilder);
                    if (charList == null) {
                        return new BFRange(first, last, arr);
                    }
                    charList.add(arr);
                    strBuilder.setLength(0);
                    continue;
                }
                throw new IllegalStateException("hex value is not defined");
            }
            if (ch == ']') {
                return new BFRange(first, last, charList);
            }
            throw new IllegalStateException("char array is not defined");
        }
        return null;
    }

    private void checkMinAndMaxSrcCode(int scrCode) {
        if (this.minChar == -1 || scrCode < this.minChar) {
            this.minChar = scrCode;
        }
        if (this.maxChar == -1 || scrCode > this.maxChar) {
            this.maxChar = scrCode;
        }
    }

    int addCharArray(int srcCode, char[] chars) {
        int mappingCode = 0;
        if (chars.length == 1) {
            mappingCode = chars[0];
        } else {
            mappingCode = this.srcCode2MultiCharsCode.size() + 65536;
            this.srcCode2MultiCharsCode.add(chars);
        }
        this.setUnicodeMappingCode(srcCode, mappingCode);
        return mappingCode;
    }

    private void setUnicodeMappingCode(int srcCode, int mappingCode) {
        this.mapCharCodeToUnicode[srcCode - this.minChar] = mappingCode;
    }

    private void setByteCount(int byteCount) {
        this.charCodeSizeAvailable[byteCount - 1] = true;
    }

    public boolean hasCharacterCodes(int byteCount) {
        return this.charCodeSizeAvailable[byteCount - 1];
    }

    void set(ExtensionCharacterMap indirectExtensionMap) {
        this.indirectExtensionMap = indirectExtensionMap;
    }

    void setMinChar(int val) {
        this.minChar = val;
    }

    void setMaxChar(int val) {
        this.maxChar = val;
    }

    void extendMappingToUnicode() {
        int lowerExtensionPartLength = 0;
        int upperExtensionPartLength = 0;
        if (this.indirectExtensionMap.getMinChar() < this.minChar) {
            lowerExtensionPartLength = this.minChar - this.indirectExtensionMap.getMinChar();
            this.minChar = this.indirectExtensionMap.getMinChar();
        }
        if (this.indirectExtensionMap.getMaxChar() > this.maxChar) {
            upperExtensionPartLength = this.indirectExtensionMap.getMaxChar() - this.maxChar;
            this.maxChar = this.indirectExtensionMap.getMaxChar();
        }
        if (lowerExtensionPartLength > 0 || upperExtensionPartLength > 0) {
            int i;
            int[] tmp = new int[this.mapCharCodeToUnicode.length + lowerExtensionPartLength + upperExtensionPartLength];
            for (i = 0; i < lowerExtensionPartLength; ++i) {
                tmp[i] = -1;
            }
            for (i = lowerExtensionPartLength; i < lowerExtensionPartLength + this.mapCharCodeToUnicode.length; ++i) {
                tmp[i] = this.mapCharCodeToUnicode[i - lowerExtensionPartLength];
            }
            for (i = lowerExtensionPartLength + this.mapCharCodeToUnicode.length; i < lowerExtensionPartLength + this.mapCharCodeToUnicode.length + upperExtensionPartLength; ++i) {
                tmp[i] = -1;
            }
            this.mapCharCodeToUnicode = tmp;
        }
        Set<Map.Entry<Character, Character>> set = this.indirectExtensionMap.getEntries();
        for (Map.Entry<Character, Character> entry : set) {
            char key = entry.getKey().charValue();
            char value = entry.getValue().charValue();
            if (this.mapCharCodeToUnicode[key - this.minChar] != -1) continue;
            this.mapCharCodeToUnicode[key - this.minChar] = value;
        }
    }

    static {
        try {
            DEFAULT_CHARSET = Charset.forName("UTF-8");
        }
        catch (Throwable th) {
            DEFAULT_CHARSET = Charset.defaultCharset();
        }
    }

    private static class BFRange {
        private int firstSrcCode;
        private int lastSrcCode;
        private char[] firstCodeData;
        private List<char[]> rangeDataList;

        BFRange(int firstSrcCode, int lastSrcCode, char[] firstCodeData) {
            this.firstSrcCode = firstSrcCode;
            this.lastSrcCode = lastSrcCode;
            this.firstCodeData = firstCodeData;
        }

        BFRange(int firstSrcCode, int lastSrcCode, List<char[]> rangeData) {
            this.firstSrcCode = firstSrcCode;
            this.lastSrcCode = lastSrcCode;
            this.rangeDataList = rangeData;
        }

        int getFirstSrcCode() {
            return this.firstSrcCode;
        }

        char[] getFirstCodeData() {
            return this.firstCodeData;
        }

        void writeRangeInArray(PDFFontToUnicodeMap map) {
            int bfRangeSize = this.lastSrcCode - this.firstSrcCode + 1;
            if (this.rangeDataList != null) {
                int codeSize = this.rangeDataList.size();
                if (codeSize != bfRangeSize) {
                    throw new IllegalStateException("invalid code array size");
                }
                for (int i = 0; i < codeSize; ++i) {
                    char[] chars = this.rangeDataList.get(i);
                    int srcCode = this.firstSrcCode + i;
                    map.addCharArray(srcCode, chars);
                }
            } else if (this.firstCodeData != null) {
                map.addCharArray(this.firstSrcCode, this.firstCodeData);
                int charCount = this.firstCodeData.length;
                for (int i = 1; i < bfRangeSize; ++i) {
                    char[] chars = new char[charCount];
                    for (int j = 0; j < charCount - 1; ++j) {
                        chars[j] = this.firstCodeData[j];
                    }
                    chars[charCount - 1] = (char)(this.firstCodeData[charCount - 1] + i);
                    int srcCode = this.firstSrcCode + i;
                    map.addCharArray(srcCode, chars);
                }
            } else {
                PDFParser.LOGGER.error((Object)"invalid range data");
            }
        }
    }
}

