/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decrypt;

import com.inet.logging.LogManager;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.decrypt.DecrypterAES128;
import com.inet.pdfview.decrypt.DecrypterAES256_Rev5and6;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.annotation.SuppressFBWarnings;

public class PDFDecrypter {
    private static final int PASSWORD_BLOCK_LENGTH = 32;
    static final int MAX_OBJECT_KEY_LENGTH = 16;
    static final int BASE_PERMISSIONS = -3904;
    static final int ALLOW_PRINT = 4;
    static final int ALLOW_MODIFY = 8;
    static final int ALLOW_COPY = 16;
    static final int ALLOW_MODIFY_ANNOTATIONS = 32;
    static final int ALLOW_FILL_FIELDS = 256;
    static final int ALLOW_EXTRACT = 512;
    static final int ALLOW_ASSEMBLE = 1024;
    static final int ALLOW_REPRESENTATION = 2048;
    private static final byte[] PAD_BYTES = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private byte[] encryptionKey;
    private MessageDigest messageDigest;

    PDFDecrypter(String userPassword, byte[] ownerEntryData, int permission, byte[] docIdData, int keyLength, int algorithmType, int handlerRevision, boolean isMetadataEncrypted) {
        this.encryptionKey = PDFDecrypter.calculateGeneralEncriptionKey(userPassword, ownerEntryData, docIdData, isMetadataEncrypted, permission, this.initMD5(), handlerRevision, keyLength);
    }

    public static PDFDecrypter getDecrypter(String userpassword, String oEntry, String uEntry, int permission, String docID, int keyLength, int algorithmVersion, int handlerRevision, boolean isHexString, String cryptFilterType, String oeEntry, String ueEntry, boolean encryptMetaData) {
        byte[] dataO = isHexString ? PDFDecrypter.hexStringToByteArray(oEntry) : PDFDecrypter.getArrayOfLowOrderBytes(oEntry);
        byte[] docIdData = null;
        if (docID != null) {
            docIdData = isHexString ? PDFDecrypter.hexStringToByteArray(docID) : PDFDecrypter.getArrayOfLowOrderBytes(docID);
        }
        switch (algorithmVersion) {
            case 0: 
            case 3: {
                throw new UnsupportedOperationException("Encryption algorithm with code " + algorithmVersion + " is not supported");
            }
            case 1: {
                if (keyLength == 40) break;
                LogManager.getApplicationLogger().warn((Object)("invalid key length: " + keyLength + " for algorithm version " + algorithmVersion + ": key length has been changed to the value of 40"));
                keyLength = 40;
                break;
            }
            case 4: {
                if ("V2".equals(cryptFilterType)) break;
                if ("AESV2".equals(cryptFilterType)) {
                    return new DecrypterAES128(userpassword, dataO, permission, docIdData, keyLength, algorithmVersion, handlerRevision, encryptMetaData);
                }
                throw new IllegalArgumentException("Parsing encrypted PDF files of this type is currently not supported: handlerRevision=" + handlerRevision + ";  algorithmVersion=" + algorithmVersion + ": filter type=" + cryptFilterType);
            }
            case 5: {
                if (!"AESV3".equals(cryptFilterType)) break;
                if (userpassword == null) {
                    userpassword = "";
                }
                return new DecrypterAES256_Rev5and6(userpassword, oEntry, uEntry, ueEntry, oeEntry, permission, docIdData, keyLength, handlerRevision, encryptMetaData);
            }
        }
        return new PDFDecrypter(userpassword, dataO, permission, docIdData, keyLength, algorithmVersion, handlerRevision, encryptMetaData);
    }

    public static byte[] calculateUserentry(PDFDecrypter decryptor, String docID, boolean isHexString) {
        byte[] key = PDFDecrypter.getPaddedPasswordBytes(decryptor.encryptionKey);
        MessageDigest md5 = PDFDecrypter.getMD5();
        md5.update(key);
        byte[] docIdData = isHexString ? PDFDecrypter.hexStringToByteArray(docID) : PDFDecrypter.getArrayOfLowOrderBytes(docID);
        byte[] result = md5.digest(docIdData);
        RC4 rc4 = new RC4();
        byte[] decrypt = rc4.initKey(key).crypt(result);
        for (int i = 0; i < 19; ++i) {
            byte[] iterationKey = new byte[key.length];
            System.arraycopy(key, 0, iterationKey, 0, key.length);
            for (int j = 0; j < key.length; ++j) {
                iterationKey[j] = (byte)(iterationKey[j] ^ (byte)i);
            }
            decrypt = rc4.initKey(iterationKey).crypt(decrypt);
        }
        return decrypt;
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="MD5 is a requirement of the PDF specification. It's only used to decode the input PDF files.")
    public static MessageDigest getMD5() {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Throwable th) {
            throw new RuntimeException("MD5 not available: " + th.getMessage());
        }
        return md5;
    }

    public byte[] decrypt(byte[] bytes, int length, int objNum, int revNum) {
        byte[] currentKey = this.computeObjectEncryptionKey(objNum, revNum);
        return new RC4().initKey(currentKey).decrypt(bytes, length);
    }

    public static byte[] calculateGeneralEncriptionKey(String userPassword, byte[] ownerEntryAsByteArray, byte[] docIdData, boolean isMetadataEncrypted, int permission, MessageDigest messageDigest, int handlerRevision, int keyLength) {
        byte[] encryptionKey = new byte[keyLength / 8];
        byte[] paddedUserPasswordBytes = PDFDecrypter.getPaddedPasswordBytes(PDFDecrypter.passwordStringToBytes(userPassword, null));
        messageDigest.update(paddedUserPasswordBytes);
        messageDigest.update(ownerEntryAsByteArray);
        messageDigest.update(PDFDecrypter.intToByteArray(permission));
        if (docIdData != null) {
            messageDigest.update(docIdData);
        }
        if (handlerRevision >= 4 && !isMetadataEncrypted) {
            messageDigest.update(PDFDecrypter.intToByteArray(-1));
        }
        byte[] md = messageDigest.digest();
        if (handlerRevision >= 3) {
            for (int k = 0; k < 50; ++k) {
                md = messageDigest.digest(md);
            }
        }
        System.arraycopy(md, 0, encryptionKey, 0, Math.min(md.length, encryptionKey.length));
        return encryptionKey;
    }

    public static byte[] calculateOwnerKey(String ownerPassword, String userPassword, boolean isHex, int revision, int length) {
        byte[] paddedUserPasswordBytes;
        byte[] ownerPasswordAsByteArray = isHex ? PDFDecrypter.hexStringToByteArray(ownerPassword) : PDFDecrypter.getArrayOfLowOrderBytes(ownerPassword);
        ownerPasswordAsByteArray = PDFDecrypter.getPaddedPasswordBytes(ownerPasswordAsByteArray);
        MessageDigest md5 = PDFDecrypter.getMD5();
        byte[] key = md5.digest(ownerPasswordAsByteArray);
        if (revision >= 3) {
            for (int i = 0; i < 50; ++i) {
                md5.reset();
                key = md5.digest(key);
            }
        }
        byte[] rcKey = Arrays.copyOf(key, revision > 2 ? Math.max(length, key.length) : 5);
        RC4 rc4 = new RC4().initKey(rcKey);
        byte[] encryptedUserPW = paddedUserPasswordBytes = PDFDecrypter.getPaddedPasswordBytes(PDFDecrypter.passwordStringToBytes(userPassword, null));
        if (revision >= 3) {
            for (int i = 0; i <= 19; ++i) {
                byte[] iterationKey = Arrays.copyOf(rcKey, rcKey.length);
                for (int j = 0; j < rcKey.length; ++j) {
                    iterationKey[j] = (byte)(iterationKey[j] ^ i);
                }
                encryptedUserPW = rc4.initKey(iterationKey).crypt(encryptedUserPW);
            }
        }
        return encryptedUserPW;
    }

    byte[] computeObjectEncryptionKey(int objNum, int revNum) {
        byte[] currentKey = null;
        if (this.getEncryptionKey() != null) {
            int n = this.getEncryptionKey().length;
            int size = n + 5;
            byte[] tmp = new byte[size];
            System.arraycopy(this.getEncryptionKey(), 0, tmp, 0, n);
            tmp[n] = (byte)objNum;
            tmp[n + 1] = (byte)(objNum >> 8);
            tmp[n + 2] = (byte)(objNum >> 16);
            tmp[n + 3] = (byte)revNum;
            tmp[n + 4] = (byte)(revNum >> 8);
            currentKey = this.initMD5().digest(tmp);
            int maxLengthOfObjectKey = Math.min(size, 16);
            if (currentKey.length > maxLengthOfObjectKey) {
                tmp = new byte[maxLengthOfObjectKey];
                System.arraycopy(currentKey, 0, tmp, 0, maxLengthOfObjectKey);
                currentKey = tmp;
            }
        }
        return currentKey;
    }

    private static byte[] getPaddedPasswordBytes(byte[] passwordBytes) {
        int paddingBytesCount;
        int len_to_copy = 0;
        byte[] paddedPasswordBytes = new byte[32];
        if (passwordBytes != null) {
            len_to_copy = Math.min(32, passwordBytes.length);
            System.arraycopy(passwordBytes, 0, paddedPasswordBytes, 0, len_to_copy);
        }
        if ((paddingBytesCount = 32 - len_to_copy) > 0) {
            System.arraycopy(PAD_BYTES, 0, paddedPasswordBytes, len_to_copy, paddingBytesCount);
        }
        return paddedPasswordBytes;
    }

    private static byte[] passwordStringToBytes(String password, String charEncoding) {
        if (password == null || password.length() == 0) {
            return null;
        }
        if (charEncoding == null) {
            charEncoding = "UTF8";
        }
        byte[] passwordBytes = null;
        try {
            passwordBytes = password.getBytes(charEncoding);
        }
        catch (Throwable th) {
            PDFParser.LOGGER.error((Object)("Error during password converting with encoding: " + charEncoding));
        }
        if (passwordBytes == null) {
            passwordBytes = PDFDecrypter.getBytes(password);
        }
        return passwordBytes;
    }

    private static byte[] getBytes(String string) {
        byte[] bytes = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            bytes[i] = (byte)string.charAt(i);
        }
        return bytes;
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="MD5 is a requirement of the PDF specification. It's only used to decode the input PDF files.")
    MessageDigest initMD5() {
        if (this.messageDigest == null) {
            try {
                this.messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (Throwable th) {
                throw new RuntimeException("MD5 not available: " + th.getMessage());
            }
        } else {
            this.messageDigest.reset();
        }
        return this.messageDigest;
    }

    private static byte[] intToByteArray(int i) {
        byte[] res = new byte[]{(byte)i, (byte)(i >> 8), (byte)(i >> 16), (byte)(i >> 24)};
        return res;
    }

    private static byte[] hexStringToByteArray(String hexData) {
        int size;
        int startPos;
        int endPos = hexData.length() - 1;
        for (startPos = 0; Character.isWhitespace(hexData.charAt(startPos)) && startPos < endPos; ++startPos) {
        }
        if (hexData.charAt(startPos) != '<') {
            throw new RuntimeException("invalid form of hex string: " + hexData);
        }
        while (Character.isWhitespace(hexData.charAt(endPos)) && endPos > startPos) {
            --endPos;
        }
        if (hexData.charAt(endPos) != '>') {
            throw new RuntimeException("invalid form of hex string: " + hexData);
        }
        if ((size = endPos - ++startPos) % 2 != 0) {
            throw new RuntimeException(" invalid count of bytes in hex string: " + hexData);
        }
        int byteSize = size / 2;
        byte[] byteData = new byte[byteSize];
        for (int i = 0; i < byteSize; ++i) {
            char ch = hexData.charAt(startPos + 2 * i);
            byte b1 = PDFDecrypter.readHexEncodedBytes(ch);
            ch = hexData.charAt(startPos + 2 * i + 1);
            byte b2 = PDFDecrypter.readHexEncodedBytes(ch);
            byteData[i] = (byte)(b1 << 4 & 0xF0 | b2);
        }
        return byteData;
    }

    private static byte readHexEncodedBytes(char ch) {
        byte res = 0;
        switch (ch) {
            case '0': {
                res = 0;
                break;
            }
            case '1': {
                res = 1;
                break;
            }
            case '2': {
                res = 2;
                break;
            }
            case '3': {
                res = 3;
                break;
            }
            case '4': {
                res = 4;
                break;
            }
            case '5': {
                res = 5;
                break;
            }
            case '6': {
                res = 6;
                break;
            }
            case '7': {
                res = 7;
                break;
            }
            case '8': {
                res = 8;
                break;
            }
            case '9': {
                res = 9;
                break;
            }
            case 'A': 
            case 'a': {
                res = 10;
                break;
            }
            case 'B': 
            case 'b': {
                res = 11;
                break;
            }
            case 'C': 
            case 'c': {
                res = 12;
                break;
            }
            case 'D': 
            case 'd': {
                res = 13;
                break;
            }
            case 'E': 
            case 'e': {
                res = 14;
                break;
            }
            case 'F': 
            case 'f': {
                res = 15;
                break;
            }
            default: {
                throw new RuntimeException("invalid hex character: " + ch);
            }
        }
        return res;
    }

    byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public static byte[] getArrayOfLowOrderBytes(String str) {
        byte[] data = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            data[i] = (byte)(str.charAt(i) & 0xFF);
        }
        return data;
    }

    public static class RC4 {
        private byte[] state = new byte[256];

        public byte[] crypt(byte[] source) {
            return this.decrypt(source, source.length);
        }

        public byte[] decrypt(byte[] source, int length) {
            byte[] dest = source;
            int i = 0;
            int j = 0;
            for (int k = 0; k < length; ++k) {
                i = i + 1 & 0xFF;
                j = this.state[i] + j & 0xFF;
                byte tmp = this.state[i];
                this.state[i] = this.state[j];
                this.state[j] = tmp;
                byte random = this.state[this.state[i] + this.state[j] & 0xFF];
                dest[k] = (byte)(source[k] ^ random);
            }
            return dest;
        }

        public RC4 initKey(byte[] key) {
            int j = 0;
            for (int k = 0; k < 256; ++k) {
                this.state[k] = (byte)k;
            }
            for (int i = 0; i < 256; ++i) {
                j = key[i % key.length] + this.state[i] + j & 0xFF;
                byte tmp = this.state[i];
                this.state[i] = this.state[j];
                this.state[j] = tmp;
            }
            return this;
        }
    }

    public static final class DecryptionExcpetion
    extends RuntimeException {
        private static final long serialVersionUID = -7719309824141276491L;
        private String filename;
        private boolean wasUsingPassword;

        public DecryptionExcpetion(Throwable cause, boolean wasUsingPassword) {
            super(cause);
            this.wasUsingPassword = wasUsingPassword;
        }

        public DecryptionExcpetion(Throwable cause, boolean wasUsingPassword, String fileName) {
            super(cause);
            this.wasUsingPassword = wasUsingPassword;
            this.filename = fileName;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean wasUsingPassword() {
            return this.wasUsingPassword;
        }
    }
}

