/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode.jpeg;

import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.jpeg.JpegAdobeSegment;
import com.inet.pdfview.decode.jpeg.JpegSegment;
import com.inet.pdfview.decode.jpeg.JpegSegmentReader;
import com.inet.pdfview.decode.jpeg.JpegStartOfFrameSegment;
import java.util.List;
import java.util.Map;

public class JpegImageInfo {
    public static final int COLOR_TRANSFORM_NOT_DEFINED = -1;
    private static final int ADOBE_COLOR_TRANSFORM_CODE0 = 0;
    private static final int ADOBE_COLOR_TRANSFORM_CODE1 = 1;
    private static final int ADOBE_COLOR_TRANSFORM_CODE2 = 2;
    private int adobeColorTransform = -1;
    private int numberOfComponent;
    public static final int DATA_FORMAT_YCCK = 2;
    public static final int DATA_FORMAT_YCbCr = 1;
    public static final int DATA_FORMAT_ADOBE_CMYK = 0;
    public static final int DATA_FORMAT_RGB = 3;

    private JpegImageInfo(int numberOfComponent, int[] compsId, int adobeColorTransform) {
        this.numberOfComponent = numberOfComponent;
        this.adobeColorTransform = adobeColorTransform;
    }

    public int getAdobeColorTransform() {
        return this.adobeColorTransform;
    }

    public static JpegImageInfo createInfo(IDataBuffer imageData) {
        JpegSegmentReader segmentReader = new JpegSegmentReader(imageData);
        Map<Byte, List<JpegSegment>> segmentMap = segmentReader.readSegments();
        int numberOfComponent = -1;
        int[] compsId = null;
        List<JpegSegment> sofSegments = segmentMap.get((byte)-64);
        if (sofSegments == null || sofSegments.size() == 0) {
            sofSegments = segmentMap.get((byte)-63);
        }
        if (sofSegments != null && sofSegments.size() != 0) {
            for (JpegSegment sofSegment : sofSegments) {
                if (!(sofSegment instanceof JpegStartOfFrameSegment)) continue;
                JpegStartOfFrameSegment startOfFrameSegment = (JpegStartOfFrameSegment)sofSegment;
                numberOfComponent = startOfFrameSegment.getNumberOfComponents();
                compsId = startOfFrameSegment.getComponentsIds();
                break;
            }
        }
        int adobeColorTransform = -1;
        List<JpegSegment> appeSegments = segmentMap.get((byte)-18);
        if (appeSegments != null && appeSegments.size() != 0) {
            for (JpegSegment appeSegment : appeSegments) {
                if (!(appeSegment instanceof JpegAdobeSegment)) continue;
                JpegAdobeSegment adobeSegment = (JpegAdobeSegment)appeSegment;
                adobeColorTransform = adobeSegment.getColorTransform();
                break;
            }
        }
        return new JpegImageInfo(numberOfComponent, compsId, adobeColorTransform);
    }

    public boolean needsSpecialHandling(int colorTransform) {
        if (this.adobeColorTransform == -1) {
            this.adobeColorTransform = colorTransform;
        }
        return this.adobeColorTransform != -1;
    }

    public int getColorType() {
        switch (this.adobeColorTransform) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                if (this.numberOfComponent == 3) {
                    return 3;
                }
                return 0;
            }
        }
        return 0;
    }
}

