/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.PNGPredictor;
import com.inet.pdfview.decode.TIFFPredictor;
import com.inet.pdfview.error.PDFParseException;

public abstract class Predictor {
    public static final int TIFF = 0;
    public static final int PNG = 1;
    private int algorithm;
    private int colors = 1;
    private int bpc = 8;
    private int columns = 1;

    protected Predictor(int algorithm) {
        this.algorithm = algorithm;
    }

    public abstract IDataBuffer unpredict(IDataBuffer var1) throws PDFParseException;

    public static Predictor getPredictor(PDFObject params) throws PDFParseException {
        PDFObject columnsObj;
        PDFObject bpcObj;
        PDFObject algorithmObj = params.getDictRef("Predictor");
        if (algorithmObj == null) {
            return null;
        }
        int algorithm = algorithmObj.getIntValue();
        Predictor predictor = null;
        switch (algorithm) {
            case 1: {
                return null;
            }
            case 2: {
                predictor = new TIFFPredictor();
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                predictor = new PNGPredictor();
                break;
            }
            default: {
                throw new PDFParseException("Unknown predictor: " + algorithm);
            }
        }
        PDFObject colorsObj = params.getDictRef("Colors");
        if (colorsObj != null) {
            predictor.setColors(colorsObj.getIntValue());
        }
        if ((bpcObj = params.getDictRef("BitsPerComponent")) != null) {
            predictor.setBitsPerComponent(bpcObj.getIntValue());
        }
        if ((columnsObj = params.getDictRef("Columns")) != null) {
            predictor.setColumns(columnsObj.getIntValue());
        }
        return predictor;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int getColors() {
        return this.colors;
    }

    protected void setColors(int colors) {
        this.colors = colors;
    }

    public int getBitsPerComponent() {
        return this.bpc;
    }

    public void setBitsPerComponent(int bpc) {
        this.bpc = bpc;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }
}

