/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode;

import com.inet.pdfview.data.IDataBuffer;
import java.io.IOException;
import java.io.InputStream;

public class DataBufferInputStream
extends InputStream {
    private IDataBuffer data;

    public DataBufferInputStream(IDataBuffer data) {
        this.data = data;
    }

    @Override
    public int read() throws IOException {
        return this.data.get() & 0xFF;
    }

    @Override
    public int available() throws IOException {
        return this.data.remaining();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.data.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int size = this.data.remaining();
        if (size <= 0) {
            return -1;
        }
        if (size >= b.length) {
            this.data.get(b);
            return b.length;
        }
        byte[] temp = new byte[size];
        this.data.get(temp);
        System.arraycopy(temp, 0, b, 0, size);
        return size;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        byte[] temp = new byte[len];
        int size = this.read(temp);
        if (size <= 0) {
            return -1;
        }
        System.arraycopy(temp, 0, b, off, size);
        return size;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.data.rewind();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > (long)this.data.remaining()) {
            n = this.data.remaining();
        }
        this.data.position(this.data.position() + (int)n);
        return n;
    }
}

