/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.control;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.control.AppearanceState;
import com.inet.pdfview.control.StateSelector;
import com.inet.pdfview.error.PDFParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Appearance {
    private char appearenceKey;
    private Map<String, AppearanceState> states = new HashMap<String, AppearanceState>();

    public Appearance(char appearenceKey, PDFObject apRefObj) {
        this.appearenceKey = appearenceKey;
        this.setAppearenceParams(apRefObj);
    }

    private void setAppearenceParams(PDFObject apRefObj) {
        try {
            int atype = apRefObj.getType();
            if (atype == 7) {
                this.setFormState(apRefObj, null);
            } else if (atype == 6) {
                Iterator<String> iter = apRefObj.getDictKeys();
                while (iter.hasNext()) {
                    PDFObject valObj;
                    String keyObj = iter.next();
                    if (keyObj == null || (valObj = apRefObj.getDictRef(keyObj)) == null || valObj.getType() != 7) continue;
                    this.setFormState(valObj, keyObj);
                }
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
    }

    private void setFormState(PDFObject apRefObj, String stateName) throws PDFParseException {
        String subType;
        PDFObject subTypeObj = apRefObj.getDictRef("Subtype");
        if (subTypeObj != null && subTypeObj.getType() == 4 && "Form".equals(subType = subTypeObj.getStringValue())) {
            StateSelector stateSelector = new StateSelector(this.appearenceKey, stateName);
            AppearanceState state = new AppearanceState(stateSelector, apRefObj);
            this.states.put(stateName, state);
        }
    }

    AppearanceState getState(String key) {
        return this.states.get(key);
    }

    Collection<AppearanceState> getStates() {
        return this.states.values();
    }
}

