/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.command;

import com.inet.cache.image.SerializableImage;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.PDFSMask;
import com.inet.pdfview.command.PDFCmd;
import com.inet.shared.utils.BlendComposite;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;

public class PDFCompositeCmd
extends PDFCmd {
    private float alphaFill = -1.0f;
    private float alphaStroke = -1.0f;
    private BlendComposite.BlendingMode blendingMode = BlendComposite.BlendingMode.NORMAL;
    private PDFSMask pdfsMask;
    private final String pdfID;

    public PDFCompositeCmd(String pdfID) {
        this.pdfID = pdfID;
    }

    public void setAlphaFill(float alphaFill) {
        this.alphaFill = Math.max(0.0f, Math.min(alphaFill, 1.0f));
    }

    public void setAlphaStroke(float alphaStroke) {
        this.alphaStroke = Math.max(0.0f, Math.min(alphaStroke, 1.0f));
    }

    public void setBlendingMode(BlendComposite.BlendingMode blendingMode) {
        this.blendingMode = blendingMode;
    }

    public void setPdfsMask(PDFSMask pdfsMask) {
        this.pdfsMask = pdfsMask;
    }

    public boolean hasSMask() {
        return this.pdfsMask != null;
    }

    @Override
    public void execute(PDFRenderer state) {
        SerializableImage maskImage = null;
        if (this.pdfsMask != null && !this.pdfsMask.isEmpty()) {
            maskImage = this.pdfsMask.createGroupImage(state.getPageIndex(), state.getPageSize());
        }
        PDFBlendComposite blendCompositeFill = new PDFBlendComposite(this.pdfID, this.blendingMode, Math.abs(this.alphaFill), this.alphaFill >= 0.0f, this.pdfsMask != null, (BufferedImage)maskImage);
        PDFBlendComposite blendCompositeStroke = new PDFBlendComposite(this.pdfID, this.blendingMode, Math.abs(this.alphaStroke), this.alphaStroke >= 0.0f, this.pdfsMask != null, (BufferedImage)maskImage);
        state.getCurrentState().addComposite(blendCompositeFill, true);
        state.getCurrentState().addComposite(blendCompositeStroke, false);
    }

    @Override
    public String toString() {
        return "Composite{ alphaFill=" + this.alphaFill + ", alphaStroke=" + this.alphaStroke + ", blendingMode=" + String.valueOf(this.blendingMode) + ", pdfsMask=" + String.valueOf(this.pdfsMask) + " }";
    }

    public static class PDFBlendComposite
    extends BlendComposite {
        private boolean hasDefinedAlphaValue;
        private boolean hasDefinedMaskValue;
        private String id;

        public PDFBlendComposite(String id, @Nonnull BlendComposite.BlendingMode mode, float alpha, boolean hasDefinedAlphaValue, boolean hasDefinedMaskValue) {
            this(id, mode, alpha, hasDefinedAlphaValue, hasDefinedMaskValue, null);
        }

        public PDFBlendComposite(String id, @Nonnull BlendComposite.BlendingMode mode, float alpha, boolean hasDefinedAlphaValue, boolean hasDefinedMaskValue, BufferedImage smask) throws IllegalArgumentException {
            super(mode, alpha, smask);
            this.id = id;
            this.hasDefinedAlphaValue = hasDefinedAlphaValue;
            this.hasDefinedMaskValue = hasDefinedMaskValue;
        }

        public boolean hasDefinedAlphaValue() {
            return this.hasDefinedAlphaValue;
        }

        public boolean hasDefinedMaskValue() {
            return this.hasDefinedMaskValue;
        }

        public String toString() {
            return "PDFBlendComposite{hasDefinedAlphaValue=" + this.hasDefinedAlphaValue + ", hasDefinedMaskValue=" + this.hasDefinedMaskValue + ", id='" + this.id + "'" + super.toString() + "}";
        }
    }
}

