/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.command;

import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.command.PDFCmd;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class PDFClipCommand
extends PDFCmd {
    private Rectangle2D rect;

    public PDFClipCommand(Rectangle2D rect) {
        this.rect = rect;
    }

    @Override
    public void execute(PDFRenderer state) {
        double x = this.rect.getX();
        double y = this.rect.getY();
        double h = this.rect.getHeight();
        double w = this.rect.getWidth();
        if (this.rect.getHeight() < 0.0) {
            y += h;
            h = -h;
        }
        if (this.rect.getWidth() < 0.0) {
            x += w;
            w = -w;
        }
        Rectangle2D.Double clip = new Rectangle2D.Double(x, y, w, h);
        GeneralPath generalPath = new GeneralPath(clip);
        state.clip(generalPath);
    }

    @Override
    public String toString() {
        return "Clip{ rect=" + String.valueOf(this.rect) + " }";
    }
}

