/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.colorspace;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.colorspace.AlternateColorSpace;
import com.inet.pdfview.colorspace.CMYKColorSpace;
import com.inet.pdfview.colorspace.CalGrayColor;
import com.inet.pdfview.colorspace.CalRGBColor;
import com.inet.pdfview.colorspace.IndexedColor;
import com.inet.pdfview.colorspace.LabColorSpaceImpl;
import com.inet.pdfview.colorspace.PatternSpace;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.function.PDFFunction;
import java.awt.Color;
import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Map;

public class PDFColorSpace
implements Serializable {
    private static final long serialVersionUID = 2752050669661717744L;
    public static final int COLORSPACE_GRAY = 0;
    public static final int COLORSPACE_RGB = 1;
    public static final int COLORSPACE_CMYK = 2;
    public static final int COLORSPACE_PATTERN = 3;
    private static PDFColorSpace graySpace = new PDFColorSpace(new LinearGraySpace());
    private static PDFColorSpace rgbSpace = new PDFColorSpace(ColorSpace.getInstance(1000));
    private static PDFColorSpace cmykSpace = PDFColorSpace.createCMYKColorSpace();
    private static PDFColorSpace patternSpace;
    private static Object iccMutex;
    private ColorSpace cs;

    protected PDFColorSpace(ColorSpace cs) {
        this.cs = cs;
    }

    private static PDFColorSpace createCMYKColorSpace() {
        return new PDFColorSpace(new CMYKColorSpace());
    }

    public static PDFColorSpace getColorSpace(int name) {
        switch (name) {
            case 0: {
                return graySpace;
            }
            case 1: {
                return rgbSpace;
            }
            case 2: {
                return cmykSpace;
            }
            case 3: {
                return patternSpace;
            }
        }
        throw new IllegalArgumentException("Unknown Color Space name: " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDFColorSpace getColorSpace(PDFObject csobj, Map<?, ?> resources, PDFDecrypter decryptor) throws PDFParseException {
        String name;
        PDFObject colorSpaces = null;
        if (resources != null) {
            colorSpaces = (PDFObject)resources.get("ColorSpace");
        }
        if (csobj.getType() == 0) {
            csobj = csobj.dereference();
        }
        if (csobj.getType() == 4) {
            name = csobj.getStringValue();
            if (name.equals("DeviceGray") || name.equals("G")) {
                return PDFColorSpace.getColorSpace(0);
            }
            if (name.equals("DeviceRGB") || name.equals("RGB")) {
                return PDFColorSpace.getColorSpace(1);
            }
            if (name.equals("DeviceCMYK") || name.equals("CMYK")) {
                return PDFColorSpace.getColorSpace(2);
            }
            if (name.equals("Pattern")) {
                return PDFColorSpace.getColorSpace(3);
            }
            if (colorSpaces != null) {
                csobj = colorSpaces.getDictRef(name);
            }
        }
        if (csobj == null) {
            return null;
        }
        if (csobj.getCache() != null) {
            return (PDFColorSpace)csobj.getCache();
        }
        PDFColorSpace value = null;
        PDFObject[] ary = csobj.getArray();
        name = ary[0].getStringValue();
        if (name.equals("CalGray")) {
            value = new PDFColorSpace(new CalGrayColor(ary[1]));
        } else if (name.equals("CalRGB")) {
            value = new PDFColorSpace(new CalRGBColor(ary[1]));
        } else {
            if (name.equals("DeviceGray") || name.equals("G")) {
                return PDFColorSpace.getColorSpace(0);
            }
            if (name.equals("DeviceRGB") || name.equals("RGB")) {
                return PDFColorSpace.getColorSpace(1);
            }
            if (name.equals("DeviceCMYK") || name.equals("CMYK")) {
                return PDFColorSpace.getColorSpace(2);
            }
            if (name.equals("Lab")) {
                value = new PDFColorSpace(new LabColorSpaceImpl(ary[1]));
            } else {
                if (name.equals("ICCBased")) {
                    PDFXref ref = null;
                    if (decryptor != null) {
                        ref = ary[1].getRefValue();
                    }
                    try {
                        ICC_Profile profile;
                        ByteArrayInputStream bais = new ByteArrayInputStream(ary[1].getStream(ref, decryptor, true));
                        Object object = iccMutex;
                        synchronized (object) {
                            profile = ICC_Profile.getInstance(bais);
                        }
                        value = new PDFColorSpace(new ICC_ColorSpace(profile));
                    }
                    catch (Exception e) {
                        PDFParser.LOGGER.warn((Object)e);
                        return PDFColorSpace.getColorSpace(1);
                    }
                }
                if (name.equals("Separation") || name.equals("DeviceN")) {
                    PDFColorSpace alternate = PDFColorSpace.getColorSpace(ary[2], resources, decryptor);
                    PDFFunction function = PDFFunction.getFunction(ary[3], decryptor, ary[3].getRefValue());
                    value = new AlternateColorSpace(alternate, function);
                } else if (name.equals("Indexed") || name.equals("I")) {
                    PDFColorSpace refspace = PDFColorSpace.getColorSpace(ary[1], resources, decryptor);
                    int count = ary[2].getIntValue();
                    value = new IndexedColor(refspace, count, ary[3], decryptor);
                } else if (name.equals("DeviceRGB") || name.equals("RGB")) {
                    value = PDFColorSpace.getColorSpace(1);
                } else {
                    if (name.equals("Pattern")) {
                        if (ary.length == 1) {
                            return PDFColorSpace.getColorSpace(3);
                        }
                        PDFColorSpace base = PDFColorSpace.getColorSpace(ary[1], resources, decryptor);
                        return new PatternSpace(base);
                    }
                    if (name.equals("DeviceGray") || name.equals("RGB")) {
                        return PDFColorSpace.getColorSpace(0);
                    }
                    if (ary.length > 1) {
                        throw new PDFParseException("Unknown color space: " + name + " with " + String.valueOf(ary[1]));
                    }
                    throw new PDFParseException("Unknown color space: " + name);
                }
            }
        }
        csobj.setCache(value);
        return value;
    }

    public int getNumComponents() {
        return this.cs.getNumComponents();
    }

    public PDFPaint getPaint(float[] components) {
        float[] rgb;
        try {
            rgb = this.cs.toRGB(components);
        }
        catch (CMMException e) {
            rgb = components;
            for (int i = 0; i < components.length; ++i) {
                rgb[i] = Math.max(0.0f, Math.min(1.0f, rgb[i]));
            }
        }
        catch (ProfileDataException e) {
            if (components.length == 1) {
                rgb = new float[3];
                rgb[1] = rgb[2] = components[0];
                rgb[0] = rgb[2];
            }
            throw e;
        }
        return new PDFPaint(new Color(rgb[0], rgb[1], rgb[2]));
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    public float[] toRGB(float[] colorvalue) {
        return this.cs.toRGB(colorvalue);
    }

    static {
        rgbSpace.toRGB(new float[]{0.0f, 0.0f, 0.0f});
        patternSpace = new PatternSpace();
        iccMutex = new Object();
    }

    static class LinearGraySpace
    extends ColorSpace {
        private static final long serialVersionUID = 4827811499786798198L;

        protected LinearGraySpace() {
            super(6, 1);
        }

        @Override
        public float[] toRGB(float[] colorvalue) {
            return new float[]{colorvalue[0], colorvalue[0], colorvalue[0]};
        }

        @Override
        public float[] fromRGB(float[] rgbvalue) {
            return new float[]{rgbvalue[0]};
        }

        @Override
        public float[] toCIEXYZ(float[] colorvalue) {
            return new float[3];
        }

        @Override
        public float[] fromCIEXYZ(float[] colorvalue) {
            return new float[1];
        }
    }
}

