/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.colorspace;

public class Matrix {
    private static int getRowCount(double[][] matrix) {
        return matrix == null ? 0 : matrix.length;
    }

    private static int getColumnCount(double[][] matrix) {
        int rowNumber = Matrix.getRowCount(matrix);
        return rowNumber == 0 ? 0 : matrix[0].length;
    }

    public static double[][] multiplyMatrix(double[][] matrix1, double[][] matrix2) {
        int rowNumber1 = Matrix.getRowCount(matrix1);
        int columnNumber1 = Matrix.getColumnCount(matrix1);
        int rowNumber2 = Matrix.getRowCount(matrix2);
        int columnNumber2 = Matrix.getColumnCount(matrix2);
        if (columnNumber1 != rowNumber2) {
            throw new IllegalArgumentException("Matrix sizes are not compatible: number of columns=" + columnNumber1 + " != row number=" + rowNumber2);
        }
        double[][] res = new double[rowNumber1][columnNumber2];
        for (int row = 0; row < rowNumber1; ++row) {
            for (int col = 0; col < columnNumber2; ++col) {
                for (int i = 0; i < columnNumber1; ++i) {
                    double[] dArray = res[row];
                    int n = col;
                    dArray[n] = dArray[n] + matrix1[row][i] * matrix2[i][col];
                }
            }
        }
        return res;
    }

    public static double[] multiplyVector(double[][] matrix, double[] vector) {
        int rowNumber;
        int columnNumber = Matrix.getColumnCount(matrix);
        int n = rowNumber = vector == null ? 0 : vector.length;
        if (columnNumber != rowNumber) {
            throw new IllegalArgumentException("Column number of matrix=" + columnNumber + " but the length of the vector=" + rowNumber);
        }
        double[] res = new double[rowNumber];
        for (int row = 0; row < rowNumber; ++row) {
            for (int i = 0; i < columnNumber; ++i) {
                int n2 = row;
                res[n2] = res[n2] + matrix[row][i] * vector[i];
            }
        }
        return res;
    }

    public static double[][] getScaleMatrix(double[] vector1, double[] vector2) {
        int length2;
        int length = vector1 == null ? 0 : vector1.length;
        int n = length2 = vector2 == null ? 0 : vector2.length;
        if (length != length2) {
            throw new IllegalArgumentException("Scaling impossible because vectors have a different size");
        }
        double[][] res = new double[length][length];
        for (int i = 0; i < length; ++i) {
            res[i][i] = vector2[i] / vector1[i];
        }
        return res;
    }
}

