/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.colorspace;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.colorspace.BaseChromaticAdaptationTransform;
import com.inet.pdfview.colorspace.BradfordChromaticAdaptationTransform;
import com.inet.pdfview.colorspace.StandardIlluminant;
import com.inet.pdfview.error.PDFParseException;
import java.awt.color.ColorSpace;

public class LabColorSpaceImpl
extends ColorSpace {
    private static final long serialVersionUID = -8105948306775754556L;
    private static final double GAMMA_THRESHOLD = 0.206893;
    private static final double GAMMA_INVERSE_THRESHOLD = Math.pow(0.206893, 3.0);
    private static final BaseChromaticAdaptationTransform CHROMATIC_TRANSFORM_D65_TO_D50 = new BradfordChromaticAdaptationTransform(StandardIlluminant.ILLUMINANT_D65, StandardIlluminant.ILLUMINANT_D50);
    private static final BaseChromaticAdaptationTransform CHROMATIC_TRANSFORM_D50_TO_D65 = new BradfordChromaticAdaptationTransform(StandardIlluminant.ILLUMINANT_D50, StandardIlluminant.ILLUMINANT_D65);
    private static final double REF_X = StandardIlluminant.ILLUMINANT_D65.getX();
    private static final double REF_Y = StandardIlluminant.ILLUMINANT_D65.getY();
    private static final double REF_Z = StandardIlluminant.ILLUMINANT_D65.getZ();
    private static final ColorSpace sRGBcs = ColorSpace.getInstance(1000);
    private float[] whitePointArr = new float[]{1.0f, 1.0f, 1.0f};
    private float[] blackPointArr = new float[]{0.0f, 0.0f, 0.0f};
    private float[] rangeArr = new float[]{-100.0f, 100.0f, -100.0f, 100.0f};

    public LabColorSpaceImpl(PDFObject obj) {
        super(1, 3);
        int i;
        PDFObject ary = null;
        try {
            ary = obj.getDictRef("WhitePoint");
            if (ary != null) {
                for (i = 0; i < 3; ++i) {
                    this.whitePointArr[i] = ary.getAt(i).getFloatValue();
                }
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        try {
            ary = obj.getDictRef("BlackPoint");
            if (ary != null) {
                for (i = 0; i < 3; ++i) {
                    this.blackPointArr[i] = ary.getAt(i).getFloatValue();
                }
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        try {
            ary = obj.getDictRef("Range");
            if (ary != null) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.rangeArr[i2] = ary.getAt(i2).getFloatValue();
                }
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
    }

    @Override
    public float[] fromCIEXYZ(float[] colorsInXYZ50) {
        float[] colorsInXYZ65 = CHROMATIC_TRANSFORM_D50_TO_D65.transform(colorsInXYZ50);
        double xCorr = LabColorSpaceImpl.gammaCorrection((double)colorsInXYZ65[0] / REF_X);
        double yCorr = LabColorSpaceImpl.gammaCorrection((double)colorsInXYZ65[1] / REF_Y);
        double zCorr = LabColorSpaceImpl.gammaCorrection((double)colorsInXYZ65[2] / REF_Z);
        float L = (float)(116.0 * yCorr - 16.0);
        float a = (float)(500.0 * (xCorr - yCorr));
        float b = (float)(200.0 * (yCorr - zCorr));
        return new float[]{L, a, b};
    }

    @Override
    public float[] toCIEXYZ(float[] colorsInLab) {
        double yy = (colorsInLab[0] + 16.0f) / 116.0f;
        float colorX65 = (float)(REF_X * LabColorSpaceImpl.inverseGammaCorrection((double)(colorsInLab[1] / 500.0f) + yy));
        float colorY65 = (float)(REF_Y * LabColorSpaceImpl.inverseGammaCorrection(yy));
        float colorZ65 = (float)(REF_Z * LabColorSpaceImpl.inverseGammaCorrection(yy - (double)(colorsInLab[2] / 200.0f)));
        float[] XYZ65 = new float[]{colorX65, colorY65, colorZ65};
        return CHROMATIC_TRANSFORM_D65_TO_D50.transform(XYZ65);
    }

    private static double gammaCorrection(double c) {
        if (c > GAMMA_INVERSE_THRESHOLD) {
            return Math.pow(c, 0.3333333333333333);
        }
        return 7.787 * c + 0.13793103448275862;
    }

    private static double inverseGammaCorrection(double c) {
        if (c > 0.206893) {
            return c * c * c;
        }
        return (c - 0.13793103448275862) / 7.787;
    }

    @Override
    public float[] fromRGB(float[] sRGB) {
        float[] XYZ50 = sRGBcs.toCIEXYZ(sRGB);
        return this.fromCIEXYZ(XYZ50);
    }

    @Override
    public float[] toRGB(float[] Lab) {
        float[] XYZ50 = this.toCIEXYZ(Lab);
        for (int i = 0; i < XYZ50.length; ++i) {
            if (!(XYZ50[i] < 0.0f)) continue;
            XYZ50[i] = 0.0f;
        }
        return sRGBcs.fromCIEXYZ(XYZ50);
    }
}

