/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.action;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.action.PDFAction;
import com.inet.pdfview.error.PDFParseException;
import java.net.URI;
import java.net.URISyntaxException;

public class UriAction
extends PDFAction {
    private final URI destination;

    public UriAction(PDFObject pdfObject) throws PDFParseException {
        super("URI");
        PDFObject destObj = pdfObject.getDictRef("URI");
        if (destObj == null) {
            throw new PDFParseException("No destination in URI action " + String.valueOf(pdfObject));
        }
        Object url = destObj.getStringValue();
        PDFObject baseObj = pdfObject.getDictRef("Base");
        if (baseObj != null) {
            url = baseObj.getStringValue() + (String)url;
        }
        try {
            this.destination = new URI(((String)url).trim());
        }
        catch (URISyntaxException e) {
            throw new PDFParseException(e);
        }
    }

    public UriAction(URI destination) {
        super("URI");
        this.destination = destination;
    }

    public URI getDestination() {
        return this.destination;
    }
}

