/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public class ReferenceFactory {
    public static final String SYSPROP_KEY = "reference.type";
    private static REF REF_TYPE = REF.soft;

    public static <T> Reference<T> createReference(T value) {
        switch (REF_TYPE) {
            case phantom: {
                return new PhantomReference<T>(value, null);
            }
            case weak: {
                return new WeakReference<T>(value);
            }
        }
        return new SoftReference<T>(value);
    }

    static {
        String refOption = System.getProperty(SYSPROP_KEY);
        try {
            REF_TYPE = REF.valueOf(refOption != null ? refOption.toLowerCase() : REF_TYPE.name());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static enum REF {
        weak,
        soft,
        phantom;

    }
}

