/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.cache.image.SerializableImage;
import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.command.PDFCmd;
import com.inet.pdfview.function.PDFFunction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.List;

public class PDFSMask {
    private static final int BOXSIZE = 32768;
    private List<PDFCmd> streamCmds;
    private boolean isTransparency = false;
    private Color backdropColor;
    private ColorSpace colorSpace;
    private PDFFunction transferFunction;
    private Object recentImageKey;
    private RenderData recentSize;
    private CacheAccess cache;
    private Rectangle2D bbox;

    private List<PDFCmd> getStreamCmds() {
        return this.streamCmds;
    }

    public boolean isEmpty() {
        return this.streamCmds.isEmpty();
    }

    public boolean isTransparency() {
        return this.isTransparency;
    }

    public Color getBackdropColor() {
        return this.backdropColor;
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public PDFFunction getTransferFunction() {
        return this.transferFunction;
    }

    PDFSMask(List<PDFCmd> cmds, boolean isTransparency, CacheAccess cache, Rectangle2D bbox) {
        this.streamCmds = cmds;
        this.isTransparency = isTransparency;
        this.cache = cache;
        this.bbox = bbox;
    }

    public SerializableImage createGroupImage(int pageIndex, Rectangle2D pageSize) {
        RenderData size = this.getMaskSize(pageSize);
        if (size.equals(this.recentSize) && this.recentImageKey != null) {
            return this.cache.getImage(this.recentImageKey);
        }
        BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 2);
        Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
        Rectangle2D.Double box = new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
        RenderData bboxSize = this.getMaskSize(this.bbox);
        Rectangle2D.Double renderBBox = new Rectangle2D.Double(0.0, 0.0, Math.min(bboxSize.getWidth(), box.getWidth()), Math.min(bboxSize.getHeight(), box.getHeight()));
        final PDFPage pdfPage = new PDFPage(pageIndex, renderBBox, 0, null, null, null);
        pdfPage.setBuildPageImage(true);
        pdfPage.addXform(AffineTransform.getScaleInstance(size.getScaleX(), size.getScaleY()));
        pdfPage.addPush();
        for (PDFCmd streamCmd : this.getStreamCmds()) {
            pdfPage.addCommand(streamCmd);
        }
        PDFRenderer pdfRenderer = new PDFRenderer(pdfPage, graphics, renderBBox, null){

            @Override
            public int iterate() throws Exception {
                if (this.getCurrentCommand() >= pdfPage.getCommandCount()) {
                    pdfPage.finish();
                }
                return super.iterate();
            }
        };
        pdfRenderer.go(true);
        int[] pixels = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < pixels.length; ++i) {
            if (pixels[i] >> 24 != 255) continue;
            pixels[i] = (pixels[i] & 0xFF0000) << 8;
        }
        SerializableImage maskImage = new SerializableImage((Image)bufferedImage, null);
        if (this.cache != null) {
            this.recentSize = size;
            this.recentImageKey = this.cache.putImage(maskImage);
        }
        return maskImage;
    }

    private RenderData getMaskSize(Rectangle2D pageSize) {
        int width = (int)pageSize.getWidth();
        int height = (int)pageSize.getHeight();
        double scaleFactorX = 1.0;
        double scaleFactorY = 1.0;
        if (width > 2048) {
            scaleFactorX = 2048.0 / pageSize.getWidth();
            width = (int)(pageSize.getWidth() * scaleFactorX);
        }
        if (height > 2048) {
            scaleFactorY = 2048.0 / pageSize.getHeight();
            height = (int)(pageSize.getHeight() * scaleFactorY);
        }
        return new RenderData(width, height, scaleFactorX, scaleFactorY);
    }

    public static class RenderData
    extends Dimension {
        private double scaleX;
        private double scaleY;

        public RenderData(int width, int height, double scale) {
            super(width, height);
            this.scaleX = scale;
            this.scaleY = scale;
        }

        public RenderData(int width, int height, double scaleX, double scaleY) {
            super(width, height);
            this.scaleX = scaleX;
            this.scaleY = scaleY;
        }

        public double getScaleX() {
            return this.scaleX;
        }

        public double getScaleY() {
            return this.scaleY;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.scaleX == ((RenderData)obj).scaleX && this.scaleY == ((RenderData)obj).scaleY;
        }
    }
}

