/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.cache.image.SerializableImage;
import com.inet.pdfview.BaseWatchable;
import com.inet.pdfview.BidiRenderer;
import com.inet.pdfview.GraphicsState;
import com.inet.pdfview.PDFGroup;
import com.inet.pdfview.PDFImage;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.ParserListener;
import com.inet.pdfview.command.PDFCmd;
import com.inet.pdfview.command.PDFShapeCmd;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFFontEncoding;
import com.inet.shared.utils.BlendComposite;
import com.inet.shared.utils.ImageUtils;
import com.inet.shared.utils.LayerGraphics2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.HashMap;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class PDFRenderer
extends BaseWatchable
implements Runnable {
    protected static Graphics2D debugGraphics = null;
    protected static DrawUpdate drawUpdate = null;
    protected static boolean fresh = true;
    private static final int MARGIN = 10;
    private static final Image MISSING_RESOURCE_IMAGE = PDFRenderer.createImageError("Error", "Image");
    private static final Image JPEG2000_ERROR_IMAGE = PDFRenderer.createImageError("no support", "JPEG2000");
    private static final int BOXSIZE = 32768;
    private int layerCounter = 0;
    private static final Object SCALE_SYNC = new Object();
    private static final float MAX_TRACKING = 10.0f;
    private static final float EPSILON = 1.0E-7f;
    private PDFPage page;
    private int currentCommand;
    private static final char DEFAULT_WORD_SPACE_CODE = ' ';
    private LayerGraphics2D g;
    private GraphicsState state;
    private Stack<GraphicsState> stack;
    public static final float NOPHASE = -1000.0f;
    public static final float NOWIDTH = -1000.0f;
    public static final float NOLIMIT = -1000.0f;
    public static final int NOCAP = -1000;
    public static final float[] NODASH = null;
    public static final int NOJOIN = -1000;
    private static final boolean DEBUG = false;
    private Stack<AffineTransform> startTransforms = new Stack();
    private double scaleX;
    private double scaleY;
    private float maximumQualityFactor = 2.0f;
    private ParserListener listener;
    private boolean shouldScaleDown = true;
    private Rectangle2D imgbounds;

    private static Image createImageError(String error, String errorText) {
        BufferedImage image;
        try {
            image = ImageIO.read(PDFRenderer.class.getResource("image/warning_32.png"));
            Font font = new Font("Dialog", 1, 12);
            Graphics2D gI = (Graphics2D)((Image)image).getGraphics();
            gI.setFont(font);
            Rectangle bounds = gI.getFontMetrics().getStringBounds(errorText, gI).getBounds();
            gI.dispose();
            int width = 30 + ((Image)image).getWidth(null) + bounds.width;
            int height = (20 + ((Image)image).getHeight(null)) * 2;
            BufferedImage output = new BufferedImage(width, height, 2);
            Graphics2D g2 = (Graphics2D)output.getGraphics();
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillRect(0, 0, width, height);
            g2.drawImage((Image)image, 10, 10, null);
            g2.setFont(font);
            g2.setColor(Color.RED);
            g2.drawString(error, 20 + ((Image)image).getWidth(null), 10 + ((Image)image).getHeight(null) - 3);
            g2.drawString(errorText, 20 + ((Image)image).getWidth(null), 10 + ((Image)image).getHeight(null) - bounds.height);
            g2.copyArea(0, 0, width / 2, height / 2, width / 2, height / 2);
            g2.copyArea(width / 2, 0, width / 2, height / 2, -width / 2, height / 2);
            g2.dispose();
            image = output;
        }
        catch (Throwable th) {
            PDFParser.LOGGER.error(th);
            image = new BufferedImage(1, 1, 2);
        }
        return image;
    }

    public PDFRenderer(PDFPage page) {
        this.page = page;
        page.setBuildPageImage(false);
    }

    public PDFRenderer(PDFPage page, LayerGraphics2D g, Rectangle2D imgbounds) {
        this(page);
        this.g = g;
        this.imgbounds = imgbounds;
        page.setBuildPageImage(true);
    }

    public PDFRenderer(PDFPage page, Graphics2D g, Rectangle2D imgbounds, Color bgColor) {
        this(page);
        if (g instanceof LayerGraphics2D) {
            this.g = (LayerGraphics2D)g;
        } else {
            this.g = new LayerGraphics2D();
            this.g.setGraphics(g);
        }
        if (imgbounds != null) {
            this.g.setInitialInformation(imgbounds, page.getInitialTransform());
        }
        this.imgbounds = imgbounds;
        if (debugGraphics != null && fresh) {
            fresh = false;
            this.g.setGraphics(debugGraphics);
        }
        if (g != null) {
            this.initializeGraphics();
            if (bgColor != null) {
                this.g.setColor(bgColor);
                this.g.fill((Shape)new Rectangle2D.Float(0.0f, 0.0f, page.getWidth(), page.getHeight()));
            }
            page.setBuildPageImage(true);
        } else {
            page.setBuildPageImage(false);
        }
    }

    public double getScaleX() {
        if (this.layerCounter > 0) {
            return 1.0;
        }
        return this.scaleX;
    }

    public double getScaleY() {
        if (this.layerCounter > 0) {
            return 1.0;
        }
        return this.scaleY;
    }

    public int getPageIndex() {
        return this.page.getPageIndex();
    }

    private void initializeGraphics() {
        if (this.imgbounds != null) {
            this.g.translate(this.imgbounds.getX(), this.imgbounds.getY());
            double width = this.imgbounds.getWidth();
            double height = this.imgbounds.getHeight();
            double scaleX = width / (double)((int)this.page.getWidth());
            double scaleY = height / (double)((int)this.page.getHeight());
            if (Math.abs(scaleX - 1.0) < 0.01 && Math.abs(scaleY - 1.0) < 0.01) {
                return;
            }
            if (width <= 0.0 || height <= 0.0) {
                return;
            }
            if (Math.abs(scaleX / scaleY - 1.0) < 0.01) {
                double avg;
                scaleX = avg = (scaleX + scaleY) / 2.0;
                scaleY = avg;
            }
            this.g.scale(scaleX, scaleY);
        }
    }

    protected int getCurrentCommand() {
        return this.currentCommand;
    }

    public void setShouldScaleDown(boolean shouldScaleDown) {
        this.shouldScaleDown = shouldScaleDown;
    }

    public void setParserListener(ParserListener listener) {
        this.listener = listener;
    }

    public ParserListener getParserListener() {
        return this.listener;
    }

    private LayerGraphics2D setupRendering(LayerGraphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(Color.BLACK);
        this.setupRendering();
        this.startTransforms.push(g.getTransform());
        AffineTransform baseTransform = this.state.getXForm();
        this.scaleX = Math.abs(baseTransform.getScaleX() + baseTransform.getShearX());
        this.scaleY = Math.abs(baseTransform.getScaleY() + baseTransform.getShearY());
        return g;
    }

    private void setupRendering() {
        this.state = new GraphicsState(this.getInitialTransform());
        this.state.setGroup(this.page.getGroup());
        this.stack = new Stack();
        this.currentCommand = 0;
    }

    public void push() {
        if (this.page.isBuildPageImage()) {
            this.state.setClipFromGraphics((Graphics2D)this.g);
        }
        this.stack.push(this.state);
        this.state = this.state.copy(this.layerCounter);
        if (this.page.isBuildPageImage()) {
            this.state.setClipFromGraphics((Graphics2D)this.g);
        }
    }

    public void pop() {
        Shape lastClip = this.state != null ? this.state.getClip() : null;
        this.state = this.stack.pop();
        this.setTransform(this.state.getXForm());
        this.setClip(this.state.getClip(), this.state.getClipGraphics());
        if (lastClip != null || this.state.getClip() != null) {
            this.execClipShapeCmd(this.state.getClip());
        }
    }

    public void pushForm(PDFGroup group) {
        if (this.page.isBuildPageImage()) {
            this.startTransforms.push(new AffineTransform());
            this.stack.push(this.state);
            ++this.layerCounter;
            this.state = this.state.copy(this.layerCounter);
            this.state.setClip(null);
            this.g.addLayer(group.isKnockout(), group.isIsolated(), this.state.getFillComposite());
            this.state.setXform(new AffineTransform());
            this.state.setGroup(group);
            this.state.clearCompositeList();
            if (PDFParser.LOGGER.isDebug()) {
                PDFParser.LOGGER.debug((Object)("Layer " + this.g.getNumOfLayers() + " was added with " + String.valueOf(this.state.getFillComposite())));
            }
        } else {
            ++this.layerCounter;
            this.state = this.state.copy(this.layerCounter);
        }
    }

    public void popForm() {
        if (this.page.isBuildPageImage()) {
            this.startTransforms.pop();
            while (!this.stack.isEmpty() && this.stack.peek().getLayerNr() == this.layerCounter) {
                this.pop();
            }
            this.g.paintLastLayer();
            --this.layerCounter;
            if (drawUpdate != null) {
                drawUpdate.update();
            }
            if (PDFParser.LOGGER.isDebug()) {
                PDFParser.LOGGER.debug((Object)("Layer " + (this.g.getNumOfLayers() + 1) + " was removed"));
            }
        } else {
            while (!this.stack.isEmpty() && this.stack.peek().getLayerNr() == this.layerCounter) {
                this.pop();
            }
            --this.layerCounter;
        }
    }

    public Rectangle2D drawShapeStroked(Shape shape, boolean isVisible, BlendComposite strokeComposite) {
        if (drawUpdate != null) {
            drawUpdate.update();
        }
        if (this.page.isBuildPageImage()) {
            this.g.setComposite((Composite)strokeComposite);
            Shape s = this.state.getStroke().createStrokedShape(shape);
            Paint paint = this.state.getStrokePaint().getPaint(this);
            if (isVisible) {
                this.g.setPaint(paint);
                if (PDFParser.LOGGER.isDebug()) {
                    PDFParser.LOGGER.debug((Object)("Composite = " + String.valueOf(this.g.getComposite()) + "\tPaint = " + String.valueOf(this.g.getPaint()) + "\tColor = " + String.valueOf(this.g.getColor()) + " " + this.g.getColor().getAlpha()));
                }
                if (paint instanceof Color) {
                    this.g.setStroke((Stroke)this.state.getStroke());
                    this.g.draw(shape);
                } else {
                    this.g.fill(s);
                }
            }
            if (drawUpdate != null) {
                drawUpdate.update();
            }
            return PDFRenderer.createTransformedShape(s, this.g.getTransform()).getBounds2D();
        }
        Shape s = PDFRenderer.createTransformedShape(shape, this.state.getXForm());
        s = this.state.getStroke().createStrokedShape(s);
        return s.getBounds();
    }

    public Rectangle2D drawShapeFilled(Shape s, boolean isVisible, BlendComposite fillComposite) {
        if (this.page.isBuildPageImage()) {
            Composite composite = this.g.getComposite();
            this.g.setComposite((Composite)fillComposite);
            Paint paint = this.state.getFillPaint().getPaint(this);
            if (paint != null) {
                this.g.setPaint(paint);
                if (isVisible) {
                    this.g.fill(s);
                }
            } else if (isVisible) {
                this.state.getFillPaint().fill(this, (Graphics2D)this.g, s);
            }
            if (drawUpdate != null) {
                drawUpdate.update();
            }
            this.g.setComposite(composite);
            return PDFRenderer.createTransformedShape(s, this.g.getTransform()).getBounds2D();
        }
        return PDFRenderer.createTransformedShape(s, this.state.getXForm()).getBounds();
    }

    public static Shape createTransformedShape(Shape s, AffineTransform t) {
        if (s instanceof Path2D) {
            return ((Path2D)s).createTransformedShape(t);
        }
        if (s instanceof Area) {
            return ((Area)s).createTransformedArea(t);
        }
        return new GeneralPath(s).createTransformedShape(t);
    }

    public Rectangle2D drawString(PDFFont font, String text, AffineTransform transform, float charSpacing, float wordSpacing, boolean isVisible) {
        Character wordSpaceCodeObj;
        PDFFontEncoding encoding;
        char wordSpaceCode = ' ';
        if (wordSpacing != 0.0f && font.getSubtype() != PDFFont.Subtype.Type0 && (encoding = font.getEncoding()) != null && (wordSpaceCodeObj = encoding.getSpaceCode()) != null) {
            wordSpaceCode = wordSpaceCodeObj.charValue();
        }
        if (this.page.isBuildPageImage() && !text.isEmpty()) {
            Font awtFont = font.getAWTFont();
            HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>();
            if (charSpacing != 0.0f && Math.abs(charSpacing) < 10.0f) {
                attributes.put(TextAttribute.TRACKING, Float.valueOf(charSpacing));
                attributes.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
                charSpacing = 0.0f;
            }
            awtFont = font.getCacheAccess().deriveFont(awtFont, attributes);
            this.g.setComposite((Composite)this.state.getFillComposite());
            if (this.g.getPaint() != this.state.getFillPaint().getPaint(this)) {
                this.g.setPaint(this.state.getFillPaint().getPaint(this));
            }
            if (!transform.isIdentity()) {
                transform = new AffineTransform(transform);
                transform.scale(1.0, -1.0);
                if (!transform.isIdentity()) {
                    if (Math.abs(transform.getDeterminant()) <= Double.MIN_VALUE) {
                        return null;
                    }
                    this.g.transform(transform);
                }
            } else {
                this.g.scale(1.0, -1.0);
            }
            if (this.g.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS) != RenderingHints.VALUE_FRACTIONALMETRICS_ON) {
                this.g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
            if (this.g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING) != RenderingHints.VALUE_TEXT_ANTIALIAS_ON) {
                this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (this.g.getFont() != awtFont) {
                this.g.setFont(awtFont);
            }
            if (Math.abs(charSpacing) > 1.0E-7f) {
                if (isVisible) {
                    float x = 0.0f;
                    for (int i = 0; i < text.length(); ++i) {
                        String chr = text.substring(i, i + 1);
                        BidiRenderer.drawStringOriginalOrder((Graphics2D)this.g, awtFont, font, chr, x, 0.0f);
                        x = (float)((double)x + (awtFont.getStringBounds(chr, this.g.getFontRenderContext()).getWidth() + (double)charSpacing));
                        if (text.charAt(i) != wordSpaceCode) continue;
                        x += wordSpacing;
                    }
                }
            } else if (Math.abs(wordSpacing) > 1.0E-7f) {
                int i = 0;
                float x = 0.0f;
                while (true) {
                    int pos;
                    String word;
                    String string = word = (pos = text.indexOf(wordSpaceCode, i)) == -1 ? text.substring(i) : text.substring(i, pos + 1);
                    if (word.length() != 0 && isVisible) {
                        BidiRenderer.drawStringOriginalOrder((Graphics2D)this.g, awtFont, font, word, x, 0.0f);
                    }
                    if (pos != -1) {
                        x = (float)((double)x + (awtFont.getStringBounds(word, this.g.getFontRenderContext()).getWidth() + (double)wordSpacing));
                        i = pos + 1;
                        continue;
                    }
                    break;
                }
            } else if (font.isVertical() && isVisible) {
                float y = 0.0f;
                float x = 0.0f;
                for (int i = 0; i < text.length(); ++i) {
                    String chr = text.substring(i, i + 1);
                    Rectangle2D stringBounds = awtFont.getStringBounds(chr, this.g.getFontRenderContext());
                    y = (float)((double)y + (Math.abs(stringBounds.getY()) - (stringBounds.getHeight() + stringBounds.getY()) + (double)charSpacing));
                    x = (float)((double)x + stringBounds.getWidth());
                    BidiRenderer.drawStringOriginalOrder((Graphics2D)this.g, awtFont, font, text, -x / 2.0f, y);
                    if (text.charAt(i) != wordSpaceCode) continue;
                    y += wordSpacing;
                }
            } else if (isVisible) {
                BidiRenderer.drawStringOriginalOrder((Graphics2D)this.g, awtFont, font, text, 0.0f, 0.0f);
            }
            this.setTransform(this.state.getXForm());
        }
        if (drawUpdate != null) {
            drawUpdate.update();
        }
        return null;
    }

    public void notifyNewTextElement(PDFFont font, float fontSize, AffineTransform transform, String text, Paint fillPaint, Paint strokePaint, double[] charWidths, double[] kerning, boolean hasUnicodemapping) {
        if (this.listener != null) {
            this.listener.addTextElement(font, fontSize, transform, text, fillPaint, strokePaint, charWidths, kerning, PDFFont.CHECK_ZERO, hasUnicodemapping);
        }
    }

    public void notifyNewShapeElement(boolean isClip, int pageIndex, Point2D offset, Shape shape, BasicStroke stroke, Paint strokePaint, Paint fillPaint) {
        if (this.listener != null) {
            this.listener.addShapeElement(isClip, pageIndex, offset, shape, stroke, strokePaint, fillPaint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage downSample(BufferedImage image, AffineTransform t, float maximumQualityFactor) {
        Point2D.Double p = new Point2D.Double(image.getWidth(), image.getHeight());
        double dImage = p.distance(0.0, 0.0);
        p.setLocation(t.getScaleX() + t.getShearX(), t.getShearY() + t.getScaleY());
        double dRender = p.distance(0.0, 0.0);
        ColorModel cm = image.getColorModel();
        maximumQualityFactor = (float)((double)maximumQualityFactor * (32.0 / (double)cm.getPixelSize()));
        if (dImage > dRender * (double)maximumQualityFactor && dRender > 0.0) {
            double factor = dRender / dImage * (double)maximumQualityFactor;
            int width = (int)Math.ceil((double)image.getWidth() * factor);
            int height = (int)Math.ceil((double)image.getHeight() * factor);
            int type = cm.hasAlpha() ? 2 : 5;
            long newSize = width * height * (cm.hasAlpha() ? 4 : 3);
            int sampleSize = 0;
            for (int band : image.getSampleModel().getSampleSize()) {
                sampleSize += band;
            }
            long currentSize = image.getWidth() * image.getHeight() * sampleSize / 8;
            if ((double)currentSize < (double)newSize * 1.5) {
                return image;
            }
            if (image.getWidth() * image.getHeight() > 25000000) {
                PDFImage.checkMemoryForImage(width, height);
                Object object = SCALE_SYNC;
                synchronized (object) {
                    block12: {
                        BufferedImage targetImage = new BufferedImage(width, height, type);
                        try {
                            if (image.getType() == targetImage.getType() || image.getType() == 12) {
                                AffineTransform scaleTransform = AffineTransform.getScaleInstance(factor, factor);
                                AffineTransformOp bilinearScaleOp = new AffineTransformOp(scaleTransform, 2);
                                image = bilinearScaleOp.filter(image, targetImage);
                                break block12;
                            }
                            Image scaled = image.getScaledInstance(width, height, 4);
                            MediaTracker mt = new MediaTracker(new JFrame());
                            mt.addImage(scaled, 1);
                            try {
                                mt.waitForID(1);
                            }
                            catch (InterruptedException e) {
                                return image;
                            }
                            Graphics2D g = (Graphics2D)targetImage.getGraphics();
                            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            g.drawImage(scaled, 0, 0, null);
                            g.dispose();
                            image = targetImage;
                        }
                        catch (RuntimeException e) {
                            Graphics2D g = (Graphics2D)targetImage.getGraphics();
                            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            g.drawImage(image, 0, 0, width, height, null);
                            g.dispose();
                            image = targetImage;
                        }
                    }
                }
            }
            BufferedImage targetImage = new BufferedImage(width, height, type);
            Graphics2D g2 = (Graphics2D)targetImage.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(image, 0, 0, width, height, null);
            image = targetImage;
        }
        return image;
    }

    public Rectangle2D drawImage(PDFImage image, boolean isVisible, boolean isType3Glyph) {
        SerializableImage si = image.getOutputImage(this.state, this);
        Rectangle bounds = si != null && si.getImage() != null ? new Rectangle(si.getMinX(), si.getMinY(), si.getWidth(), si.getHeight()) : new Rectangle(image.getWidth(), image.getHeight());
        if (this.listener != null) {
            if (si == null) {
                si = new SerializableImage((Image)new BufferedImage(1, 1, 2), null);
            }
            this.listener.addImageElement(si, this.getMetaData(image), this.getTransform(), this.getCurrentState().getClip(), this.page.getPageIndex(), isType3Glyph);
        }
        AffineTransform at = new AffineTransform(1.0f / (float)bounds.width, 0.0f, 0.0f, -1.0f / (float)bounds.height, 0.0f, 1.0f);
        if (this.page.isBuildPageImage() && isVisible) {
            this.g.setComposite((Composite)this.state.getFillComposite());
            if (si != null && si.getImage() != null) {
                if (this.shouldScaleDown && si.getPersistenceKey() == null && si.getImage() instanceof BufferedImage) {
                    si = new SerializableImage((Image)PDFRenderer.downSample(si.getBufferedImage(), this.g.getTransform(), this.maximumQualityFactor), null);
                }
                at = new AffineTransform(1.0f / (float)si.getWidth(null), 0.0f, 0.0f, -1.0f / (float)si.getHeight(null), 0.0f, 1.0f);
                if (!this.g.drawImage((Image)si.getPaintableInstance(), at, null) && PDFParser.LOGGER.isDebug()) {
                    PDFParser.LOGGER.debug((Object)"Image not completed!");
                }
            } else {
                BufferedImage buffer = new BufferedImage(bounds.width, bounds.height, 2);
                Graphics2D g2 = (Graphics2D)buffer.getGraphics();
                Color color = this.g.getColor();
                Image errorImage = image.isJPEG2000() ? JPEG2000_ERROR_IMAGE : MISSING_RESOURCE_IMAGE;
                int w = errorImage.getWidth(null);
                int h = errorImage.getHeight(null);
                TexturePaint paint = new TexturePaint((BufferedImage)errorImage, new Rectangle(w, h));
                g2.setPaint(paint);
                g2.fillRect(0, 0, bounds.width, bounds.height);
                g2.dispose();
                this.g.drawImage((Image)buffer, at, null);
                this.g.setColor(color);
            }
        }
        AffineTransform bt = new AffineTransform(this.state.getXForm());
        bt.concatenate(at);
        if (drawUpdate != null) {
            drawUpdate.update();
        }
        return bt.createTransformedShape(bounds).getBounds2D();
    }

    private ParserListener.PDFImageMeta getMetaData(PDFImage image) {
        ParserListener.PDFImageMeta.TYPE type = ParserListener.PDFImageMeta.TYPE.unknown;
        boolean hasAlpha = image.getSMask() != null;
        String format = ImageUtils.detectImageFormat((byte[])image.first16byteData());
        if (image.getColorSpace() != null && image.getColorSpace().getColorSpace() != null) {
            int pdfColorSpaceType = image.getColorSpace().getColorSpace().getType();
            if (pdfColorSpaceType == 11 || pdfColorSpaceType == 9) {
                type = ParserListener.PDFImageMeta.TYPE.CMYK;
            } else if (pdfColorSpaceType == 6) {
                type = ParserListener.PDFImageMeta.TYPE.GRAY;
            } else if (pdfColorSpaceType == 5) {
                type = ParserListener.PDFImageMeta.TYPE.RGB;
            }
        }
        if (image.isJPEG2000()) {
            format = "JPEG2000";
        }
        return new ParserListener.PDFImageMeta(type, hasAlpha, format);
    }

    public Shape clip(Shape s) {
        Area ca;
        if (s == null) {
            if (this.page.isBuildPageImage()) {
                this.g.setClip(null);
            }
            this.state.setClip(null);
            this.state.setClipFromGraphics(null);
            return null;
        }
        if (this.page.isBuildPageImage()) {
            this.g.clip(s);
            this.state.setClipFromGraphics((Graphics2D)this.g);
        }
        Area area = ca = (s = PDFRenderer.createTransformedShape(s, this.state.getXForm())) instanceof Area ? (Area)s : new Area(s);
        if (this.state.getClip() == null) {
            this.state.setClip(ca.isEmpty() ? null : s);
        } else {
            Area userArea = new Area(this.state.getClip());
            userArea.intersect(ca);
            if (userArea.isEmpty()) {
                this.state.setClip(null);
                return null;
            }
            this.state.setClip(userArea);
        }
        return this.state.getClip();
    }

    private void setClip(Shape s, Shape sG) {
        this.state.setClip(s);
        if (this.page.isBuildPageImage()) {
            this.g.setClip(sG);
        }
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.state.getXForm());
    }

    public void transform(AffineTransform at) {
        this.state.getXForm().concatenate(at);
        this.setTransform();
    }

    private void setTransform(AffineTransform at) {
        this.state.setXform(at);
        this.setTransform();
    }

    private void setTransform() {
        if (this.page.isBuildPageImage()) {
            this.g.setTransform(this.startTransforms.peek());
            this.g.transform(this.scaleModel(this.state.getXForm()));
        }
    }

    private AffineTransform scaleModel(AffineTransform in) {
        double[] matrix = new double[6];
        in.getMatrix(matrix);
        matrix[0] = matrix[0] * this.getScaleX();
        matrix[1] = matrix[1] * this.getScaleY();
        matrix[2] = matrix[2] * this.getScaleX();
        matrix[3] = matrix[3] * this.getScaleY();
        matrix[4] = matrix[4] * this.getScaleX();
        matrix[5] = matrix[5] * this.getScaleY();
        return new AffineTransform(matrix);
    }

    public AffineTransform getInitialTransform() {
        return this.page.getInitialTransform();
    }

    public void setStrokeParts(float w, int cap, int join, float limit, float[] ary, float phase) {
        if (w == -1000.0f) {
            w = this.state.getStroke().getLineWidth();
        }
        if (cap == -1000) {
            cap = this.state.getStroke().getEndCap();
        }
        if (join == -1000) {
            join = this.state.getStroke().getLineJoin();
        }
        if (limit == -1000.0f) {
            limit = this.state.getStroke().getMiterLimit();
        }
        if (phase == -1000.0f) {
            ary = this.state.getStroke().getDashArray();
            phase = this.state.getStroke().getDashPhase();
        }
        if (ary != null && ary.length == 0) {
            ary = null;
        }
        if (phase == -1000.0f) {
            this.state.setStroke(new BasicStroke(w, cap, join, limit));
        } else {
            this.state.setStroke(new BasicStroke(w, cap, join, limit, ary, phase));
        }
    }

    public void setStrokePaint(PDFPaint paint) {
        this.state.setStrokePaint(paint);
    }

    public void setFillPaint(PDFPaint paint) {
        this.state.setFillPaint(paint);
    }

    @Override
    public void setup() {
        if (this.page.isBuildPageImage()) {
            if (this.g != null) {
                this.g = this.setupRendering(this.g);
                this.setTransform(this.state.getXForm());
            }
        } else {
            this.setupRendering();
        }
    }

    @Override
    public int iterate() throws Exception {
        PDFCmd cmd;
        if (this.page == null) {
            PDFParser.LOGGER.debug((Object)"iterate: page is 'null' - state is COMPLETED");
            return 6;
        }
        if (this.currentCommand >= this.page.getCommandCount()) {
            if (this.page.isFinished()) {
                if (this.page.isBuildPageImage() && drawUpdate != null) {
                    drawUpdate.update();
                }
                if (PDFParser.LOGGER.isDebug()) {
                    PDFParser.LOGGER.debug((Object)"iterate: page is finished");
                }
                return 6;
            }
            if (PDFParser.LOGGER.isDebug()) {
                PDFParser.LOGGER.debug((Object)"iterate: needs data");
            }
            return 3;
        }
        if ((cmd = this.page.getCommand(this.currentCommand++)) == null) {
            throw new PDFParseException("Command not found!");
        }
        if (PDFParser.LOGGER.isDebug()) {
            PDFParser.LOGGER.debug((Object)("iterate: " + this.currentCommand + " / " + this.page.getCommandCount() + ": " + String.valueOf(cmd)));
        }
        cmd.execute(this);
        return 4;
    }

    @Override
    public void cleanup() {
        this.page = null;
        this.state = null;
        this.stack = null;
    }

    public GraphicsState getCurrentState() {
        return this.state;
    }

    private void execClipShapeCmd(Shape clip) {
        PDFShapeCmd additionalClipCmd = new PDFShapeCmd(clip, 4, false, this.page.getPageIndex());
        additionalClipCmd.executeAdditionalClip(this);
    }

    public static String toHexText(String text) {
        StringBuilder sb = new StringBuilder("( ");
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr >= ' ') {
                sb.append(chr);
            } else {
                sb.append(".");
            }
            sb.append(String.format(" %02x ", chr));
        }
        sb.append(" )");
        return sb.toString();
    }

    private String createLayerIndent() {
        return this.createLayerIndent(this.layerCounter);
    }

    private String createLayerIndent(int indentCount) {
        Object result = "";
        for (int i = 0; i < indentCount; ++i) {
            if (i == 0) {
                result = (String)result + indentCount;
            }
            result = (String)result + "\t";
        }
        return result;
    }

    public Rectangle2D getPageSize() {
        return this.page.getBounds();
    }

    public static interface DrawUpdate {
        public void update();
    }
}

