/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.pdfview.PDFFile;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.ReferenceFactory;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.PDFDecoder;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.FontCache;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public class PDFObject {
    public static final int INDIRECT = 0;
    public static final int BOOLEAN = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 3;
    public static final int NAME = 4;
    public static final int ARRAY = 5;
    public static final int DICTIONARY = 6;
    public static final int STREAM = 7;
    public static final int NULL = 8;
    public static final int KEYWORD = 9;
    public static final int OBJ_STREAM = 13;
    public static final PDFObject NULL_OBJECT = new PDFObject(null, 8, null);
    private byte type;
    private Object value;
    private IDataBuffer stream;
    private PDFFile owner;
    private Object cache;
    private boolean streamDecoded = false;

    public PDFObject(PDFFile owner, int type, Object value) {
        this.type = (byte)type;
        if (type == 9) {
            if (value.equals("true")) {
                this.type = 1;
                value = Boolean.TRUE;
            } else if (value.equals("false")) {
                this.type = 1;
                value = Boolean.FALSE;
            } else {
                value = owner.mapKeyword((String)value);
            }
        }
        this.value = value;
        this.owner = owner;
    }

    public PDFObject(Object obj, PDFFile owner) {
        this.owner = null;
        this.value = obj;
        if (obj instanceof Double || obj instanceof Integer) {
            this.type = (byte)2;
        } else if (obj instanceof String) {
            this.type = (byte)4;
            this.value = PDFFile.unicode((String)obj);
        } else if (obj instanceof PDFObject[]) {
            this.type = (byte)5;
        } else if (obj instanceof Object[]) {
            Object[] srcary = (Object[])obj;
            PDFObject[] dstary = new PDFObject[srcary.length];
            for (int i = 0; i < srcary.length; ++i) {
                dstary[i] = new PDFObject(srcary[i], owner);
            }
            this.value = dstary;
            this.type = (byte)5;
        } else if (obj instanceof Map) {
            this.type = (byte)6;
        } else if (obj instanceof Boolean) {
            this.type = 1;
        } else if (obj instanceof PDFParser.Tok) {
            PDFParser.Tok tok = (PDFParser.Tok)obj;
            if (tok.getName().equals("true")) {
                this.value = Boolean.TRUE;
                this.type = 1;
            } else if (tok.getName().equals("false")) {
                this.value = Boolean.FALSE;
                this.type = 1;
            } else {
                this.value = tok.getName();
                this.type = (byte)4;
            }
        } else {
            throw new IllegalArgumentException("Bad type for raw PDFObject: " + String.valueOf(obj));
        }
    }

    public PDFObject(PDFFile owner, PDFXref xref) {
        this.type = 0;
        this.value = xref;
        this.owner = owner;
    }

    public FontCache getFontCache() {
        return this.owner.getFontCache();
    }

    public PDFFile getOwner() {
        return this.owner;
    }

    public int getType() throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getType();
        }
        return this.type;
    }

    public void setStream(IDataBuffer data) {
        this.type = (byte)7;
        this.stream = data;
    }

    @Nullable
    public Object getCache() throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getCache();
        }
        if (this.cache != null) {
            return ((Reference)this.cache).get();
        }
        return null;
    }

    public void setCache(Object obj) throws PDFParseException {
        if (this.type == 0) {
            this.dereference().setCache(obj);
            return;
        }
        this.cache = ReferenceFactory.createReference(obj);
    }

    public byte[] getStream(PDFXref ref, @Nullable PDFDecrypter decryptor, boolean throwException) throws PDFParseException {
        if (this.type == 0) {
            if (decryptor != null) {
                PDFObject obj = this.dereference();
                PDFXref newref = null;
                newref = obj.getRefValue();
                if (newref != null) {
                    ref = newref;
                }
                return obj.getStream(ref, decryptor, throwException);
            }
            return this.dereference().getStream(ref, decryptor, throwException);
        }
        if (this.type == 7 && this.stream != null) {
            byte[] ary;
            IDataBuffer streamBuf;
            PDFObject streamLength = this.getDictRef("Length");
            if (streamLength != null && streamLength.getIntValue() <= 0) {
                return new byte[0];
            }
            try {
                streamBuf = decryptor == null ? this.decodeStream(this.stream) : this.decodeStream(ArrayBuffer.wrap(PDFObject.decryptIDataBuffer(this.stream, ref, decryptor)));
            }
            catch (Throwable e) {
                if (throwException) {
                    throw e;
                }
                if (e.getCause() instanceof InterruptedException) {
                    PDFParser.LOGGER.error(e);
                }
                return null;
            }
            if (streamBuf == null) {
                return null;
            }
            if (streamBuf.hasArray() && streamBuf.arrayOffset() == 0 && (ary = streamBuf.array()).length == streamBuf.remaining()) {
                return ary;
            }
            byte[] data = new byte[streamBuf.remaining()];
            streamBuf.get(data);
            streamBuf.flip();
            return data;
        }
        if (this.type == 4 && this.value instanceof String) {
            String strValue = (String)this.value;
            int len = strValue.length();
            byte[] data = new byte[len * 2];
            for (int i = 0; i < len; ++i) {
                data[2 * i] = (byte)(strValue.charAt(i) >> 2 & 0xFF);
                data[2 * i + 1] = (byte)(strValue.charAt(i) & 0xFF);
            }
            return data;
        }
        if (this.type == 3) {
            String src = this.getStringValue();
            byte[] data = new byte[src.length()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)src.charAt(i);
            }
            return data;
        }
        return null;
    }

    public static byte[] decryptIDataBuffer(IDataBuffer byteStream, PDFXref ref, PDFDecrypter decryptor) {
        if (byteStream == null) {
            throw new RuntimeException("invalid byte buffer: null");
        }
        byteStream.rewind();
        int byteSize = byteStream.remaining();
        if (byteSize == 0) {
            return new byte[0];
        }
        byte[] data = new byte[byteSize];
        byteStream.get(data);
        if (ref == null) {
            if (PDFParser.LOGGER.isDebug()) {
                PDFParser.LOGGER.debug((Object)"reference object not defined");
            }
            return data;
        }
        int objNum = ref.getID();
        int revNum = ref.getGeneration();
        data = decryptor.decrypt(data, data.length, objNum, revNum);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDataBuffer getStreamBuffer(PDFXref ref, PDFDecrypter decryptor) throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getStreamBuffer(ref, decryptor);
        }
        if (this.type == 7 && this.stream != null) {
            Object obj;
            if (decryptor != null) {
                obj = this.dereference();
                PDFXref newref = ((PDFObject)obj).getRefValue();
                if (newref != null) {
                    ref = newref;
                }
                if (!this.streamDecoded) {
                    byte[] data = PDFObject.decryptIDataBuffer(this.stream, ref, decryptor);
                    this.stream = ArrayBuffer.wrap(data);
                    this.streamDecoded = true;
                }
            }
            obj = this.stream;
            synchronized (obj) {
                IDataBuffer streamBuf = this.decodeStream(this.stream);
                return streamBuf.duplicate();
            }
        }
        if (this.type == 3) {
            String src = this.getStringValue();
            return ArrayBuffer.wrap(src.getBytes());
        }
        return null;
    }

    public IDataBuffer getStreamRaw(PDFXref ref, PDFDecrypter decryptor) throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getStreamRaw(ref, decryptor);
        }
        if (this.type == 7 && this.stream != null) {
            if (decryptor != null) {
                PDFObject obj = this.dereference();
                PDFXref newref = obj.getRefValue();
                if (newref != null) {
                    ref = newref;
                }
                byte[] data = PDFObject.decryptIDataBuffer(this.stream.duplicate(), ref, decryptor);
                return ArrayBuffer.wrap(data);
            }
            return this.stream.duplicate();
        }
        return null;
    }

    private IDataBuffer decodeStream(IDataBuffer bb_stream) throws PDFParseException {
        bb_stream.rewind();
        PDFDecrypter decryptor = this.owner != null ? this.owner.getDecryptor() : null;
        return PDFDecoder.decodeStream(this, bb_stream, decryptor);
    }

    public int getIntValue() throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getIntValue();
        }
        if (this.type == 2) {
            return ((Double)this.value).intValue();
        }
        return 0;
    }

    public float getFloatValue() throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getFloatValue();
        }
        if (this.type == 2) {
            return ((Double)this.value).floatValue();
        }
        return 0.0f;
    }

    public double getDoubleValue() throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getDoubleValue();
        }
        if (this.type == 2) {
            return (Double)this.value;
        }
        return 0.0;
    }

    public String getStringValue() throws PDFParseException {
        switch (this.type) {
            case 0: {
                return this.dereference().getStringValue();
            }
            case 3: {
                return (String)this.value;
            }
            case 4: 
            case 9: {
                return PDFObject.decodeName((String)this.value);
            }
            case 2: {
                return ((Number)this.value).toString();
            }
        }
        return null;
    }

    public static String decodeName(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(35) < 0) {
            return string;
        }
        int pos = 0;
        StringBuilder b = new StringBuilder();
        while (pos < string.length()) {
            int next = string.indexOf(35, pos);
            if (next < 0 || next >= string.length() - 2) {
                b.append(string.substring(pos));
                break;
            }
            b.append(string.substring(pos, next));
            String hex = string.substring(next, next + 3);
            try {
                b.append((char)Integer.decode(hex).intValue());
            }
            catch (Exception e) {
                b.append(hex);
            }
            pos = next + 3;
        }
        return b.toString();
    }

    public PDFObject[] getArray() throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getArray();
        }
        if (this.type == 5) {
            PDFObject[] ary = (PDFObject[])this.value;
            return ary;
        }
        PDFObject[] ary = new PDFObject[]{this};
        return ary;
    }

    public boolean getBooleanValue() throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getBooleanValue();
        }
        if (this.type == 1) {
            return this.value == Boolean.TRUE;
        }
        return false;
    }

    public PDFObject getAt(int idx) throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getAt(idx);
        }
        if (this.type == 5) {
            PDFObject[] ary = (PDFObject[])this.value;
            return ary[idx];
        }
        return null;
    }

    public Iterator<String> getDictKeys() throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getDictKeys();
        }
        if (this.type == 6 || this.type == 7) {
            return ((Map)this.value).keySet().iterator();
        }
        return new ArrayList().iterator();
    }

    public Map<String, PDFObject> getDictionary() throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getDictionary();
        }
        if (this.type == 6 || this.type == 7) {
            return (Map)this.value;
        }
        return new HashMap<String, PDFObject>();
    }

    public PDFObject getDictRef(String key) throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().getDictRef(key);
        }
        if (this.type == 6 || this.type == 7) {
            Map h = (Map)this.value;
            PDFObject obj = (PDFObject)h.get(key);
            if (obj == null && key.indexOf(43) >= 0) {
                key = key.replace("+", "#2B");
                obj = (PDFObject)h.get(key);
            }
            if (obj == null && key.indexOf(95) >= 0) {
                key = key.replace("_", "#5F");
                obj = (PDFObject)h.get(key);
            }
            return obj;
        }
        return null;
    }

    public boolean isDictType(String match) throws PDFParseException {
        if (this.type == 0) {
            return this.dereference().isDictType(match);
        }
        if (this.type != 6 && this.type != 7) {
            return false;
        }
        PDFObject obj = this.getDictRef("Type");
        return obj != null && obj.getStringValue().equals(match);
    }

    public String toString() {
        try {
            switch (this.type) {
                case 0: {
                    return "Indirect to #" + ((PDFXref)this.value).getID();
                }
                case 1: {
                    return "Boolean: " + (this.getBooleanValue() ? "true" : "false");
                }
                case 2: {
                    return "Number: " + this.getDoubleValue();
                }
                case 3: {
                    return "String: " + this.getStringValue();
                }
                case 4: {
                    return "Name: /" + this.getStringValue();
                }
                case 5: {
                    return "Array, length=" + ((PDFObject[])this.value).length;
                }
                case 6: {
                    StringBuffer sb = new StringBuffer();
                    PDFObject obj = this.getDictRef("Type");
                    if (obj != null) {
                        sb.append(obj.getStringValue());
                        obj = this.getDictRef("Subtype");
                        if (obj != null) {
                            sb.append("/" + obj.getStringValue());
                        }
                    } else {
                        sb.append("Untyped");
                    }
                    sb.append(" dictionary. Keys:");
                    HashMap hm = (HashMap)this.value;
                    Iterator it = hm.keySet().iterator();
                    while (it.hasNext()) {
                        sb.append(" " + (String)it.next());
                    }
                    return sb.toString();
                }
                case 7: {
                    try {
                        byte[] st = this.getStream(null, null, false);
                        if (st == null) {
                            return "Broken stream";
                        }
                        return "Stream: [[" + new String(st, 0, st.length > 30 ? 30 : st.length) + "]]";
                    }
                    catch (Throwable e) {
                        return "Stream with encoding error: " + e.getClass().getSimpleName() + ": " + e.getMessage();
                    }
                }
                case 8: {
                    return "Null";
                }
                case 9: {
                    return "Keyword: " + this.getStringValue();
                }
            }
            return "Whoops!  big error!  Unknown type";
        }
        catch (PDFParseException ioe) {
            return "Caught an error: " + String.valueOf((Object)ioe);
        }
    }

    public PDFObject dereference() throws PDFParseException {
        if (this.type == 0) {
            PDFObject obj = null;
            if (obj == null) {
                if (this.owner == null) {
                    if (PDFParser.LOGGER.isDebug()) {
                        PDFParser.LOGGER.debug((Object)("Bad seed (owner==null)!  Object=" + String.valueOf(this)));
                    }
                    return this;
                }
                obj = this.owner.dereference((PDFXref)this.value);
                this.cache = ReferenceFactory.createReference(obj);
            }
            return obj;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (this.type == 0 && o instanceof PDFObject) {
            PDFObject obj = (PDFObject)o;
            if (obj.type == 0) {
                PDFXref lXref = (PDFXref)this.value;
                PDFXref rXref = (PDFXref)obj.value;
                return lXref.getID() == rXref.getID() && lXref.getGeneration() == rXref.getGeneration();
            }
        }
        return false;
    }

    @Nullable
    public PDFXref getRefValue() {
        if (this.type == 0) {
            return (PDFXref)this.value;
        }
        return null;
    }

    public PDFObject getRoot() {
        return this.owner.getRoot();
    }
}

