/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.pdfview.PDFFile;
import com.inet.pdfview.data.FileBuffer;
import com.inet.pdfview.data.RandomAccessBuffer;
import com.inet.pdfview.error.PDFParseException;
import com.inet.persistence.RandomAccessRead;
import java.io.File;
import java.io.IOException;

public class PDFMainParser {
    public static PDFFile parseFile(File file, boolean createPageImages, boolean showPageImages) throws PDFParseException {
        return PDFMainParser.parseFile(file, createPageImages, showPageImages, null);
    }

    public static PDFFile parseFile(File file, boolean createPageImages, boolean showPageImages, String userPassword) throws PDFParseException {
        try {
            return new PDFFile(new FileBuffer(file), file.getName(), userPassword);
        }
        catch (IOException ex) {
            throw PDFParseException.create(ex);
        }
    }

    public static PDFFile parseFile(RandomAccessRead source, String filename, boolean createPageImages, boolean showPageImages, String userPassword) throws PDFParseException {
        try {
            return new PDFFile(new RandomAccessBuffer(source), filename, userPassword);
        }
        catch (IOException ex) {
            throw PDFParseException.create(ex);
        }
    }
}

