/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.structure;

import java.util.HashMap;
import java.util.Map;

public enum StructureType {
    Document(BaseType.Grouping),
    Part(BaseType.Grouping),
    Art(BaseType.Grouping),
    Sect(BaseType.Grouping),
    Div(BaseType.Grouping),
    BlockQuote(BaseType.Grouping),
    Caption(BaseType.Grouping),
    TOC(BaseType.Grouping),
    TOCI(BaseType.Grouping),
    Index(BaseType.Grouping),
    NonStruct(BaseType.Grouping),
    Private(BaseType.Grouping),
    Figure(BaseType.Grouping),
    StructTreeRoot(BaseType.Grouping),
    P(BaseType.Block),
    H(BaseType.Block),
    H1(BaseType.Block),
    H2(BaseType.Block),
    H3(BaseType.Block),
    H4(BaseType.Block),
    H5(BaseType.Block),
    H6(BaseType.Block),
    L(BaseType.Block),
    Lbl(BaseType.Block),
    LI(BaseType.Block),
    LBody(BaseType.Block),
    Table(BaseType.Block),
    TR(BaseType.Block),
    TH(BaseType.Block),
    TD(BaseType.Block),
    TBody(BaseType.Block),
    THead(BaseType.Block),
    TFoot(BaseType.Block),
    Span(BaseType.Inline),
    Quote(BaseType.Inline),
    Note(BaseType.Inline),
    Reference(BaseType.Inline),
    BibEntry(BaseType.Inline),
    Code(BaseType.Inline),
    Link(BaseType.Inline),
    Annot(BaseType.Inline),
    Ruby(BaseType.Inline),
    Warichu(BaseType.Inline),
    Footnote(BaseType.Inline),
    Endnote(BaseType.Inline);

    private static final Map<String, StructureType> lcMap;
    private BaseType baseType;

    public static StructureType getType(String typeString) {
        StructureType type = typeString != null ? lcMap.get(typeString.toLowerCase()) : Private;
        return type != null ? type : Private;
    }

    private StructureType(BaseType baseType) {
        this.baseType = baseType;
    }

    public BaseType getBaseType() {
        return this.baseType;
    }

    static {
        lcMap = new HashMap<String, StructureType>();
        for (StructureType type : StructureType.values()) {
            lcMap.put(type.name().toLowerCase(), type);
        }
    }

    public static enum BaseType {
        Grouping,
        Block,
        Inline;

    }
}

