/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern.shadertype4;

import com.inet.pdfview.pattern.shadertype4.ColorVertex;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;

public class VertexTriangle
implements Serializable {
    private static final long serialVersionUID = -1418590937916821290L;
    private static final int NUM_POINTS = 3;
    static final int DOUBLE_TOP_TYPE = 0;
    static final int DOUBLE_BOTTOM_TYPE = 1;
    static final int INTERMIDIATE_VERTEX_TO_THE_LEFT = 2;
    static final int INTERMIDIATE_VERTEX_TO_THE_RIGHT = 3;
    private int type;
    private ColorVertex[] vertexes = new ColorVertex[3];
    private double minX = Double.MAX_VALUE;
    private double maxX;
    private int count;

    VertexTriangle() {
    }

    VertexTriangle(ColorVertex[] vertexes) {
        this.vertexes = vertexes;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VertexTriangle)) {
            return false;
        }
        VertexTriangle other = (VertexTriangle)obj;
        if (this.count != other.count || this.type != other.type || this.vertexes.length != other.vertexes.length) {
            return false;
        }
        return Arrays.equals(this.vertexes, other.vertexes);
    }

    void addVertex(ColorVertex vertex) {
        this.vertexes[this.count++] = vertex;
    }

    boolean addVertex(int flag, double x, double y, float[] colorComp) {
        if (this.count >= 3) {
            return false;
        }
        this.vertexes[this.count++] = new ColorVertex(flag, new Point2D.Double(x, y), colorComp);
        return true;
    }

    int getType() {
        return this.type;
    }

    void normalize() {
        Arrays.sort(this.vertexes);
        ColorVertex v1 = this.vertexes[0];
        ColorVertex v2 = this.vertexes[1];
        ColorVertex v3 = this.vertexes[2];
        if (v1.hasTheSameYPosAs(v2)) {
            this.type = 0;
        } else if (v2.hasTheSameYPosAs(v3)) {
            this.type = 1;
        } else {
            double linePosXOnTheLevelOfv2 = v1.getX() + (v3.getX() - v1.getX()) * (v2.getY() - v1.getY()) / (v3.getY() - v1.getY());
            this.type = v2.getX() < linePosXOnTheLevelOfv2 ? 2 : 3;
        }
        this.setMaXAndMinX();
    }

    ColorVertex[] getVertexes() {
        return this.vertexes;
    }

    void setMaXAndMinX() {
        for (ColorVertex v : this.vertexes) {
            double x = v.getX();
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (!(x < this.minX)) continue;
            this.minX = x;
        }
    }

    double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    VertexTriangle getTtransformedTriangle(AffineTransform transformation) {
        ColorVertex[] transformedVertexes = new ColorVertex[3];
        for (int i = 0; i < this.vertexes.length; ++i) {
            Point2D transformedPoint = transformation.transform(this.vertexes[i].getVertexPoint(), null);
            transformedVertexes[i] = new ColorVertex(this.vertexes[i].getFlag(), transformedPoint, this.vertexes[i].getColorComp());
        }
        return new VertexTriangle(transformedVertexes);
    }
}

