/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.function;

import com.inet.pdfview.PDFFile;
import com.inet.pdfview.function.cmds.PSCmd;
import com.inet.pdfview.function.cmds.PSExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;

public class PSCmdParser {
    private byte[] psString;
    private int position;
    private boolean runs;
    private Stack<PSExpression> expressionStack = new Stack();
    private PSExpression currentExpression;
    @Nullable
    private List<PSExpression> expressionsLis;

    PSCmdParser(byte[] psString) {
        this.psString = psString;
    }

    List<PSCmd> parse() throws IllegalStateException {
        ArrayList<PSCmd> listOfCmd = new ArrayList<PSCmd>();
        List<Double> argList = new ArrayList<Double>();
        boolean doParse = true;
        block5: while (doParse && this.position < this.psString.length) {
            Token token = this.nextToken();
            switch (token.type) {
                case 5: {
                    if (this.runs) {
                        if (this.currentExpression != null) {
                            this.expressionStack.push(this.currentExpression);
                        } else if (this.expressionsLis == null) {
                            this.expressionsLis = new ArrayList<PSExpression>();
                        }
                        this.currentExpression = new PSExpression(argList, this, this.expressionsLis.size());
                        this.expressionsLis.add(this.currentExpression);
                        continue block5;
                    }
                    this.runs = true;
                    continue block5;
                }
                case 4: {
                    if (this.currentExpression != null) {
                        int expressionIndex = this.currentExpression.getIndex();
                        if (this.expressionStack.isEmpty()) {
                            if (argList == null) {
                                argList = new ArrayList();
                            }
                            argList.add(Double.valueOf(expressionIndex));
                            this.currentExpression = null;
                            continue block5;
                        }
                        this.currentExpression = this.expressionStack.pop();
                        Token expressiontoken = new Token();
                        expressiontoken.type = 3;
                        expressiontoken.value = expressionIndex;
                        this.currentExpression.addToken(expressiontoken);
                        continue block5;
                    }
                    if (argList == null || argList.size() == 0) continue block5;
                    PSCmd cmd = PSCmd.getCmd("IDTY", 2, argList, this);
                    listOfCmd.add(cmd);
                    argList = null;
                    doParse = false;
                    continue block5;
                }
                case 6: {
                    doParse = false;
                    continue block5;
                }
            }
            if (this.currentExpression != null) {
                this.currentExpression.addToken(token);
                continue;
            }
            argList = this.proceedToken(token, listOfCmd, argList);
        }
        return listOfCmd;
    }

    List<Double> proceedToken(Token token, List<PSCmd> listOfCmd, List<Double> argList) {
        switch (token.type) {
            case 3: {
                if (argList == null) {
                    argList = new ArrayList<Double>();
                }
                argList.add(token.value);
                break;
            }
            case 2: {
                if (this.currentExpression != null) {
                    this.currentExpression.addToken(token);
                    break;
                }
                PSCmd cmd = PSCmd.getCmd(token.name, token.type, argList, this);
                listOfCmd.add(cmd);
                argList = null;
            }
        }
        return argList;
    }

    public List<Double> interpretToken(Token token, List<Double> inputData) {
        switch (token.type) {
            case 3: {
                if (inputData == null) {
                    inputData = new ArrayList<Double>();
                }
                inputData.add(token.value);
                break;
            }
            case 2: {
                PSCmd cmd = PSCmd.getCmd(token.name, token.type, inputData, this);
                inputData = cmd.exec(null);
            }
        }
        return inputData;
    }

    private Token nextToken() {
        Token token = new Token();
        while (this.position < this.psString.length && PDFFile.isWhiteSpace(this.psString[this.position])) {
            ++this.position;
        }
        if (this.position >= this.psString.length) {
            token.type = 6;
            return token;
        }
        byte ch = this.psString[this.position++];
        while (Character.isWhitespace(ch)) {
            if (this.position >= this.psString.length) continue;
            ch = this.psString[this.position++];
        }
        while (ch == 37) {
            StringBuffer comment = new StringBuffer();
            while (this.position < this.psString.length && ch != 10) {
                comment.append((char)ch);
                ch = this.psString[this.position++];
            }
            while (this.position < this.psString.length && (ch == 10 || ch == 13)) {
                ch = this.psString[this.position++];
            }
        }
        if (ch == 46 || ch == 45 || ch >= 48 && ch <= 57) {
            --this.position;
            token.type = 3;
            token.value = this.readNum();
        } else if (ch >= 97 && ch <= 122) {
            token.type = 2;
            token.name = this.readName();
        } else if (ch == 125) {
            token.type = 4;
        } else if (ch == 123) {
            token.type = 5;
        } else {
            throw new IllegalStateException("EOF not found");
        }
        return token;
    }

    private double readNum() {
        double value;
        boolean neg;
        block5: {
            byte ch;
            neg = (ch = this.psString[this.position++]) == 45;
            boolean withDot = ch == 46;
            double dotmult = withDot ? 0.1 : 1.0;
            double d = value = ch >= 48 && ch <= 57 ? (double)(ch - 48) : 0.0;
            while (true) {
                if ((ch = this.psString[this.position++]) == 46) {
                    if (withDot) {
                        --this.position;
                        break block5;
                    }
                    withDot = true;
                    dotmult = 0.1;
                    continue;
                }
                if (ch < 48 || ch > 57) break;
                int val = ch - 48;
                if (withDot) {
                    value += (double)val * dotmult;
                    dotmult *= 0.1;
                    continue;
                }
                value = value * 10.0 + (double)val;
            }
            --this.position;
        }
        if (neg) {
            value = -value;
        }
        return value;
    }

    private String readName() {
        int start = this.position - 1;
        while (this.position < this.psString.length) {
            byte ch;
            if ((ch = this.psString[this.position++]) >= 97 && ch <= 122) continue;
            --this.position;
            break;
        }
        return new String(this.psString, start, this.position - start);
    }

    public PSExpression getExpression(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.expressionsLis.size()) {
            throw new IndexOutOfBoundsException("invalid index of ps expression " + index);
        }
        return this.expressionsLis.get(index);
    }

    public static class Token {
        public static final int CMD = 2;
        public static final int NUM = 3;
        public static final int BRCB = 5;
        public static final int BRCE = 4;
        public static final int EOS = 6;
        public String name;
        public double value;
        public int type;
    }
}

