/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.function;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.function.PDFFunction;
import java.util.Arrays;

public class FunctionType3
extends PDFFunction {
    private static final long serialVersionUID = -5271455437087770231L;
    private float[] subDomains;
    private PDFFunction[] functions;
    private float[] encode;

    protected FunctionType3() {
        super(3);
    }

    public void setSubDomains(float[] subDomains) {
        this.subDomains = subDomains;
    }

    public void setFunctions(PDFFunction[] functions) {
        this.functions = functions;
    }

    @Override
    public float[] getSubDomains() {
        return this.subDomains;
    }

    @Override
    protected void doFunction(float[] inputs, int inputOffset, float[] outputs, int outputOffset) {
        float in = inputs[inputOffset];
        int functionIndex = this.findDomainIndex(in);
        float low0 = this.subDomains[functionIndex];
        float high0 = this.subDomains[functionIndex + 1];
        float low1 = this.encode[functionIndex * 2];
        float high1 = this.encode[functionIndex * 2 + 1];
        in = low0 == high0 ? low1 : low1 + (in - low0) * (high1 - low1) / (high0 - low0);
        this.functions[functionIndex].doFunction(new float[]{in}, 0, outputs, outputOffset);
    }

    @Override
    protected void parse(PDFObject obj, PDFDecrypter decryptor, PDFXref ref) throws PDFParseException {
        int i;
        int i2;
        PDFObject boundObj = obj.getDictRef("Bounds");
        PDFObject[] boundObjs = boundObj.getArray();
        int domainCount = boundObjs.length + 1;
        this.subDomains = new float[domainCount + 1];
        this.subDomains[0] = this.getDomain(0);
        this.subDomains[domainCount] = this.getDomain(1);
        for (i2 = 0; i2 < domainCount - 1; ++i2) {
            this.subDomains[i2 + 1] = boundObjs[i2].getFloatValue();
            if (!(this.subDomains[i2] >= this.subDomains[i2 + 1])) continue;
            this.subDomains[i2 + 1] = this.subDomains[i2] + 1.0E-4f;
        }
        if (this.subDomains.length >= 2) {
            for (i2 = this.subDomains.length - 1; i2 > 0; --i2) {
                if (!(this.subDomains[i2] <= this.subDomains[i2 - 1])) continue;
                this.subDomains[i2 - 1] = this.subDomains[i2] - 1.0E-4f;
            }
        }
        PDFObject functionObj = obj.getDictRef("Functions");
        ref = functionObj.getRefValue();
        PDFObject[] functionObjs = functionObj.getArray();
        int functionSize = functionObjs.length;
        if (functionSize != domainCount) {
            throw new IllegalArgumentException("invalid function count or domain count " + functionSize + ", " + domainCount);
        }
        PDFObject[] array = obj.getDictRef("Encode").getArray();
        this.encode = new float[array.length];
        for (i = 0; i < array.length; ++i) {
            this.encode[i] = array[i].getFloatValue();
        }
        this.functions = new PDFFunction[functionSize];
        for (i = 0; i < functionSize; ++i) {
            this.functions[i] = FunctionType3.getFunction(functionObjs[i], decryptor, ref != null ? ref : functionObjs[i].getRefValue());
        }
    }

    private int findDomainIndex(float x) {
        if (x >= this.subDomains[0]) {
            for (int i = 1; i < this.subDomains.length; ++i) {
                if (!(x < this.subDomains[i])) continue;
                return i - 1;
            }
            return this.subDomains.length - 2;
        }
        return 0;
    }

    @Override
    void checkOutput(float[] outputs, int outputOffset) {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionType3)) {
            return false;
        }
        FunctionType3 other = (FunctionType3)obj;
        return Arrays.equals(this.subDomains, other.subDomains) && Arrays.equals(this.functions, other.functions);
    }
}

