/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.util;

import com.inet.pdfview.font.util.QuadraticBezierCurve;
import java.util.ArrayList;
import java.util.List;

public class CubicBezierCurve {
    private double[] x = new double[4];
    private double[] y = new double[4];

    public CubicBezierCurve(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        this.x[0] = x0;
        this.x[1] = x1;
        this.x[2] = x2;
        this.x[3] = x3;
        this.y[0] = y0;
        this.y[1] = y1;
        this.y[2] = y2;
        this.y[3] = y3;
    }

    private QuadraticBezierCurve toQuadraticApproximation() {
        return new QuadraticBezierCurve(this.x[0], this.y[0], -0.25 * (this.x[0] + this.x[3]) + 0.75 * (this.x[1] + this.x[2]), -0.25 * (this.y[0] + this.y[3]) + 0.75 * (this.y[1] + this.y[2]), this.x[3], this.y[3]);
    }

    public List<QuadraticBezierCurve> toListOfQuadraticApproximation(double maxError) {
        ArrayList<QuadraticBezierCurve> result = new ArrayList<QuadraticBezierCurve>();
        QuadraticBezierCurve quad = this.toQuadraticApproximation();
        double err = this.computeError(quad);
        if (err <= maxError) {
            result.add(quad);
            return result;
        }
        CubicBezierCurve[] splittedCurves = this.split();
        result.addAll(splittedCurves[0].toListOfQuadraticApproximation(maxError));
        result.addAll(splittedCurves[1].toListOfQuadraticApproximation(maxError));
        return result;
    }

    private CubicBezierCurve[] split() {
        double y13;
        double x13;
        double x10 = this.x[0];
        double x23 = this.x[3];
        double tmp = 0.5 * (this.x[1] + this.x[2]);
        double x11 = 0.5 * (this.x[0] + this.x[1]);
        double x22 = 0.5 * (this.x[2] + this.x[3]);
        double x12 = 0.5 * (x11 + tmp);
        double x21 = 0.5 * (tmp + x22);
        double x20 = x13 = 0.5 * (x12 + x21);
        double y10 = this.y[0];
        double y23 = this.y[3];
        tmp = 0.5 * (this.y[1] + this.y[2]);
        double y11 = 0.5 * (this.y[0] + this.y[1]);
        double y22 = 0.5 * (this.y[2] + this.y[3]);
        double y12 = 0.5 * (y11 + tmp);
        double y21 = 0.5 * (tmp + y22);
        double y20 = y13 = 0.5 * (y12 + y21);
        return new CubicBezierCurve[]{new CubicBezierCurve(x10, y10, x11, y11, x12, y12, x13, y13), new CubicBezierCurve(x20, y20, x21, y21, x22, y22, x23, y23)};
    }

    private double computeError(QuadraticBezierCurve quad) {
        double[] p = this.x;
        double[] q = quad.getX();
        double errX = (28.0 * q[1] * q[1] + (14.0 * p[3] - 42.0 * p[2] - 42.0 * p[1] + 14.0 * p[0]) * q[1] + 2.0 * p[3] * p[3] + (-12.0 * p[2] - 9.0 * p[1] + 3.0 * p[0]) * p[3] + 18.0 * p[2] * p[2] + (27.0 * p[1] - 9.0 * p[0]) * p[2] + 18.0 * p[1] * p[1] - 12.0 * p[0] * p[1] - 28.0 * p[0] * p[0]) / 210.0 + p[0] * p[0] / 7.0;
        p = this.y;
        q = quad.getY();
        double errY = (28.0 * q[1] * q[1] + (14.0 * p[3] - 42.0 * p[2] - 42.0 * p[1] + 14.0 * p[0]) * q[1] + 2.0 * p[3] * p[3] + (-12.0 * p[2] - 9.0 * p[1] + 3.0 * p[0]) * p[3] + 18.0 * p[2] * p[2] + (27.0 * p[1] - 9.0 * p[0]) * p[2] + 18.0 * p[1] * p[1] - 12.0 * p[0] * p[1] - 28.0 * p[0] * p[0]) / 210.0 + p[0] * p[0] / 7.0;
        return Math.sqrt(errX * errX + errY * errY);
    }
}

