/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf.table;

import com.inet.pdfview.PDFParser;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.font.ttf.table.HheaTable;
import com.inet.pdfview.font.ttf.table.MaxpTable;
import com.inet.pdfview.font.ttf.table.TrueTypeTable;
import java.nio.ByteBuffer;

public class HmtxTable
extends TrueTypeTable {
    private short[] advanceWidths;
    private short[] leftSideBearings;
    private int numOfLongHorMetrics;
    private int numGlyphs;
    private HheaTable hhea;

    protected HmtxTable(MaxpTable maxp, HheaTable hhea) {
        super(1752003704);
        this.hhea = hhea;
        this.numGlyphs = maxp.getNumGlyphsUnsigned();
        this.numOfLongHorMetrics = hhea.getNumOfLongHorMetricsUnsigned();
        this.advanceWidths = new short[this.numOfLongHorMetrics];
        this.leftSideBearings = new short[Math.max(this.numOfLongHorMetrics, this.numGlyphs)];
    }

    public HmtxTable(int numGlyphs) {
        super(1752003704);
        this.advanceWidths = new short[numGlyphs];
        this.leftSideBearings = new short[numGlyphs];
        this.numOfLongHorMetrics = numGlyphs;
    }

    public void setLeftSideBearing(int glyphID, short value) {
        this.leftSideBearings[glyphID] = value;
    }

    public void setAdvanceWidth(int glyphID, short value) {
        this.advanceWidths[glyphID] = value;
    }

    public short getAdvance(int glyphID) {
        if (glyphID < this.advanceWidths.length) {
            return this.advanceWidths[glyphID];
        }
        return this.advanceWidths[this.advanceWidths.length - 1];
    }

    public short getLeftSideBearing(int glyphID) {
        if (glyphID < this.leftSideBearings.length) {
            return this.leftSideBearings[glyphID];
        }
        return this.leftSideBearings[this.leftSideBearings.length - 1];
    }

    @Override
    public ByteBuffer toByteBuffer() {
        int size = this.getLength();
        ByteBuffer buf = ByteBuffer.allocate(size);
        for (int i = 0; i < this.leftSideBearings.length; ++i) {
            if (i < this.advanceWidths.length) {
                buf.putShort(this.advanceWidths[i]);
            }
            buf.putShort(this.leftSideBearings[i]);
        }
        buf.flip();
        return buf;
    }

    @Override
    public void setData(IDataBuffer data) {
        int i;
        int maxBearingsCount;
        if (this.numOfLongHorMetrics > this.numGlyphs) {
            PDFParser.LOGGER.warn((Object)"Font may be corrupted: number of horizontal metrics greater than the number of glyphs");
        }
        if ((maxBearingsCount = data.remaining() / 2 - 2 * this.numOfLongHorMetrics) < 0) {
            if (this.numOfLongHorMetrics > this.numGlyphs) {
                this.numOfLongHorMetrics = this.numGlyphs;
                this.hhea.setNumOfLongHorMetrics((short)this.numOfLongHorMetrics);
                this.numOfLongHorMetrics = this.hhea.getNumOfLongHorMetricsUnsigned();
                this.advanceWidths = new short[this.numOfLongHorMetrics];
                this.leftSideBearings = new short[Math.max(this.numOfLongHorMetrics, this.numGlyphs)];
                maxBearingsCount = data.remaining() / 2 - 2 * this.numOfLongHorMetrics;
            }
            if (maxBearingsCount < 0) {
                throw new IllegalStateException("font is corrupted: size of hor metrics greater as size of hmtx table");
            }
        }
        maxBearingsCount = Math.min(maxBearingsCount, this.leftSideBearings.length - this.numOfLongHorMetrics);
        for (i = 0; i < this.numOfLongHorMetrics; ++i) {
            this.advanceWidths[i] = data.getShort();
            this.leftSideBearings[i] = data.getShort();
        }
        for (i = 0; i < maxBearingsCount; ++i) {
            this.leftSideBearings[i + this.numOfLongHorMetrics] = data.getShort();
        }
    }

    @Override
    public int getLength() {
        return this.advanceWidths.length * 2 + this.leftSideBearings.length * 2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numOfLongHorMetrics; ++i) {
            sb.append(i + ": " + this.advanceWidths[i] + " " + this.leftSideBearings[i] + "   ");
        }
        return sb.toString();
    }
}

