/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf.table;

import com.inet.pdfview.PDFParser;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.font.ttf.cmap.CMap;
import com.inet.pdfview.font.ttf.table.TrueTypeTable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CmapTable
extends TrueTypeTable {
    private short version;
    private SortedMap<CmapSubtable, CMap> subtables;

    public CmapTable() {
        super(1668112752);
        this.setVersion((short)0);
        this.subtables = Collections.synchronizedSortedMap(new TreeMap());
    }

    public void addCMap(short platformID, short platformSpecificID, CMap cMap) {
        CmapSubtable key = new CmapSubtable(platformID, platformSpecificID);
        this.subtables.put(key, cMap);
        cMap.setPlatformPrams(platformID, platformSpecificID);
    }

    public CMap getCMap(short platformID, short platformSpecificID) {
        CmapSubtable key = new CmapSubtable(platformID, platformSpecificID);
        return (CMap)this.subtables.get(key);
    }

    public CMap[] getCMaps() {
        Collection<CMap> c = this.subtables.values();
        CMap[] maps = new CMap[c.size()];
        return c.toArray(maps);
    }

    @Override
    public void setData(IDataBuffer data) {
        this.setVersion(data.getShort());
        int numberSubtables = data.getShort();
        for (int i = 0; i < numberSubtables; ++i) {
            short platformID = data.getShort();
            short platformSpecificID = data.getShort();
            int offset = data.getInt();
            if (platformID == 3 && platformSpecificID == 10) {
                PDFParser.LOGGER.warn((Object)"Unicode UCS-4 encoding is not supported");
                continue;
            }
            data.mark();
            data.position(offset);
            IDataBuffer mapData = data.slice();
            data.reset();
            try {
                CMap cMap = CMap.getMap(mapData);
                if (cMap == null) continue;
                this.addCMap(platformID, platformSpecificID, cMap);
                continue;
            }
            catch (Exception ex) {
                PDFParser.LOGGER.debug((Object)("Failed parsing CMap,  PlatformID=" + platformID + ", PlatformSpecificID=" + platformSpecificID));
                PDFParser.LOGGER.debug((Object)("Reason: " + String.valueOf(ex)));
            }
        }
    }

    @Override
    public ByteBuffer toByteBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(this.getLength());
        buf.putShort(this.getVersion());
        buf.putShort((short)this.subtables.size());
        int curOffset = 4 + this.subtables.size() * 8;
        for (CmapSubtable cms : this.subtables.keySet()) {
            CMap map = (CMap)this.subtables.get(cms);
            buf.putShort(cms.platformID);
            buf.putShort(cms.platformSpecificID);
            buf.putInt(curOffset);
            curOffset += map.getLength();
        }
        for (CMap map : this.subtables.values()) {
            buf.put(map.getData());
        }
        buf.flip();
        return buf;
    }

    @Override
    public int getLength() {
        int length = 4;
        length += this.subtables.size() * 8;
        for (CMap map : this.subtables.values()) {
            length += map.getLength();
        }
        return length;
    }

    public short getVersion() {
        return this.version;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public short getNumberSubtables() {
        return (short)this.subtables.size();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String indent = "    ";
        buf.append(indent + "Version: " + this.getVersion() + "\n");
        buf.append(indent + "NumMaps: " + this.getNumberSubtables() + "\n");
        for (Map.Entry<CmapSubtable, CMap> e : this.subtables.entrySet()) {
            CmapSubtable key = e.getKey();
            buf.append(indent + "Map: platformID: " + key.platformID + " PlatformSpecificID: " + key.platformSpecificID + "\n");
            buf.append(e.getValue().toString());
        }
        return buf.toString();
    }

    class CmapSubtable
    implements Comparable<CmapSubtable> {
        private short platformID;
        private short platformSpecificID;

        private CmapSubtable(short platformID, short platformSpecificID) {
            this.platformID = platformID;
            this.platformSpecificID = platformSpecificID;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CmapSubtable)) {
                return false;
            }
            return this.compareTo((CmapSubtable)obj) == 0;
        }

        private int compareToFallBack(CmapSubtable cms) {
            if (this.platformID < cms.platformID) {
                return -1;
            }
            if (this.platformID > cms.platformID) {
                return 1;
            }
            if (this.platformSpecificID < cms.platformSpecificID) {
                return -1;
            }
            if (this.platformSpecificID > cms.platformSpecificID) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compareTo(CmapSubtable cms) {
            if (this.platformID == 3 && this.platformSpecificID == 1) {
                if (cms.platformID != 3 || this.platformSpecificID != 1) {
                    return -1;
                }
                return 0;
            }
            if (cms.platformID == 3 && this.platformSpecificID == 1) {
                return 1;
            }
            if (this.platformID == 1 && this.platformSpecificID == 0) {
                if (cms.platformID != 1 || this.platformSpecificID != 0) {
                    return -1;
                }
                return 0;
            }
            if (cms.platformID == 1 && this.platformSpecificID == 0) {
                return 1;
            }
            return this.compareToFallBack(cms);
        }
    }
}

