/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf.cmap;

import com.inet.pdfview.PDFParser;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.font.ttf.cmap.CMapFormat0;
import com.inet.pdfview.font.ttf.cmap.CMapFormat4;
import com.inet.pdfview.font.ttf.cmap.CMapFormat6;
import java.nio.ByteBuffer;

public abstract class CMap {
    private short format;
    private short language;
    private short platformID;
    private short platformSpecificID;

    protected CMap(short format, short language) {
        this.format = format;
        this.language = language;
    }

    public static CMap createMap(short format, short language) {
        CMap outMap = null;
        switch (format) {
            case 0: {
                outMap = new CMapFormat0(language);
                break;
            }
            case 4: {
                outMap = new CMapFormat4(language);
                break;
            }
            case 6: {
                outMap = new CMapFormat6(language);
                break;
            }
            default: {
                if (PDFParser.LOGGER.isDebug()) {
                    PDFParser.LOGGER.debug((Object)("Unsupported CMap format: " + format));
                }
                return null;
            }
        }
        return outMap;
    }

    public static CMap getMap(IDataBuffer data) {
        short language;
        CMap outMap;
        short format = data.getShort();
        int length = data.getShort() & 0xFFFF;
        if (length <= data.capacity()) {
            data.limit(length);
        }
        if ((outMap = CMap.createMap(format, language = data.getShort())) == null) {
            return null;
        }
        outMap.setData(length, data);
        return outMap;
    }

    public short getFormat() {
        return this.format;
    }

    public short getLanguage() {
        return this.language;
    }

    public abstract void setData(int var1, IDataBuffer var2);

    public abstract ByteBuffer getData();

    public abstract int getLength();

    public abstract byte map(byte var1);

    public abstract char map(char var1);

    public abstract char reverseMap(short var1);

    public abstract int getLastCode();

    public String toString() {
        String indent = "        ";
        return indent + " format: " + this.getFormat() + " length: " + this.getLength() + " language: " + this.getLanguage() + "\n";
    }

    public void setPlatformPrams(short platformID, short platformSpecificID) {
        this.platformID = platformID;
        this.platformSpecificID = platformSpecificID;
    }

    public short getPlatformID() {
        return this.platformID;
    }

    public short getPlatformSpecificID() {
        return this.platformSpecificID;
    }
}

