/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf;

import com.inet.pdfview.PDFFile;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.font.ttf.table.CFFTable;
import com.inet.pdfview.font.ttf.table.CmapTable;
import com.inet.pdfview.font.ttf.table.GlyfTable;
import com.inet.pdfview.font.ttf.table.HeadTable;
import com.inet.pdfview.font.ttf.table.HheaTable;
import com.inet.pdfview.font.ttf.table.HmtxTable;
import com.inet.pdfview.font.ttf.table.LocaTable;
import com.inet.pdfview.font.ttf.table.MaxpTable;
import com.inet.pdfview.font.ttf.table.TrueTypeTable;
import com.inet.pdfview.font.ttf.table.TrueTypeTableChecker;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class TrueTypeFont {
    private static final int TYPE_CFF = 0x4F54544F;
    private static final int TYPE_TRUETYPE = 65536;
    private int type;
    private SortedMap<Integer, Object> tables;
    private boolean hasCFFTable;
    private PDFFile owner;

    public TrueTypeFont(PDFFile owner) {
        this(65536, owner);
    }

    public TrueTypeFont(int type, PDFFile owner) {
        this.type = type;
        this.owner = owner;
        this.tables = Collections.synchronizedSortedMap(new TreeMap());
    }

    public static TrueTypeFont parseFont(byte[] orig, PDFFile owner) {
        IDataBuffer inBuf = ArrayBuffer.wrap(orig);
        return TrueTypeFont.parseFont(inBuf, owner);
    }

    public static TrueTypeFont parseFont(IDataBuffer inBuf, PDFFile owner) {
        int type = inBuf.getInt();
        if (type != 65536 && type != 0x4F54544F & type != 1953658213) {
            PDFParser.LOGGER.warn((Object)("Unknown open type " + type));
            throw new IllegalArgumentException("Could not parse font of unknown type " + type);
        }
        short numTables = inBuf.getShort();
        short searchRange = inBuf.getShort();
        short entrySelector = inBuf.getShort();
        short rangeShift = inBuf.getShort();
        TrueTypeFont font = new TrueTypeFont(type, owner);
        TrueTypeTableChecker checker = new TrueTypeTableChecker();
        TrueTypeFont.parseDirectories(inBuf, numTables, font, checker);
        return font;
    }

    public PDFFile getOwner() {
        return this.owner;
    }

    public int getType() {
        return this.type;
    }

    public boolean isCFF() {
        return this.type == 0x4F54544F && this.hasCFFTable;
    }

    public void addTable(int type, IDataBuffer data) {
        this.tables.put(type, data);
    }

    public void addTable(int type, TrueTypeTable table) {
        this.tables.put(type, table);
    }

    public void addTable(TrueTypeTable table) {
        this.tables.put(table.getTag(), table);
    }

    private TrueTypeTable getTable(int type) {
        Object tableObj = this.tables.get(type);
        TrueTypeTable table = null;
        if (tableObj instanceof IDataBuffer) {
            table = TrueTypeTable.createTable(this, type, (IDataBuffer)tableObj);
            this.addTable(type, table);
        } else {
            table = (TrueTypeTable)tableObj;
        }
        return table;
    }

    public boolean hasTable(int type) {
        return this.tables.get(type) != null;
    }

    public void removeTable(int type) {
        this.tables.remove(type);
    }

    public short getNumTables() {
        return (short)this.tables.size();
    }

    public short getSearchRange() {
        short n = this.getNumTables();
        return (short)((n < 16 ? 8 : (n < 32 ? 16 : (n < 64 ? 32 : 64))) * 16);
    }

    public short getEntrySelector() {
        short n = this.getNumTables();
        return (short)(n < 16 ? 3 : (n < 32 ? 4 : (n < 64 ? 5 : 6)));
    }

    public short getRangeShift() {
        return (short)(16 * this.getNumTables() - this.getSearchRange());
    }

    public byte[] writeFont() {
        ByteBuffer buf = ByteBuffer.allocate(this.getLength());
        buf.putInt(this.getType());
        buf.putShort(this.getNumTables());
        buf.putShort(this.getSearchRange());
        buf.putShort(this.getEntrySelector());
        buf.putShort(this.getRangeShift());
        int curOffset = 12 + this.getNumTables() * 16;
        for (Integer tag : this.tables.keySet()) {
            ByteBuffer data = null;
            Object tableObj = this.tables.get(tag);
            data = tableObj instanceof TrueTypeTable ? ((TrueTypeTable)tableObj).toByteBuffer() : (ByteBuffer)tableObj;
            int dataLen = data.remaining();
            buf.putInt(tag);
            buf.putInt(TrueTypeFont.calculateChecksum(data));
            buf.putInt(curOffset);
            buf.putInt(dataLen);
            buf.mark();
            buf.position(curOffset);
            buf.put(data);
            data.flip();
            buf.reset();
            curOffset += dataLen;
            while (curOffset % 4 > 0) {
                ++curOffset;
            }
        }
        buf.position(curOffset);
        buf.flip();
        this.updateChecksumAdj(buf);
        return buf.array();
    }

    private static int calculateChecksum(ByteBuffer data) {
        int sum = 0;
        data.mark();
        int nlongs = (data.remaining() + 3) / 4;
        while (nlongs-- > 0) {
            if (data.remaining() > 3) {
                sum += data.getInt();
                continue;
            }
            byte b0 = data.remaining() > 0 ? data.get() : (byte)0;
            byte b1 = data.remaining() > 0 ? data.get() : (byte)0;
            byte b2 = data.remaining() > 0 ? data.get() : (byte)0;
            sum += (0xFF & b0) << 24 | (0xFF & b1) << 16 | (0xFF & b2) << 8;
        }
        data.reset();
        return sum;
    }

    private static int calculateChecksum(IDataBuffer data) {
        int sum = 0;
        data.mark();
        int nlongs = (data.remaining() + 3) / 4;
        while (nlongs-- > 0) {
            if (data.remaining() > 3) {
                sum += data.getInt();
                continue;
            }
            byte b0 = data.remaining() > 0 ? data.get() : (byte)0;
            byte b1 = data.remaining() > 0 ? data.get() : (byte)0;
            byte b2 = data.remaining() > 0 ? data.get() : (byte)0;
            sum += (0xFF & b0) << 24 | (0xFF & b1) << 16 | (0xFF & b2) << 8;
        }
        data.reset();
        return sum;
    }

    private static void parseDirectories(IDataBuffer data, int numTables, TrueTypeFont ttf, TrueTypeTableChecker checker) {
        for (int i = 0; i < numTables; ++i) {
            int tag = data.getInt();
            int checksum = data.getInt();
            int offset = data.getInt();
            int length = data.getInt();
            if (length == 0 || !checker.canAddTable(tag)) continue;
            if (tag == 1128678944 && offset != 0 && length > 0) {
                ttf.hasCFFTable = true;
            }
            checker.registerTable(tag);
            data.mark();
            data.position(offset);
            IDataBuffer tableData = data.slice();
            tableData.limit(length);
            int calcChecksum = TrueTypeFont.calculateChecksum(tableData);
            if (calcChecksum == checksum) {
                ttf.addTable(tag, tableData);
            } else {
                ttf.addTable(tag, tableData);
            }
            data.reset();
        }
    }

    private int getLength() {
        int length = 12 + this.getNumTables() * 16;
        for (Object tableObj : this.tables.values()) {
            length = tableObj instanceof TrueTypeTable ? (length += ((TrueTypeTable)tableObj).getLength()) : (length += ((IDataBuffer)tableObj).remaining());
            if (length % 4 == 0) continue;
            length += 4 - length % 4;
        }
        return length;
    }

    private void updateChecksumAdj(ByteBuffer buf) {
        int checksum = TrueTypeFont.calculateChecksum(buf);
        int checksumAdj = -1313820742 - checksum;
        int offset = 12 + this.getNumTables() * 16;
        for (Integer tag : this.tables.keySet()) {
            if (tag == 1751474532) {
                buf.putInt(offset + 8, checksumAdj);
                return;
            }
            Object tableObj = this.tables.get(tag);
            offset = tableObj instanceof TrueTypeTable ? (offset += ((TrueTypeTable)tableObj).getLength()) : (offset += ((IDataBuffer)tableObj).remaining());
            if (offset % 4 == 0) continue;
            offset += 4 - offset % 4;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (PDFParser.LOGGER.isDebug()) {
            PDFParser.LOGGER.debug((Object)("Type         : " + this.getType()));
            PDFParser.LOGGER.debug((Object)("NumTables    : " + this.getNumTables()));
            PDFParser.LOGGER.debug((Object)("SearchRange  : " + this.getSearchRange()));
            PDFParser.LOGGER.debug((Object)("EntrySelector: " + this.getEntrySelector()));
            PDFParser.LOGGER.debug((Object)("RangeShift   : " + this.getRangeShift()));
        }
        for (Map.Entry<Integer, Object> e : this.tables.entrySet()) {
            TrueTypeTable table = null;
            table = e.getValue() instanceof IDataBuffer ? this.getTable(e.getKey()) : (TrueTypeTable)e.getValue();
            if (!PDFParser.LOGGER.isDebug()) continue;
            PDFParser.LOGGER.debug((Object)table);
        }
        return buf.toString();
    }

    public CFFTable getCFFTable() {
        return (CFFTable)this.getTable(1128678944);
    }

    public GlyfTable getGLYFTable() {
        return (GlyfTable)this.getTable(1735162214);
    }

    public HheaTable getHHEATable() {
        return (HheaTable)this.getTable(1751672161);
    }

    public HeadTable getHEADTable() {
        return (HeadTable)this.getTable(1751474532);
    }

    public HmtxTable getHMTXTable() {
        return (HmtxTable)this.getTable(1752003704);
    }

    public CmapTable getCMAPTable() {
        return (CmapTable)this.getTable(1668112752);
    }

    public LocaTable getLOCATable() {
        return (LocaTable)this.getTable(1819239265);
    }

    public MaxpTable getMAXPTable() {
        return (MaxpTable)this.getTable(1835104368);
    }

    public MaxpTable getNAMETable() {
        return (MaxpTable)this.getTable(1851878757);
    }
}

