/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.CharCharMap;
import com.inet.pdfview.font.PDFCMap;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class PDFCIDMap
extends PDFCMap {
    private CharCharMap map;
    private boolean hasTwoByteKeyValue;
    private boolean isEmpty;

    public PDFCIDMap(PDFObject obj, PDFDecrypter decryptor) throws PDFParseException {
        byte[] arr = obj.getStream(obj.getRefValue(), decryptor, false);
        if (arr == null) {
            this.map = new CharCharMap();
        } else {
            Parser parser = new Parser(new String(arr, StandardCharsets.UTF_8));
            this.map = parser.parse();
            this.hasTwoByteKeyValue = parser.hasTwoByteKeyValue;
        }
    }

    public PDFCIDMap(byte[] arr) throws IOException {
        Parser parser = new Parser(new String(arr, "UTF-8"));
        this.map = parser.parse();
        this.hasTwoByteKeyValue = parser.hasTwoByteKeyValue;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public char map(char src) {
        char dst = this.map.get(src);
        return dst == '\uffff' ? (char)'\u0000' : dst;
    }

    public boolean hasTwoByteKeyValue() {
        return this.hasTwoByteKeyValue;
    }

    public int reverseMap(char chr) {
        char[] values = this.map.getValues();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != chr) continue;
            return this.map.getKeys()[i];
        }
        return chr;
    }

    private class Parser {
        private static final String BEGINCIDRANGE = "begincidrange";
        private static final String ENDCIDRANGE = "endcidrange";
        private static final String BEGINCIDCHAR = "begincidchar";
        private static final String ENDCIDCHAR = "endcidchar";
        private String source;
        private int position;
        private int lastHexDigitLength;
        private boolean hasTwoByteKeyValue;

        public Parser(String source) {
            this.source = source;
        }

        private CharCharMap parse() {
            int i;
            int startpos;
            CharCharMap map = new CharCharMap();
            int fromPos = 0;
            while ((startpos = this.source.indexOf(BEGINCIDRANGE, fromPos)) != -1) {
                int numberOfRanges = PDFFontToUnicodeMap.getPreviousNumber(this.source, startpos, BEGINCIDRANGE);
                this.position = startpos + BEGINCIDRANGE.length();
                for (i = 0; i < numberOfRanges; ++i) {
                    int startSrc = this.readInteger();
                    this.hasTwoByteKeyValue = this.hasTwoByteKeyValue || this.lastHexDigitLength == 4;
                    int endSrc = this.readInteger();
                    this.hasTwoByteKeyValue = this.hasTwoByteKeyValue || this.lastHexDigitLength == 4;
                    int startDst = this.readInteger();
                    for (int j = 0; j <= endSrc - startSrc; ++j) {
                        map.put((char)(startSrc + j), (char)(startDst + j));
                    }
                }
                fromPos = this.source.indexOf(ENDCIDRANGE, startpos);
                if (fromPos != -1) continue;
                throw new RuntimeException("invalid map: cannot find 'endcidrange' in " + this.source);
            }
            fromPos = 0;
            int numberOfbfChars = 0;
            while ((startpos = this.source.indexOf(BEGINCIDCHAR, fromPos)) != -1) {
                numberOfbfChars = PDFFontToUnicodeMap.getPreviousNumber(this.source, startpos, BEGINCIDCHAR);
                this.position = startpos + BEGINCIDCHAR.length();
                for (i = 0; i < numberOfbfChars; ++i) {
                    int src = this.readInteger();
                    this.hasTwoByteKeyValue = this.hasTwoByteKeyValue || this.lastHexDigitLength == 4;
                    int dst = this.readInteger();
                    map.put((char)src, (char)dst);
                }
                fromPos = this.source.indexOf(ENDCIDCHAR, startpos);
                if (fromPos != -1) continue;
                throw new RuntimeException("invalid map: cannot find 'endcidchar' in " + this.source);
            }
            PDFCIDMap.this.isEmpty = map.isEmpty();
            return map;
        }

        private int readInteger() {
            char ch;
            this.lastHexDigitLength = 0;
            while (Character.isWhitespace(ch = this.source.charAt(this.position++))) {
            }
            StringBuilder strBuilder = new StringBuilder();
            if (ch == '<') {
                while (this.position < this.source.length() && ((ch = this.source.charAt(this.position++)) >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F' || ch == ' ')) {
                    strBuilder.append(ch);
                }
                if (ch == '>') {
                    String digits = strBuilder.toString();
                    this.lastHexDigitLength = digits.length();
                    return Integer.parseInt(digits, 16);
                }
                throw new IllegalStateException("hex value is not defined");
            }
            if (Character.isDigit(ch)) {
                strBuilder.append(ch);
                while (this.position < this.source.length() && Character.isDigit(ch = this.source.charAt(this.position++))) {
                    strBuilder.append(ch);
                }
                return Integer.parseInt(strBuilder.toString());
            }
            throw new IllegalStateException("Invalid token " + ch + " at position " + this.position);
        }
    }
}

