/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.error.PDFParseException;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class CIDFontWidthDelegate {
    private Map<Character, Float> widths;
    private Map<Character, VerticalMetrics> verticals;
    public static final int DEFAULT_WIDTH = 1000;
    private int defaultWidth = 1000;

    public CIDFontWidthDelegate(PDFObject fontObj) throws PDFParseException {
        this.parseWidths(fontObj);
    }

    private void parseWidths(PDFObject fontObj) throws PDFParseException {
        int c;
        int i;
        int last;
        int first;
        int entryIdx;
        PDFObject[] widthArray;
        PDFObject widthObj;
        PDFObject defaultWidthObj = fontObj.getDictRef("DW");
        if (defaultWidthObj != null) {
            this.defaultWidth = defaultWidthObj.getIntValue();
        }
        if ((widthObj = fontObj.getDictRef("W")) != null) {
            this.widths = new HashMap<Character, Float>();
            widthArray = widthObj.getArray();
            entryIdx = 0;
            first = 0;
            last = 0;
            for (i = 0; i < widthArray.length; ++i) {
                if (entryIdx == 0) {
                    first = widthArray[i].getIntValue();
                } else if (entryIdx == 1) {
                    if (widthArray[i].getType() == 5) {
                        PDFObject[] entries = widthArray[i].getArray();
                        for (c = 0; c < entries.length; ++c) {
                            Character key = new Character((char)(c + first));
                            float value = entries[c].getIntValue();
                            this.widths.put(key, new Float(value));
                        }
                        entryIdx = -1;
                    } else {
                        last = widthArray[i].getIntValue();
                    }
                } else {
                    int value = widthArray[i].getIntValue();
                    for (c = first; c <= last; ++c) {
                        this.widths.put(new Character((char)c), new Float(value));
                    }
                    entryIdx = -1;
                }
                ++entryIdx;
            }
        }
        if ((widthObj = fontObj.getDictRef("W2")) != null) {
            this.verticals = new HashMap<Character, VerticalMetrics>();
            widthArray = widthObj.getArray();
            entryIdx = 0;
            first = 0;
            last = 0;
            for (i = 0; i < widthArray.length; ++i) {
                if (entryIdx == 0) {
                    first = widthArray[i].getIntValue();
                } else if (entryIdx == 1) {
                    if (widthArray[i].getType() == 5) {
                        PDFObject[] entries = widthArray[i].getArray();
                        for (c = 0; c < entries.length; ++c) {
                            Character key = new Character((char)(c + first));
                            int valueY = entries[c].getIntValue();
                            int valueX2 = entries[++c].getIntValue();
                            int valueY2 = entries[++c].getIntValue();
                            VerticalMetrics metrics = new VerticalMetrics(valueY, new Point2D.Double(valueX2, valueY2));
                            this.verticals.put(key, metrics);
                        }
                        entryIdx = -1;
                    } else {
                        last = widthArray[i].getIntValue();
                    }
                } else {
                    int valueY = widthArray[i].getIntValue();
                    int valueX2 = widthArray[++i].getIntValue();
                    int valueY2 = widthArray[++i].getIntValue();
                    VerticalMetrics metrics = new VerticalMetrics(valueY, new Point2D.Double(valueX2, valueY2));
                    for (int c2 = first; c2 <= last; ++c2) {
                        this.verticals.put(new Character((char)c2), metrics);
                    }
                    entryIdx = -1;
                }
                ++entryIdx;
            }
            if (this.widths != null) {
                PDFParser.LOGGER.debug((Object)"Vertical and horizontal text direction defined. Currently not implemented yet");
            } else {
                this.widths = new HashMap<Character, Float>();
                for (Character character : this.verticals.keySet()) {
                    this.widths.put(character, Float.valueOf((float)this.verticals.get(character).getDistance()));
                }
            }
        }
    }

    public int getDefaultWidth() {
        if (this.defaultWidth == 0) {
            this.defaultWidth = 1000;
        }
        return this.defaultWidth;
    }

    public float getWidth(char code, String name) {
        if (this.widths != null) {
            Float w = this.widths.get(new Character(code));
            if (w == null) {
                return (float)this.getDefaultWidth() / 1000.0f;
            }
            return w.floatValue() / 1000.0f;
        }
        return (float)this.defaultWidth / 1000.0f;
    }

    public boolean contains(char code) {
        return this.widths != null && this.widths.containsKey(Character.valueOf(code));
    }

    private class VerticalMetrics {
        private final Point2D startCharacterPosition;
        private final Point2D nextCharacterPosition;

        public Point2D getStartCharacterPosition() {
            return this.startCharacterPosition;
        }

        public Point2D getNextCharacterPosition() {
            return this.nextCharacterPosition;
        }

        public double getDistance() {
            return Math.hypot(Math.abs(this.getNextCharacterPosition().getY() - this.getStartCharacterPosition().getY()), Math.abs(this.getNextCharacterPosition().getX() - this.getStartCharacterPosition().getX()));
        }

        private VerticalMetrics(int height, Point2D position) {
            this.startCharacterPosition = new Point2D.Double(0.0, height);
            this.nextCharacterPosition = position;
        }
    }
}

