/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.font.FontPool;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontEncoding;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.Type1Font;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuiltinFont
extends Type1Font {
    private static Properties props;
    private static final Pattern ENCODED_PATTERN;
    private static final String FAMILY_COURIER = "Courier";
    private static final String FAMILY_TIMES = "Times New Roman";
    private static final String FAMILY_HELVETICA = "Helvetica";
    private static final String FAMILY_SYMBOL = "Symbol";
    private static final String FAMILY_ZAPF = "ZapfDingbats";
    private static final FontDescription FONT_COURIER;
    private static final FontDescription FONT_COURIER_B;
    private static final FontDescription FONT_COURIER_BO;
    private static final FontDescription FONT_COURIER_O;
    private static final FontDescription FONT_HELVETICA;
    private static final FontDescription FONT_HELVETICA_B;
    private static final FontDescription FONT_HELVETICA_BO;
    private static final FontDescription FONT_HELVETICA_O;
    private static final FontDescription FONT_TIMES;
    private static final FontDescription FONT_TIMES_B;
    private static final FontDescription FONT_TIMES_BO;
    private static final FontDescription FONT_TIMES_O;
    private static final FontDescription FONT_SYMBOL;
    private static final FontDescription FONT_ZAPF;
    private static final Pattern FAMILY_PATTERN;
    private static final Map<String, FontDescription> FONT_MAP;
    private Font systemAwtFont = null;
    private boolean hasWidthArray = true;
    private String actualFontName;

    @Override
    public Font getAWTFont() {
        return this.systemAwtFont != null ? this.systemAwtFont : super.getAWTFont();
    }

    public static boolean isDefaultFont(String baseName) {
        baseName = baseName.toLowerCase();
        for (FontDescription fontDescription : FONT_MAP.values()) {
            for (String synonym : fontDescription.synonyms) {
                if (!baseName.contains(synonym.toLowerCase())) continue;
                return true;
            }
            if (!baseName.contains(fontDescription.fontName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static String resolveDefaultFontFamilyName(String familyName) {
        if (familyName == null) {
            return null;
        }
        FontDescription descriptor = FONT_MAP.get(familyName.toLowerCase());
        return descriptor != null ? descriptor.fontFamilyName : familyName;
    }

    public BuiltinFont(String baseFont, PDFObject fontObj) throws PDFParseException {
        super(baseFont, fontObj, null, null, null, null);
        this.parseFont(baseFont);
    }

    public BuiltinFont(String baseFont, PDFObject fontObj, PDFFontDescriptor descriptor, PDFFontToUnicodeMap toUnicode, String encodingType, boolean hasWidthsArr) throws PDFParseException {
        super(baseFont, fontObj, descriptor, encodingType, toUnicode, null);
        String fontName = descriptor.getFontName();
        fontName = fontName.replace("#20", "").replace("#2D", "-").toLowerCase();
        FontDescription desc = FONT_MAP.get(fontName);
        this.hasWidthArray = hasWidthsArr;
        if (desc == null) {
            int style;
            int flags = descriptor.getFlags();
            int n = style = (flags & 0x40000) != 0 ? 1 : 0;
            if (fontName.indexOf("bold") > 0) {
                style |= 1;
            }
            if (descriptor.getItalicAngle() != 0 || (flags & 0x40) != 0) {
                style |= 2;
            }
            this.systemAwtFont = FontPool.getFont((String)this.getCleanFontName(descriptor.getFontName()), (int)style, (int)1);
            if (this.systemAwtFont.getFamily().equals("Dialog")) {
                this.systemAwtFont = null;
            }
            desc = (flags & 1) != 0 ? ((style & 1) > 0 && (style & 2) > 0 ? FONT_COURIER_BO : ((style & 1) > 0 ? FONT_COURIER_B : ((style & 2) > 0 ? FONT_COURIER_O : FONT_COURIER))) : ((flags & 2) != 0 ? ((style & 1) > 0 && (style & 2) > 0 ? FONT_TIMES_BO : ((style & 1) > 0 ? FONT_TIMES_B : ((style & 2) > 0 ? FONT_TIMES_O : FONT_TIMES))) : ((style & 1) > 0 && (style & 2) > 0 ? FONT_HELVETICA_BO : ((style & 1) > 0 ? FONT_HELVETICA_B : ((style & 2) > 0 ? FONT_HELVETICA_O : FONT_HELVETICA))));
        }
        this.parseFont(desc.fontName);
        if (desc.fontFamilyName == FAMILY_HELVETICA) {
            String name = descriptor.getFontName();
            Matcher m = FAMILY_PATTERN.matcher(name);
            if (m.matches()) {
                name = m.group(1);
            }
            descriptor.setFontFamilyName(name);
        } else {
            descriptor.setFontFamilyName(desc.fontFamilyName);
        }
    }

    private String getCleanFontName(String fontName) {
        int italicIndex;
        int boldIndex = ((String)(fontName = this.normalizeName((String)fontName))).toLowerCase().indexOf("bold");
        if (boldIndex != -1) {
            fontName = ((String)fontName).substring(0, boldIndex) + ((String)fontName).substring(boldIndex + "bold".length());
        }
        if (((String)fontName).toLowerCase().endsWith("roman") && !((String)fontName).toLowerCase().contains("times")) {
            fontName = ((String)fontName).substring(0, ((String)fontName).length() - "roman".length()).trim();
        }
        if (((String)fontName).toLowerCase().endsWith("regular")) {
            fontName = ((String)fontName).substring(0, ((String)fontName).length() - "regular".length()).trim();
        }
        if ((italicIndex = ((String)fontName).toLowerCase().indexOf("italic")) != -1) {
            fontName = (((String)fontName).substring(0, italicIndex) + ((String)fontName).substring(italicIndex + "italic".length())).trim();
        } else {
            int obliqueIndex = ((String)fontName).toLowerCase().indexOf("oblique");
            if (obliqueIndex != -1) {
                fontName = (((String)fontName).substring(0, obliqueIndex) + ((String)fontName).substring(obliqueIndex + "oblique".length())).trim();
            }
        }
        while (((String)fontName).matches(".*(MT|PS)$")) {
            fontName = ((String)fontName).substring(0, ((String)fontName).length() - 2).trim();
        }
        fontName = ((String)fontName).replaceAll("([a-z])([A-Z])(?=[a-z])", "$1 $2").trim();
        return fontName;
    }

    private String normalizeName(String fontName) {
        int indexOfPlus;
        Matcher m = ENCODED_PATTERN.matcher(fontName);
        StringBuffer b = null;
        while (m.find()) {
            if (b == null) {
                b = new StringBuffer(fontName.length() - 2);
            }
            m.appendReplacement(b, new String(new byte[]{(byte)Integer.parseInt(m.group(1), 16)}));
        }
        if (b != null) {
            m.appendTail(b);
            fontName = b.toString();
        }
        if ((indexOfPlus = fontName.indexOf(43)) != -1) {
            int lastIndexOfPlus = fontName.lastIndexOf(43);
            if (lastIndexOfPlus != indexOfPlus) {
                fontName = fontName.substring(0, lastIndexOfPlus);
            }
            fontName = indexOfPlus < fontName.length() - 1 ? fontName.substring(indexOfPlus + 1) : fontName.substring(0, indexOfPlus);
        }
        if (fontName.startsWith(FAMILY_COURIER)) {
            fontName = fontName.replaceFirst("Courier\\w+", FAMILY_COURIER);
        }
        if (fontName.indexOf(45) != -1) {
            fontName = fontName.replace('-', ' ');
        }
        if (fontName.indexOf(44) != -1) {
            fontName = fontName.replace(',', ' ');
        }
        return fontName.trim();
    }

    public String getActualFontName() {
        return this.actualFontName;
    }

    private void parseFont(String baseFont) throws PDFParseException {
        try {
            if (props == null) {
                props = new Properties();
                props.load(BuiltinFont.class.getResourceAsStream("res/BaseFonts.properties"));
            }
            if (!props.containsKey(baseFont + ".file")) {
                throw new IllegalArgumentException("Unknown Base Font: " + baseFont);
            }
            this.actualFontName = baseFont;
            String file = props.getProperty(baseFont + ".file");
            int length = Integer.parseInt(props.getProperty(baseFont + ".length"));
            int length1 = 0;
            int length2 = 0;
            byte[] data = new byte[length];
            InputStream fontStream = this.getClass().getResourceAsStream("res/" + file);
            for (int cur = 0; cur < length; cur += fontStream.read(data, cur, length - cur)) {
            }
            fontStream.close();
            if ((data[0] & 0xFF) == 128) {
                length1 = data[2] & 0xFF;
                length1 |= (data[3] & 0xFF) << 8;
                length1 |= (data[4] & 0xFF) << 16;
                length1 |= (data[5] & 0xFF) << 24;
                length2 = data[(length1 += 6) + 2] & 0xFF;
                length2 |= (data[length1 + 3] & 0xFF) << 8;
                length2 |= (data[length1 + 4] & 0xFF) << 16;
                length2 |= (data[length1 + 5] & 0xFF) << 24;
                length1 += 6;
            } else {
                length1 = Integer.parseInt(props.getProperty(baseFont + ".length1"));
                length2 = props.containsKey(baseFont + ".length2") ? Integer.parseInt(props.getProperty(baseFont + ".lenth2")) : length - length1;
            }
            this.parseFont(data, length1, length2);
            if (this.getDescriptor() != null) {
                this.getDescriptor().setFontFamilyName(baseFont);
            }
        }
        catch (IOException ex) {
            throw PDFParseException.create(ex);
        }
    }

    private static void addFont(FontDescription font) {
        FONT_MAP.put(font.fontName.toLowerCase(), font);
        if (font.synonyms != null) {
            for (String synonym : font.synonyms) {
                FONT_MAP.put(synonym.toLowerCase(), font);
            }
        }
    }

    @Override
    public PDFFontEncoding getEncoding() {
        PDFFontEncoding encoding = super.getEncoding();
        if (encoding == null) {
            encoding = new PDFFontEncoding(PDFFont.Subtype.Type1);
        }
        return encoding;
    }

    @Override
    boolean widthArrayDefined() {
        return this.hasWidthArray;
    }

    static {
        ENCODED_PATTERN = Pattern.compile("#([0-9A-F]{2})");
        FONT_COURIER = new FontDescription(FAMILY_COURIER, FAMILY_COURIER, new String[0]);
        FONT_COURIER_B = new FontDescription("Courier-Bold", FAMILY_COURIER, new String[0]);
        FONT_COURIER_BO = new FontDescription("Courier-BoldOblique", FAMILY_COURIER, new String[0]);
        FONT_COURIER_O = new FontDescription("Courier-Oblique", FAMILY_COURIER, new String[0]);
        FONT_HELVETICA = new FontDescription(FAMILY_HELVETICA, FAMILY_HELVETICA, "Arial", "Verdana");
        FONT_HELVETICA_B = new FontDescription("Helvetica-Bold", FAMILY_HELVETICA, "Arial,Bold", "Verdana,Bold");
        FONT_HELVETICA_BO = new FontDescription("Helvetica-BoldOblique", FAMILY_HELVETICA, "Arial,BoldItalic", "Verdana,BoldItalic");
        FONT_HELVETICA_O = new FontDescription("Helvetica-Oblique", FAMILY_HELVETICA, "Arial,Italic", "Verdana,Italic");
        FONT_TIMES = new FontDescription("Times-Roman", FAMILY_TIMES, "TimesNewRoman", "TimesNewRomanPS", "TimesNewRomanPSMT");
        FONT_TIMES_B = new FontDescription("Times-Bold", FAMILY_TIMES, "TimesNewRoman,Bold", "TimesNewRomanPS-BoldMT");
        FONT_TIMES_BO = new FontDescription("Times-BoldItalic", FAMILY_TIMES, "TimesNewRoman,BoldItalic", "TimesNewRomanPS-BoldItalicMT");
        FONT_TIMES_O = new FontDescription("Times-Italic", FAMILY_TIMES, "TimesNewRoman,Italic", "TimesNewRomanPS-ItalicMT");
        FONT_SYMBOL = new FontDescription(FAMILY_SYMBOL, FAMILY_SYMBOL, "SymbolMT");
        FONT_ZAPF = new FontDescription(FAMILY_ZAPF, FAMILY_ZAPF, new String[0]);
        FAMILY_PATTERN = Pattern.compile("^(.+?)([-, ]|PS|MT)");
        FONT_MAP = new HashMap<String, FontDescription>();
        BuiltinFont.addFont(FONT_COURIER);
        BuiltinFont.addFont(FONT_COURIER_B);
        BuiltinFont.addFont(FONT_COURIER_BO);
        BuiltinFont.addFont(FONT_COURIER_O);
        BuiltinFont.addFont(FONT_HELVETICA);
        BuiltinFont.addFont(FONT_HELVETICA_B);
        BuiltinFont.addFont(FONT_HELVETICA_BO);
        BuiltinFont.addFont(FONT_HELVETICA_O);
        BuiltinFont.addFont(FONT_TIMES);
        BuiltinFont.addFont(FONT_TIMES_B);
        BuiltinFont.addFont(FONT_TIMES_BO);
        BuiltinFont.addFont(FONT_TIMES_O);
        BuiltinFont.addFont(FONT_SYMBOL);
        BuiltinFont.addFont(FONT_ZAPF);
    }

    private static class FontDescription {
        private String fontName;
        private String fontFamilyName;
        private String[] synonyms;

        public FontDescription(String fontName, String fontFamilyName, String ... synonyms) {
            this.fontName = fontName;
            this.fontFamilyName = fontFamilyName;
            this.synonyms = synonyms;
        }
    }
}

