/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode.jpeg;

import com.inet.pdfview.PDFParser;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.jpeg.JpegAdobeSegment;
import com.inet.pdfview.decode.jpeg.JpegSegment;
import com.inet.pdfview.decode.jpeg.JpegStartOfFrameSegment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JpegSegmentReader {
    public static final boolean DEBUG = false;
    int HAS_PAYLOAD = 1;
    int HAS_NO_PAYLOAD = 0;
    int UNKNOWN = -1;
    private boolean dataStartAchived;
    private IDataBuffer data;

    JpegSegmentReader(IDataBuffer data) {
        this.data = data;
    }

    public Map<Byte, List<JpegSegment>> readSegments() {
        HashMap<Byte, List<JpegSegment>> map = new HashMap<Byte, List<JpegSegment>>();
        boolean potentialSegmentFound = false;
        int nextSegmentPos = 0;
        boolean checkNextPos = true;
        while (this.data.hasRemaining() && !this.dataStartAchived) {
            byte b = this.data.get();
            if (b == -1) {
                potentialSegmentFound = this.data.position() >= nextSegmentPos;
                continue;
            }
            if (!potentialSegmentFound) continue;
            if (b == 0) {
                potentialSegmentFound = false;
            } else {
                int currentSegmentLength;
                if (checkNextPos && nextSegmentPos != 0) {
                    if (this.data.position() != nextSegmentPos + 2) {
                        checkNextPos = false;
                        potentialSegmentFound = false;
                    } else {
                        checkNextPos = true;
                    }
                }
                int currentSegmentPos = this.data.position() - 2;
                if (this.hasPayload(b) == this.HAS_PAYLOAD) {
                    currentSegmentLength = this.readUShort();
                    int hold = this.data.position();
                    if (this.readSegment(b, currentSegmentPos, currentSegmentLength, map) && this.data.position() != currentSegmentPos + currentSegmentLength) {
                        this.data.position(hold);
                    }
                } else if (this.hasPayload(b) == this.HAS_NO_PAYLOAD) {
                    currentSegmentLength = 0;
                } else {
                    currentSegmentLength = 0;
                    checkNextPos = false;
                }
                nextSegmentPos = currentSegmentPos + currentSegmentLength + 2;
            }
            potentialSegmentFound = false;
        }
        return map;
    }

    private boolean readSegment(byte marker, int position, int length, Map<Byte, List<JpegSegment>> map) {
        switch (marker) {
            case -38: {
                this.dataStartAchived = true;
                return true;
            }
            case -64: 
            case -63: {
                List<JpegSegment> list = this.checkList(marker, map);
                byte imageDataPrecision = this.data.get();
                int imageHeight = this.readUShort();
                int imageWidth = this.readUShort();
                int numberOfComponents = this.data.get();
                int[] compIds = new int[numberOfComponents];
                for (int i = 0; i < numberOfComponents; ++i) {
                    compIds[i] = this.data.get();
                }
                this.dataStartAchived = true;
                JpegStartOfFrameSegment segm = new JpegStartOfFrameSegment(position, length, compIds);
                list.add(segm);
                return true;
            }
            case -18: {
                if (length < 14) {
                    PDFParser.LOGGER.error((Object)"Adobe specific code length must be 14");
                    return false;
                }
                for (int i = 0; i < JpegAdobeSegment.ADOBE_SEGMENT_DEFINITION.length; ++i) {
                    if (this.data.get() == JpegAdobeSegment.ADOBE_SEGMENT_DEFINITION[i]) continue;
                    return false;
                }
                if (this.data.get() != 0) {
                    return false;
                }
                int version = this.data.get() & 0xFF;
                int flags0 = this.readUShort();
                int flags1 = this.readUShort();
                byte colorTransform = this.data.get();
                List<JpegSegment> adobeList = this.checkList(marker, map);
                adobeList.add(new JpegAdobeSegment(position, length, colorTransform));
                return true;
            }
        }
        return false;
    }

    int hasPayload(byte marker) {
        switch (marker) {
            case -40: 
            case -39: {
                return this.HAS_NO_PAYLOAD;
            }
            case -64: 
            case -63: 
            case -62: {
                break;
            }
            case -60: {
                break;
            }
            case -37: {
                break;
            }
            case -35: {
                break;
            }
            case -38: {
                break;
            }
            case -48: 
            case -47: 
            case -46: 
            case -45: 
            case -44: 
            case -43: 
            case -42: 
            case -41: {
                return this.HAS_PAYLOAD;
            }
            case -32: 
            case -31: 
            case -30: 
            case -29: 
            case -28: 
            case -27: 
            case -26: 
            case -25: 
            case -24: 
            case -23: 
            case -22: 
            case -21: 
            case -20: 
            case -19: 
            case -18: 
            case -17: {
                break;
            }
            case -2: {
                break;
            }
            default: {
                return this.UNKNOWN;
            }
        }
        return this.HAS_PAYLOAD;
    }

    int readUShort() {
        int highByte = this.data.get() & 0xFF;
        int lowByte = this.data.get() & 0xFF;
        int length = highByte << 8 | lowByte;
        return length;
    }

    private List<JpegSegment> checkList(byte marker, Map<Byte, List<JpegSegment>> map) {
        List<JpegSegment> list = map.get(marker);
        if (list == null) {
            list = new ArrayList<JpegSegment>();
            map.put(marker, list);
        }
        return list;
    }

    String getName(byte marker) {
        String name = null;
        switch (marker) {
            case 0: {
                name = "Skip";
                break;
            }
            case -40: {
                name = "Start Of Image(SOI):Baseline DCT";
                break;
            }
            case -64: {
                name = "Start Of Frame(SOF0):Baseline DCT";
                break;
            }
            case -63: {
                name = "Start Of Frame(SOF1)?";
                break;
            }
            case -62: {
                name = "Start Of Frame(SOF2):Progressive DCT";
                break;
            }
            case -52: {
                name = "Define Arithmetic Table";
                break;
            }
            case -60: {
                name = "Define Huffman Table(s)";
                break;
            }
            case -37: {
                name = "Define Quantization Table(s)";
                break;
            }
            case -35: {
                name = "Define Restart Interval";
                break;
            }
            case -38: {
                name = "Start Of Scan(SOS)";
                break;
            }
            case -48: {
                name = "Restart(0)";
                break;
            }
            case -47: {
                name = "Restart(1)";
                break;
            }
            case -46: {
                name = "Restart(2)";
                break;
            }
            case -45: {
                name = "Restart(3)";
                break;
            }
            case -44: {
                name = "Restart(4)";
                break;
            }
            case -43: {
                name = "Restart(5)";
                break;
            }
            case -42: {
                name = "Restart(6)";
                break;
            }
            case -41: {
                name = "Restart(7)";
                break;
            }
            case -32: {
                name = "Application-specific(APP0)";
                break;
            }
            case -31: {
                name = "Application-specific(APP1)";
                break;
            }
            case -30: {
                name = "Application-specific(APP2)";
                break;
            }
            case -29: {
                name = "Application-specific(APP3)";
                break;
            }
            case -28: {
                name = "Application-specific(APP4)";
                break;
            }
            case -27: {
                name = "Application-specific(APP5)";
                break;
            }
            case -26: {
                name = "Application-specific(APP6)";
                break;
            }
            case -25: {
                name = "Application-specific(APP7)";
                break;
            }
            case -24: {
                name = "Application-specific(APP8)";
                break;
            }
            case -23: {
                name = "Application-specific(APP9)";
                break;
            }
            case -22: {
                name = "Application-specific(APPa)";
                break;
            }
            case -21: {
                name = "Application-specific(APPb)";
                break;
            }
            case -20: {
                name = "Application-specific(APPc)";
                break;
            }
            case -19: {
                name = "Application-specific(APPd)";
                break;
            }
            case -18: {
                name = "Adobe-specific(APPe)";
                break;
            }
            case -17: {
                name = "Application-specific(APPf)";
                break;
            }
            case -2: {
                name = "Comment";
                break;
            }
            case -39: {
                name = "End Of Image(EOI)";
                break;
            }
            default: {
                return null;
            }
        }
        return name;
    }
}

