/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.control;

import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.control.Appearance;
import com.inet.pdfview.control.AppearanceState;
import com.inet.pdfview.error.PDFParseException;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class ControlData {
    public static final String TXT = "Tx";
    public static final String CHOICE = "Ch";
    public static final String BUTTON = "Btn";
    public static final String SIGNATURE = "Sig";
    private static final Pattern OFF = Pattern.compile("off|no", 2);
    private static final String AP = "AP";
    private static final String AS = "AS";
    private static final char N = 'N';
    private static final char D = 'D';
    private static final char R = 'R';
    private static final int APPERANCE_N_INDEX = 0;
    private static final int APPERANCE_D_INDEX = 1;
    private static final int APPERANCE_R_INDEX = 2;
    private PDFPage daCmds = null;
    private PDFObject annot;
    private String fieldName;
    private String fieldValue;
    private int pageNumber;
    private Rectangle2D bounds;
    private PDFObject resourceDict;
    private Appearance[] appearences = new Appearance[3];
    private int flags;
    private String fieldType;
    private CacheAccess fontGenerationListener;

    public ControlData(PDFObject annot, String fieldType, String fieldName, String fieldValue, int pageNumber, Rectangle2D bounds, int flags, PDFObject resourceDict, CacheAccess fontGenerationListener) {
        this.annot = annot;
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.pageNumber = pageNumber;
        this.bounds = bounds;
        this.flags = flags;
        this.fieldType = fieldType;
        this.resourceDict = resourceDict;
        this.fontGenerationListener = fontGenerationListener;
        this.appearences = ControlData.readAppearences(annot, fieldValue);
    }

    public static ControlData getControl(String fieldType, PDFObject annot, PDFObject parent, PDFObject resourceDict, CacheAccess fontGenerationListener) {
        int pageNumber = 0;
        Rectangle2D bounds = ControlData.readAnnotRect(annot);
        String fieldName = ControlData.readFieldName(annot, parent);
        String fieldValue = ControlData.readFieldValue(annot, parent);
        int flags = 0;
        try {
            PDFObject ffObject = annot.getDictRef("Ff");
            if (ffObject == null && parent != null) {
                ffObject = parent.getDictRef("Ff");
            }
            if (ffObject != null && ffObject.getType() == 2) {
                flags = ffObject.getIntValue();
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        return new ControlData(annot, fieldType, fieldName, fieldValue, pageNumber, bounds, flags, resourceDict, fontGenerationListener);
    }

    public PDFObject getAnnot() {
        return this.annot;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public PDFObject getResourceDict() {
        return this.resourceDict;
    }

    public int getFlags() {
        return this.flags;
    }

    public CBSTATE getState() {
        String currentStateName = ControlData.readAppearenceStateName(this.annot);
        if (currentStateName != null && currentStateName.length() != 0) {
            if (OFF.matcher(currentStateName).matches()) {
                return CBSTATE.off;
            }
            if (this.isOnStateNameSet(this.appearences, currentStateName)) {
                return CBSTATE.on;
            }
        }
        return CBSTATE.undefined;
    }

    private boolean isOnStateNameSet(Appearance[] appearances, String currentStateName) {
        if (appearances != null && appearances.length != 0 && currentStateName != null) {
            for (AppearanceState state : appearances[0].getStates()) {
                String name = state.getStateSelector().getStateName();
                if (!currentStateName.equals(name) || OFF.matcher(name).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private static Appearance[] readAppearences(PDFObject annot, String fieldValue) {
        Appearance[] appearences = new Appearance[3];
        try {
            PDFObject apObject = annot.getDictRef(AP);
            if (apObject != null) {
                Iterator<String> iter = apObject.getDictKeys();
                while (iter.hasNext()) {
                    String keyObj = iter.next();
                    if (keyObj == null || keyObj.length() != 1) {
                        PDFParser.LOGGER.error((Object)("invalid appearence state: " + keyObj));
                        return appearences;
                    }
                    char appearanceType = keyObj.charAt(0);
                    int index = -1;
                    switch (appearanceType) {
                        case 'N': {
                            index = 0;
                            break;
                        }
                        case 'D': {
                            index = 1;
                            break;
                        }
                        case 'R': {
                            index = 2;
                            break;
                        }
                    }
                    if (index == -1) continue;
                    PDFObject apRefObj = apObject.getDictRef(keyObj);
                    if (apRefObj != null) {
                        appearences[index] = new Appearance(appearanceType, apRefObj);
                        continue;
                    }
                    if (fieldValue == null) continue;
                    appearences[0] = null;
                }
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        return appearences;
    }

    public PDFObject getFormObject() {
        AppearanceState state;
        PDFObject formObject = null;
        Appearance currentAppearance = this.appearences[0];
        if (currentAppearance != null && (state = currentAppearance.getState(ControlData.readAppearenceStateName(this.annot))) != null) {
            return state.getFormObj();
        }
        return formObject;
    }

    private static String readAppearenceStateName(PDFObject annot) {
        try {
            PDFObject asObject = annot.getDictRef(AS);
            if (asObject != null) {
                return asObject.getStringValue();
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        return null;
    }

    public PDFPage getDefaultTextStyleCmds() {
        if (this.daCmds != null) {
            return this.daCmds;
        }
        PDFObject annot = this.getAnnot();
        try {
            PDFObject daObject = annot.getDictRef("DA");
            if (daObject != null && daObject.getType() == 3) {
                String val = daObject.getStringValue();
                this.daCmds = new PDFPage(null, 0);
                Map<String, PDFObject> resourceMap = null;
                if (this.resourceDict != null) {
                    resourceMap = this.resourceDict.getDictionary();
                } else {
                    PDFObject drObject = annot.getDictRef("DR");
                    if (drObject != null && drObject.getType() == 6) {
                        resourceMap = drObject.getDictionary();
                    }
                }
                PDFParser daParser = new PDFParser(this.daCmds, val.getBytes(), resourceMap, this.fontGenerationListener, annot.getOwner());
                daParser.go(true);
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        return this.daCmds;
    }

    private static Rectangle2D readAnnotRect(PDFObject annot) {
        try {
            PDFObject rectObj = annot.getDictRef("Rect");
            if (rectObj != null && rectObj.getType() == 5) {
                PDFObject[] controlRectObjs = rectObj.getArray();
                return ControlData.getAnnotRect(controlRectObjs);
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        return null;
    }

    private static String readFieldName(PDFObject annot, PDFObject parent) {
        try {
            PDFObject tObject = annot.getDictRef("T");
            if (tObject == null && parent != null) {
                tObject = parent.getDictRef("T");
            }
            if (tObject != null && tObject.getType() == 3) {
                return tObject.getStringValue();
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        return null;
    }

    private static String readFieldValue(PDFObject annot, PDFObject parent) {
        try {
            PDFObject vObject = annot.getDictRef("V");
            if (vObject == null && parent != null) {
                vObject = parent.getDictRef("V");
            }
            if (vObject != null && (vObject.getType() == 4 || vObject.getType() == 3)) {
                return vObject.getStringValue();
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        return null;
    }

    private static Rectangle2D getAnnotRect(PDFObject[] controlRectObjs) {
        double x = 0.0;
        double y = 0.0;
        double w = 0.0;
        double h = 0.0;
        try {
            block8: for (int i = 0; i < controlRectObjs.length; ++i) {
                if (controlRectObjs[i] == null || controlRectObjs[i].getType() != 2) continue;
                double coordinate = controlRectObjs[i].getDoubleValue();
                switch (i) {
                    case 0: {
                        x = coordinate;
                        continue block8;
                    }
                    case 1: {
                        y = coordinate;
                        continue block8;
                    }
                    case 2: {
                        w = coordinate - x;
                        continue block8;
                    }
                    case 3: {
                        h = coordinate - y;
                        continue block8;
                    }
                }
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    public static enum CBSTATE {
        on,
        off,
        undefined;

    }
}

