/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.command;

import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.command.PDFCmd;
import java.util.Arrays;

public class PDFChangeStrokeCmd
extends PDFCmd {
    private float width = -1000.0f;
    private float limit = -1000.0f;
    private float phase = -1000.0f;
    private int cap = -1000;
    private int join = -1000;
    private float[] ary = PDFRenderer.NODASH;

    public void setWidth(float w) {
        this.width = w;
    }

    public void setEndCap(int cap) {
        this.cap = cap;
    }

    public void setLineJoin(int join) {
        this.join = join;
    }

    public void setMiterLimit(float limit) {
        this.limit = limit;
    }

    public void setDash(float[] ary, float phase) {
        float total = 0.0f;
        boolean underZero = false;
        if (ary != null) {
            int i;
            int size = 0;
            for (i = 0; i < ary.length; ++i) {
                if (ary[i] < 0.0f) {
                    underZero = true;
                }
                if (!((double)ary[i] >= 0.001) || size % 2 == i % 2) continue;
                ++size;
            }
            ++size;
            if (ary.length % 2 == 1) {
                size *= 2;
                float[] ary2 = new float[ary.length * 2];
                for (int i2 = 0; i2 < ary.length; ++i2) {
                    ary2[i2] = ary[i2];
                    ary2[ary2.length - i2 - 1] = ary[i2];
                }
                ary = ary2;
            }
            if (size < ary.length) {
                float[] copy = new float[(int)Math.ceil((double)size / 2.0) * 2];
                int j = 0;
                for (int i3 = 0; i3 < ary.length; ++i3) {
                    if (!((double)ary[i3] >= 0.001)) continue;
                    if (j % 2 != i3 % 2) {
                        // empty if block
                    }
                    int n = ++j;
                    copy[n] = copy[n] + ary[i3];
                }
                ary = copy;
            }
            if (phase < 0.0f) {
                for (i = 0; i < ary.length; ++i) {
                    total += ary[i];
                }
            }
        }
        if (underZero) {
            this.ary = new float[]{0.0f};
            this.phase = 0.0f;
        } else {
            this.ary = ary;
            this.phase = phase;
            while (this.phase < 0.0f) {
                this.phase += total;
            }
        }
    }

    @Override
    public void execute(PDFRenderer renderer) {
        renderer.setStrokeParts(this.width, this.cap, this.join, this.limit, this.ary, this.phase);
    }

    @Override
    public String toString() {
        return "STROKE: width=" + this.width + " cap=" + this.cap + " join=" + this.join + " limit=" + this.limit + " ary=" + Arrays.toString(this.ary) + " phase=" + this.phase;
    }
}

