/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.colorspace;

import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.pattern.PDFPattern;
import java.util.Map;

public class PatternSpace
extends PDFColorSpace {
    private static final long serialVersionUID = -5932026533329528737L;
    private PDFColorSpace base;

    public PatternSpace() {
        super(null);
    }

    public PatternSpace(PDFColorSpace base) {
        super(null);
        this.base = base;
    }

    public PDFColorSpace getBase() {
        return this.base;
    }

    @Override
    public int getNumComponents() {
        if (this.base == null) {
            return 0;
        }
        return this.base.getNumComponents();
    }

    @Override
    public PDFPaint getPaint(float[] components) {
        throw new IllegalArgumentException("Pattern spaces require a pattern name!");
    }

    public PDFPaint getPaint(PDFObject patternObj, float[] components, Map<String, PDFObject> resources, PDFDecrypter decrypter, CacheAccess fontGenerationListener, PDFPage pdfPage, boolean isAlphaChannel) throws PDFParseException {
        PDFPattern pattern;
        PDFPaint basePaint = null;
        PDFColorSpace baseColorSpace = this.getBase();
        if (this.getBase() != null && components != null) {
            basePaint = baseColorSpace.getPaint(components);
        }
        if ((pattern = (PDFPattern)patternObj.getCache()) == null) {
            pattern = PDFPattern.getPattern(patternObj, resources, decrypter, fontGenerationListener, pdfPage, isAlphaChannel);
            patternObj.setCache(pattern);
        }
        return pattern.getPaint(basePaint);
    }
}

