/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.colorspace;

import java.awt.color.ColorSpace;

public class CMYKColorSpace
extends ColorSpace {
    private static final long serialVersionUID = -5861500262259679895L;

    public CMYKColorSpace() {
        super(9, 4);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        return new float[3];
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        float[] color = new float[4];
        float c = 1.0f - rgbvalue[0];
        float m = 1.0f - rgbvalue[1];
        float y = 1.0f - rgbvalue[2];
        float k = Math.min(c, Math.min(m, y));
        float ik = 1.0f - k;
        if (ik == 0.0f) {
            c = 1.0f;
            m = 1.0f;
            y = 1.0f;
        } else {
            c = (c - k) / ik;
            m = (m - k) / ik;
            y = (y - k) / ik;
        }
        color[0] = c;
        color[1] = m;
        color[2] = y;
        color[3] = k;
        return color;
    }

    @Override
    public int getNumComponents() {
        return 4;
    }

    @Override
    public String getName(int idx) {
        return "CMYK";
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        return new float[3];
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        if (colorvalue.length == 4) {
            float b;
            float c = colorvalue[0];
            float m = colorvalue[1];
            float y = colorvalue[2];
            float k = colorvalue[3];
            float cInv = 1.0f - c;
            float mInv = 1.0f - m;
            float yInv = 1.0f - y;
            float kInv = 1.0f - k;
            float g = b = cInv * mInv * yInv * kInv;
            float r = b;
            float tmp = cInv * mInv * yInv * k;
            r += 0.1373f * tmp;
            g += 0.1216f * tmp;
            b += 0.1255f * tmp;
            tmp = cInv * mInv * y * kInv;
            r += tmp;
            g += 0.949f * tmp;
            tmp = cInv * mInv * y * k;
            r += 0.1098f * tmp;
            g += 0.102f * tmp;
            tmp = cInv * m * yInv * kInv;
            r += 0.9255f * tmp;
            b += 0.549f * tmp;
            tmp = cInv * m * yInv * k;
            r += 0.1412f * tmp;
            tmp = cInv * m * y * kInv;
            r += 0.9294f * tmp;
            g += 0.1098f * tmp;
            b += 0.1412f * tmp;
            tmp = cInv * m * y * k;
            r += 0.1333f * tmp;
            tmp = c * mInv * yInv * kInv;
            g += 0.6784f * tmp;
            b += 0.9373f * tmp;
            tmp = c * mInv * yInv * k;
            g += 0.0588f * tmp;
            b += 0.1412f * tmp;
            tmp = c * mInv * y * kInv;
            g += 0.651f * tmp;
            b += 0.3137f * tmp;
            tmp = c * mInv * y * k;
            g += 0.0745f * tmp;
            tmp = c * m * yInv * kInv;
            r += 0.1804f * tmp;
            g += 0.1922f * tmp;
            b += 0.5725f * tmp;
            tmp = c * m * yInv * k;
            b += 0.0078f * tmp;
            tmp = c * m * y * kInv;
            float[] color = new float[]{Math.max(0.0f, Math.min(1.0f, r += 0.2118f * tmp)), Math.max(0.0f, Math.min(1.0f, g += 0.2119f * tmp)), Math.max(0.0f, Math.min(1.0f, b += 0.2235f * tmp))};
            return color;
        }
        return new float[3];
    }
}

