/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.colorspace;

import com.inet.pdfview.colorspace.BaseChromaticAdaptationTransform;
import com.inet.pdfview.colorspace.Matrix;
import com.inet.pdfview.colorspace.StandardIlluminant;

public class BradfordChromaticAdaptationTransform
extends BaseChromaticAdaptationTransform {
    private static final double[][] BRADFORD_TRANSFORM_MATRIX = new double[][]{{0.8951, 0.2664, -0.1614}, {-0.7502, 1.7135, 0.0367}, {0.0389, -0.0685, 1.0296}};
    private static final double[][] INVERSE_BRADFORD_TRANSFORM_MATRIX = new double[][]{{0.987, -0.1471, 0.16}, {0.4323, 0.5184, 0.0493}, {-0.0085, 0.04, 0.9685}};
    private double[][] catMatrix;

    BradfordChromaticAdaptationTransform(StandardIlluminant sourceillum, StandardIlluminant targetillum) {
        super(sourceillum.getXYZAsArray(), targetillum.getXYZAsArray());
        this.calculateCatMatrix();
    }

    void calculateCatMatrix() {
        double[] auxiliaryInitialRGB = Matrix.multiplyVector(BRADFORD_TRANSFORM_MATRIX, this.getSourceWhitePointDouble());
        double[] auxiliaryTargetlRGB = Matrix.multiplyVector(BRADFORD_TRANSFORM_MATRIX, this.getTargetWhitePointDouble());
        double[][] scaleMatrix = Matrix.getScaleMatrix(auxiliaryInitialRGB, auxiliaryTargetlRGB);
        double[][] scaledBradfordMatrix = Matrix.multiplyMatrix(scaleMatrix, BRADFORD_TRANSFORM_MATRIX);
        this.catMatrix = Matrix.multiplyMatrix(INVERSE_BRADFORD_TRANSFORM_MATRIX, scaledBradfordMatrix);
    }

    @Override
    public float[] transform(float[] sourceXYZ) {
        float[] targetXYZ = new float[3];
        for (int i = 0; i < 3; ++i) {
            targetXYZ[i] = (float)(this.catMatrix[i][0] * (double)sourceXYZ[0] + this.catMatrix[i][1] * (double)sourceXYZ[1] + this.catMatrix[i][2] * (double)sourceXYZ[2]);
        }
        return targetXYZ;
    }
}

