/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.pdfview.PDFTextFormat;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFGlyph;
import com.inet.shared.bidi.BidiString;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.util.List;
import javax.annotation.Nonnull;

public class BidiRenderer {
    public static void drawStringOriginalOrder(@Nonnull Graphics2D g, @Nonnull Font font, PDFFont pdfFont, @Nonnull String content, float x, float y) {
        Paint originalColor = g.getPaint();
        if (!pdfFont.isValidMapping() && content.length() > 1) {
            for (int i = 0; i < content.length(); ++i) {
                int type = Character.getType(content.charAt(i));
                if (type != 6) continue;
                float kerning = 0.0f;
                Object tracking = font.getAttributes().get(TextAttribute.TRACKING);
                if (font.getAttributes().get(TextAttribute.KERNING) == TextAttribute.KERNING_ON && tracking instanceof Float) {
                    kerning = ((Float)tracking).floatValue();
                }
                List<PDFGlyph> glyphs = pdfFont.getGlyphs(new PDFTextFormat.TextWrapper(content, true, null));
                AffineTransform t0 = g.getTransform();
                g.scale(1.0, -1.0);
                for (PDFGlyph glyph : glyphs) {
                    g.fill(glyph.getShape());
                    g.translate(glyph.getAdvance().getX() + (double)kerning, glyph.getAdvance().getY());
                }
                g.setTransform(t0);
                g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                g.drawString(content, x, y);
                g.setPaint(originalColor);
                return;
            }
        }
        if (content.length() > 1 && BidiString.hasRightToLeftChars((String)content)) {
            String reordered = BidiString.reorderReverse((String)content);
            new TextLayout(reordered, font, g.getFontRenderContext()).draw(g, x, y);
        } else {
            g.drawString(content, x, y);
        }
    }
}

