/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern.shadertype4;

import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.function.PDFFunction;
import com.inet.pdfview.pattern.shadertype4.SingleTriangleGradientProcessor;
import com.inet.pdfview.pattern.shadertype4.VertexTriangle;
import java.awt.PaintContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultipleTriangleGradientContext
implements PaintContext,
Serializable {
    private static final long serialVersionUID = -5060126796305808484L;
    private List<VertexTriangle> transformedTriangles;
    private PDFFunction[] functions;
    private PDFColorSpace pdfColorSpace;

    public MultipleTriangleGradientContext(@Nonnull List<VertexTriangle> transformedTriangles, PDFFunction @Nullable [] functions, @Nonnull PDFColorSpace pdfColorSpace) {
        this.transformedTriangles = transformedTriangles;
        this.functions = functions;
        this.pdfColorSpace = pdfColorSpace;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        int[] data = new int[w * h * 4];
        for (VertexTriangle triangle : this.transformedTriangles) {
            if ((double)(y + h) < triangle.getVertexes()[0].getY() || (double)y > triangle.getVertexes()[2].getY() || (double)(x + w) < triangle.getMinX() || (double)x > triangle.getMaxX()) continue;
            SingleTriangleGradientProcessor processor = new SingleTriangleGradientProcessor(triangle, this.functions, this.pdfColorSpace);
            processor.fillRaster(x, y, w, h, data);
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }
}

