/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.function.PDFFunction;
import com.inet.pdfview.pattern.PDFShader;
import java.awt.Color;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public class ShaderType3
extends PDFShader {
    private static final long serialVersionUID = -8792589634274004868L;
    private static final float MIN_DEVIATION = 0.001f;
    private Point2D gradStart;
    private float startingRadius;
    private Point2D gradEnd;
    private float endingRadius;
    private float minT = 0.0f;
    private float maxT = 1.0f;
    private float[] tValues = new float[]{this.minT, this.maxT};
    private boolean extendStart = false;
    private boolean extendEnd = false;
    private PDFFunction[] functions;
    private Paint smask;
    private boolean isAlphaChannel;

    public ShaderType3() {
        super(3);
    }

    @Override
    public void parse(PDFObject shareObj, PDFDecrypter decrypter, AffineTransform transform, Paint smask, boolean isAlphaChannel) throws PDFParseException {
        PDFObject functionObj;
        PDFObject domainObj;
        this.smask = smask;
        this.isAlphaChannel = isAlphaChannel;
        PDFObject coordsObj = shareObj.getDictRef("Coords");
        if (coordsObj == null) {
            throw new PDFParseException("ShaderType3: no coordinates found!");
        }
        PDFObject[] coords = coordsObj.getArray();
        if (coords.length != 6) {
            throw new PDFParseException("ShaderType3: invalid coordinates length: " + coords.length);
        }
        float rScale = (float)Math.abs(transform.getScaleX() + transform.getShearY());
        this.gradStart = new Point2D.Float(coords[0].getFloatValue(), coords[1].getFloatValue());
        this.startingRadius = coords[2].getFloatValue() * rScale;
        this.gradEnd = new Point2D.Float(coords[3].getFloatValue(), coords[4].getFloatValue());
        this.endingRadius = coords[5].getFloatValue() * rScale;
        this.gradStart = transform.transform(this.gradStart, this.gradStart);
        this.gradEnd = transform.transform(this.gradEnd, this.gradEnd);
        if (!this.gradStart.equals(this.gradEnd)) {
            PDFParser.LOGGER.warn((Object)"The case of two differnet circle centers in radial gradient is not supported");
        }
        if (this.startingRadius > 0.001f && this.endingRadius > 0.001f) {
            PDFParser.LOGGER.warn((Object)"The case of two circles in radial gradient is not supported");
        }
        if ((domainObj = shareObj.getDictRef("Domain")) != null) {
            PDFObject[] domain = domainObj.getArray();
            this.minT = domain[0].getFloatValue();
            this.maxT = domain[1].getFloatValue();
        }
        if ((functionObj = shareObj.getDictRef("Function")) == null) {
            throw new PDFParseException("ShaderType3: No function defined!");
        }
        PDFXref ref = functionObj.getRefValue();
        PDFObject[] functionArray = functionObj.getArray();
        this.functions = new PDFFunction[functionArray.length];
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i] = PDFFunction.getFunction(functionArray[i], decrypter, ref);
            this.tValues = this.functions[i].getSubDomains();
        }
        PDFObject extendObj = shareObj.getDictRef("Extend");
        if (extendObj != null) {
            PDFObject[] extendArray = extendObj.getArray();
            this.extendStart = extendArray[0].getBooleanValue();
            this.extendEnd = extendArray[1].getBooleanValue();
        }
    }

    @Override
    public PDFPaint getPaint() {
        RadialGradientPaint paint = this.getRadialPaint();
        return PDFPaint.getPaint(paint);
    }

    @Override
    public PDFPaint getPatternPaint() {
        if (this.startingRadius < 0.001f && this.endingRadius < 0.001f) {
            return null;
        }
        return new PDFPaintWrapper(this.getRadialPaint());
    }

    private RadialGradientPaint getRadialPaint() {
        Color[] colorsTmp;
        float radius;
        Color[] colors = new Color[this.tValues.length];
        PDFColorSpace colorSpace = this.getColorSpace();
        int componentCount = colorSpace.getNumComponents();
        float[] inputs = new float[1];
        float[] outputs = new float[componentCount];
        for (int i = 0; i < this.tValues.length; ++i) {
            inputs[0] = this.tValues[i];
            colors[i] = this.calculateColor(inputs, outputs);
        }
        if (this.startingRadius <= this.endingRadius) {
            radius = this.endingRadius;
        } else {
            for (int i = 0; i < colors.length / 2; ++i) {
                Color temp = colors[i];
                colors[i] = colors[colors.length - i - 1];
                colors[colors.length - i - 1] = temp;
            }
            radius = this.startingRadius;
        }
        if (this.smask != null) {
            if (this.smask instanceof RadialGradientPaint) {
                RadialGradientPaint radialGradientPaint = (RadialGradientPaint)this.smask;
                Color[] colorsAlphaChannel = radialGradientPaint.getColors();
                colors = this.mergeAlphaChannel(colors, colorsAlphaChannel);
            } else {
                PDFParser.LOGGER.error((Object)"RadialGradient SMASK with LinearGradient ALPHA channel is not yet supported");
            }
        }
        float[] fractions = new float[this.tValues.length];
        float unit = this.maxT - this.minT;
        for (int i = 0; i < this.tValues.length; ++i) {
            fractions[i] = this.tValues[i] / unit;
            if (!((double)fractions[i] > 1.0)) continue;
            fractions[i] = 1.0f;
        }
        if (!this.getExtendStart()) {
            float[] tmp = new float[fractions.length + 1];
            System.arraycopy(fractions, 0, tmp, 1, fractions.length);
            tmp[0] = tmp[1];
            fractions = tmp;
            colorsTmp = new Color[colors.length + 1];
            System.arraycopy(colors, 0, colorsTmp, 1, colors.length);
            colorsTmp[0] = TRANSPARENT;
            colors = colorsTmp;
        }
        if (!this.getExtendEnd()) {
            float[] tmp = new float[fractions.length + 1];
            System.arraycopy(fractions, 0, tmp, 0, fractions.length);
            tmp[tmp.length - 1] = tmp[fractions.length - 1];
            fractions = tmp;
            colorsTmp = new Color[colors.length + 1];
            System.arraycopy(colors, 0, colorsTmp, 0, colors.length);
            colorsTmp[colorsTmp.length - 1] = TRANSPARENT;
            colors = colorsTmp;
        }
        fractions = ShaderType3.normalize(fractions);
        return new RadialGradientPaint(this.gradStart, radius, fractions, colors);
    }

    public boolean getExtendStart() {
        return this.extendStart;
    }

    public boolean getExtendEnd() {
        return this.extendEnd;
    }

    private Color calculateColor(float[] inputs, float[] outputs) {
        Color res = null;
        if (this.functions.length == 1) {
            this.functions[0].calculate(inputs, 0, outputs, 0);
        } else {
            for (int f = 0; f < this.functions.length; ++f) {
                this.functions[f].calculate(inputs, 0, outputs, f);
            }
        }
        PDFPaint pdfpaint0 = this.getColorSpace().getPaint(outputs);
        Paint p = pdfpaint0.getPaint(null);
        if (p instanceof Color) {
            res = (Color)p;
        }
        return res;
    }

    private class PDFPaintWrapper
    extends PDFPaint {
        private Point2D start;
        private final float[] fractions;
        private final Color[] colors;
        private RadialGradientPaint gradientPaint;

        public PDFPaintWrapper(RadialGradientPaint gradientPaint) {
            super(gradientPaint);
            this.fractions = gradientPaint.getFractions();
            this.colors = gradientPaint.getColors();
            this.gradientPaint = gradientPaint;
        }

        @Override
        public Paint getPaint(PDFRenderer state) {
            float radius = this.gradientPaint.getRadius();
            try {
                this.start = this.gradientPaint.getCenterPoint();
                AffineTransform inverse = state.getTransform().createInverse();
                inverse.transform(this.start, this.start);
                Point2D.Double p = new Point2D.Double(radius, 0.0);
                double[] flatmatrix = new double[6];
                inverse.getMatrix(flatmatrix);
                flatmatrix[4] = 0.0;
                flatmatrix[5] = 0.0;
                inverse = new AffineTransform(flatmatrix);
                inverse.transform(p, p);
                radius = (float)p.distance(0.0, 0.0);
            }
            catch (NoninvertibleTransformException e) {
                PDFParser.LOGGER.warn((Object)"NoninvertibleTransform by Shader3, some object are incorrect.");
            }
            return new RadialGradientPaint(this.start, radius, this.fractions, this.colors);
        }
    }
}

