/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.pattern.BitReader;
import com.inet.pdfview.pattern.DoubleDecodingReader;
import com.inet.pdfview.pattern.PDFShader;
import com.inet.pdfview.pattern.TensorProductMeshGradient;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;

public abstract class AbstractTensorShaderType
extends PDFShader {
    private static final long serialVersionUID = 8507195768975227971L;
    private TensorProductMeshGradient tensorProductGradient;

    public AbstractTensorShaderType() {
        super(7);
    }

    @Override
    public void parse(PDFObject shareObj, PDFDecrypter decryptor, AffineTransform transform, Paint smask, boolean isAlphaChannel) throws PDFParseException {
        int bitsPerCoordinate = shareObj.getDictRef("BitsPerCoordinate").getIntValue();
        int bitsPerComponent = shareObj.getDictRef("BitsPerComponent").getIntValue();
        int bitsPerFlag = shareObj.getDictRef("BitsPerFlag").getIntValue();
        PDFObject[] decode = shareObj.getDictRef("Decode").getArray();
        double minX = decode[0].getDoubleValue();
        double maxX = decode[1].getDoubleValue();
        double minY = decode[2].getDoubleValue();
        double maxY = decode[3].getDoubleValue();
        byte[] data = shareObj.getStream(shareObj.getRefValue(), decryptor, true);
        BitReader bitReader = new BitReader(new ByteArrayInputStream(data));
        PointDecodingReader pointReader = new PointDecodingReader(new DoubleDecodingReader(minX, maxX, bitsPerCoordinate, bitReader), new DoubleDecodingReader(minY, maxY, bitsPerCoordinate, bitReader), transform);
        int colorComponents = (decode.length - 4) / 2;
        DoubleDecodingReader[] colorComponentReaders = new DoubleDecodingReader[colorComponents];
        for (int i = 0; i < colorComponents; ++i) {
            colorComponentReaders[i] = new DoubleDecodingReader(decode[4 + i * 2].getDoubleValue(), decode[4 + i * 2 + 1].getDoubleValue(), bitsPerComponent, bitReader);
        }
        ColorDecodingReader colorReader = new ColorDecodingReader(this.getColorSpace(), colorComponentReaders);
        this.tensorProductGradient = new TensorProductMeshGradient();
        Point2D.Double[][] prevPoints = null;
        Color[] prevColors = null;
        try {
            while (true) {
                int edgeFlag;
                try {
                    edgeFlag = bitReader.read(bitsPerFlag);
                }
                catch (EOFException e) {
                    break;
                }
                Point2D.Double[][] points = new Point2D.Double[4][4];
                Color[] colors = new Color[4];
                this.readPatch(pointReader, colorReader, edgeFlag, points, colors, prevPoints, prevColors);
                this.tensorProductGradient.addPatch(new TensorProductMeshGradient.Patch(points, colors));
                prevPoints = points;
                prevColors = colors;
            }
        }
        catch (IOException e) {
            throw PDFParseException.create(e);
        }
    }

    protected abstract void readPatch(PointDecodingReader var1, ColorDecodingReader var2, int var3, Point2D.Double[][] var4, Color[] var5, Point2D.Double[][] var6, Color[] var7) throws IOException, IllegalArgumentException;

    @Override
    public PDFPaint getPaint() {
        return new PDFPaint(this.tensorProductGradient);
    }

    protected static class PointDecodingReader {
        private DoubleDecodingReader xd;
        private DoubleDecodingReader yd;
        private AffineTransform transform;

        private PointDecodingReader(DoubleDecodingReader xd, DoubleDecodingReader yd, AffineTransform transform) {
            this.xd = xd;
            this.yd = yd;
            this.transform = transform;
        }

        public Point2D.Double read() throws IOException {
            Point2D point = new Point2D.Double(this.xd.read(), this.yd.read());
            point = this.transform.transform(point, point);
            return new Point2D.Double(point.getX(), point.getY());
        }
    }

    protected static class ColorDecodingReader {
        private PDFColorSpace colorSpace;
        private DoubleDecodingReader[] doubleDecoders;

        private ColorDecodingReader(PDFColorSpace colorSpace, DoubleDecodingReader[] doubleDecoders) {
            if (colorSpace.getNumComponents() != doubleDecoders.length) {
                throw new IllegalArgumentException("ColorDecodingReader: Number of color components has to match the number of readers!");
            }
            this.colorSpace = colorSpace;
            this.doubleDecoders = doubleDecoders;
        }

        public Color read() throws IOException {
            float[] v = new float[this.doubleDecoders.length];
            for (int i = 0; i < v.length; ++i) {
                v[i] = (float)this.doubleDecoders[i].read();
            }
            float[] rgb = this.colorSpace.toRGB(v);
            return new Color(rgb[0], rgb[1], rgb[2], rgb.length > 3 ? rgb[3] : 0.0f);
        }
    }
}

