/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.optionalcontent;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.optionalcontent.OCG;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OCGHandler {
    private Set<OCG> allOCGs = new HashSet<OCG>();
    private Set<OCG> on = new HashSet<OCG>();
    private Set<OCG> off = new HashSet<OCG>();

    public static OCGHandler createHandler(PDFObject ocPropertiesObject) throws PDFParseException {
        PDFObject[] ocgs;
        if (ocPropertiesObject == null) {
            return null;
        }
        OCGHandler handler = new OCGHandler();
        PDFObject ocgsObject = ocPropertiesObject.getDictRef("OCGs");
        if (ocgsObject == null) {
            return null;
        }
        for (PDFObject o : ocgs = ocgsObject.getArray()) {
            List<OCG> ocgList = OCG.getOCG(o);
            if (ocgList == null) continue;
            handler.allOCGs.addAll(ocgList);
            handler.on.addAll(ocgList);
        }
        PDFObject ocConfig = ocPropertiesObject.getDictRef("D");
        if (ocConfig != null) {
            List<OCG> ocgList;
            PDFObject[] off;
            String baseState;
            if (ocConfig.getDictRef("BaseState") != null && "OFF".equals(baseState = ocConfig.getDictRef("BaseState").getStringValue())) {
                handler.on.clear();
                handler.off.addAll(handler.allOCGs);
            }
            PDFObject[] on = ocConfig.getDictRef("ON") != null ? ocConfig.getDictRef("ON").getArray() : null;
            PDFObject[] pDFObjectArray = off = ocConfig.getDictRef("OFF") != null ? ocConfig.getDictRef("OFF").getArray() : null;
            if (off != null) {
                for (PDFObject o : off) {
                    ocgList = OCG.getOCG(o);
                    if (ocgList == null) continue;
                    handler.on.removeAll(ocgList);
                    handler.off.addAll(ocgList);
                }
            }
            if (on != null) {
                for (PDFObject o : on) {
                    ocgList = OCG.getOCG(o);
                    if (ocgList == null) continue;
                    handler.off.removeAll(ocgList);
                    handler.on.addAll(ocgList);
                }
            }
        }
        return handler;
    }

    public boolean isVisible(OCG ocg) {
        return this.on.contains(ocg);
    }
}

