/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.function.cmds;

import com.inet.pdfview.function.cmds.PSCmd;
import java.util.List;

public class RollCmd
extends PSCmd {
    private static final long serialVersionUID = -2047832367885280930L;

    RollCmd(List<Double> argList) {
        super(argList);
    }

    @Override
    public List<Double> exec(List<Double> list) {
        int i;
        if ((list = this.prepareArgumentList(list)) == null) {
            throw new IllegalStateException("Roll command arguments are not specified");
        }
        int size = list.size();
        if (size < 2) {
            throw new IllegalStateException("Invalid Roll command arguments size: " + size);
        }
        int j = (int)Math.round(list.get(size - 1));
        int n = (int)Math.round(list.get(size - 2));
        int basePos = (size = (list = list.subList(0, size - 2)).size()) - n;
        if (basePos < 0) {
            throw new IllegalArgumentException("invalid roll count " + n + "in stack of " + size + "elements");
        }
        if (n == 0) {
            return list;
        }
        Double[] arr = new Double[n];
        for (i = 0; i < n; ++i) {
            arr[i] = list.get(basePos + RollCmd.getRelativeIndex(-j + i, n));
        }
        for (i = 0; i < n; ++i) {
            list.set(basePos + i, arr[i]);
        }
        return list;
    }

    private static int getRelativeIndex(int index, int count) {
        index %= count;
        while (index < 0) {
            index += count;
        }
        return index;
    }
}

