/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.function.cmds;

import com.inet.pdfview.function.cmds.PSCmd;
import java.util.List;

public class IndexCmd
extends PSCmd {
    private static final long serialVersionUID = -8506345955368124867L;

    IndexCmd(List<Double> argList) {
        super(argList);
    }

    @Override
    public List<Double> exec(List<Double> list) {
        if ((list = this.prepareArgumentList(list)) == null) {
            throw new IllegalStateException("Index command arguments are not specified");
        }
        int size = list.size();
        if (size < 2) {
            throw new IllegalStateException("Invalid Index command arguments size: " + size);
        }
        int n = (int)Math.round(list.get(size - 1));
        if (size < n + 2) {
            throw new IllegalStateException("Invalid Index command arguments size: " + size + "; n=" + n);
        }
        double indexedElement = list.get(size - 2 - n);
        list.set(size - 1, indexedElement);
        return list;
    }
}

