/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.function;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.function.PDFFunction;
import com.inet.pdfview.function.PSCmdParser;
import com.inet.pdfview.function.cmds.PSCmd;
import java.util.ArrayList;
import java.util.List;

public class FunctionType4
extends PDFFunction {
    private static final long serialVersionUID = 1952510909126005703L;
    private List<PSCmd> cmdList;

    protected FunctionType4() {
        super(4);
    }

    @Override
    protected void doFunction(float[] inputs, int inputOffset, float[] outputs, int outputOffset) {
        if (outputs == null) {
            PDFParser.LOGGER.error((Object)"return value of function type 4 is not defined");
            return;
        }
        if (this.cmdList == null) {
            PDFParser.LOGGER.error((Object)"function of type 4 contains no operators");
            return;
        }
        List<Double> functionArgs = new ArrayList<Double>();
        for (int i = 0; i < inputs.length; ++i) {
            functionArgs.add(Double.valueOf(inputs[i]));
        }
        for (PSCmd cmd : this.cmdList) {
            functionArgs = cmd.exec(functionArgs);
        }
        if (functionArgs == null) {
            throw new IllegalStateException("calculation of type 4 function failed");
        }
        if (functionArgs.size() != outputs.length) {
            throw new IllegalStateException("invalid dimension of return values: " + functionArgs.size() + " , " + outputs.length);
        }
        for (int i = 0; i < outputs.length; ++i) {
            outputs[i] = functionArgs.get(i).floatValue();
        }
    }

    @Override
    protected void parse(PDFObject obj, PDFDecrypter decryptor, PDFXref ref) throws PDFParseException {
        if (obj.getType() == 7) {
            byte[] psString = obj.getStream(ref, decryptor, true);
            PSCmdParser cals = new PSCmdParser(psString);
            this.cmdList = cals.parse();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionType4 other = (FunctionType4)obj;
        return !(this.cmdList == null ? other.cmdList != null : !this.cmdList.equals(other.cmdList));
    }
}

