/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf.table;

import com.inet.pdfview.PDFParser;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.font.ttf.table.HeadTable;
import com.inet.pdfview.font.ttf.table.MaxpTable;
import com.inet.pdfview.font.ttf.table.TrueTypeTable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class LocaTable
extends TrueTypeTable {
    private boolean isLong;
    private int[] offsets;
    private boolean requiresSorting;
    private int[] sizes;
    private MaxpTable maxp;

    public LocaTable(MaxpTable maxp, HeadTable head) {
        super(1819239265);
        this.maxp = maxp;
        int numGlyphs = maxp.getNumGlyphsUnsigned();
        short format = head.getIndexToLocFormat();
        this.isLong = format == 1;
        this.offsets = new int[numGlyphs + 1];
    }

    public LocaTable(int numGlyphs, boolean isLong) {
        super(1819239265);
        this.isLong = isLong;
        this.offsets = new int[numGlyphs + 1];
    }

    public int getOffset(int glyphID) {
        return this.offsets[glyphID];
    }

    public void setOffset(int glyphID, int offset) {
        this.offsets[glyphID] = offset;
    }

    public int getSize(int glyphID) {
        if (this.requiresSorting) {
            return this.sizes[glyphID];
        }
        return this.offsets[glyphID + 1] - this.offsets[glyphID];
    }

    public boolean isLongFormat() {
        return this.isLong;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        int size = this.getLength();
        ByteBuffer buf = ByteBuffer.allocate(size);
        for (int i = 0; i < this.offsets.length; ++i) {
            if (this.isLongFormat()) {
                buf.putInt(this.offsets[i]);
                continue;
            }
            buf.putShort((short)(this.offsets[i] / 2));
        }
        buf.flip();
        return buf;
    }

    @Override
    public void setData(IDataBuffer data) {
        int i;
        for (i = 0; i < this.offsets.length; ++i) {
            try {
                if (this.isLongFormat()) {
                    this.offsets[i] = data.getInt();
                    continue;
                }
                this.offsets[i] = 2 * (data.getShort() & 0xFFFF);
                continue;
            }
            catch (BufferUnderflowException e) {
                int numGlyphs = i - 1;
                int[] offsetCopy = new int[i];
                System.arraycopy(this.offsets, 0, offsetCopy, 0, i);
                this.maxp.setNumGlyphs((short)numGlyphs);
                this.offsets = offsetCopy;
            }
        }
        for (i = 0; i < this.offsets.length - 1; ++i) {
            if (this.offsets[i + 1] >= this.offsets[i]) continue;
            this.requiresSorting = true;
            break;
        }
        if (this.requiresSorting) {
            this.calculateSizeArray();
        }
    }

    @Override
    public int getLength() {
        if (this.isLongFormat()) {
            return this.offsets.length * 4;
        }
        return this.offsets.length * 2;
    }

    private void calculateSizeArray() {
        int id;
        this.sizes = new int[this.offsets.length - 1];
        for (int i = 0; i < this.sizes.length; ++i) {
            this.sizes[i] = -1;
        }
        for (id = 0; id < this.offsets.length - 1; ++id) {
            int minOffset = Integer.MAX_VALUE;
            for (int next = 0; next < this.offsets.length; ++next) {
                if (next == id) continue;
                int distance = this.offsets[next] - this.offsets[id];
                if (distance == 0) {
                    if (next <= id) continue;
                    this.sizes[id] = 0;
                    break;
                }
                if (distance <= 0 || distance >= minOffset) continue;
                minOffset = distance;
            }
            if (this.sizes[id] != -1) continue;
            this.sizes[id] = minOffset;
        }
        for (id = 0; id < this.sizes.length; ++id) {
            if (this.sizes[id] != Integer.MAX_VALUE) continue;
            this.sizes[id] = 0;
            PDFParser.LOGGER.warn((Object)("Glyph size is not defined id=" + id + " from " + this.sizes.length + ". The font rendering may be incorrect."));
        }
    }

    @Override
    public String toString() {
        if (this.requiresSorting) {
            StringBuilder b = new StringBuilder("Offsets(" + this.offsets.length + "): ");
            for (int i = 0; i < Math.min(10, this.offsets.length); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append('(');
                b.append(this.offsets[i]);
                b.append(',');
                b.append(this.sizes[i]);
                b.append(')');
            }
            return b.toString();
        }
        return "Offsets(" + this.offsets.length + "): " + Arrays.toString(this.offsets);
    }
}

