/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf.table;

import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.font.ttf.glyph.Glyf;
import com.inet.pdfview.font.ttf.table.LocaTable;
import com.inet.pdfview.font.ttf.table.MaxpTable;
import com.inet.pdfview.font.ttf.table.TrueTypeTable;
import java.nio.ByteBuffer;

public class GlyfTable
extends TrueTypeTable {
    private Object[] glyphs;
    private LocaTable loca;

    protected GlyfTable(LocaTable loca, MaxpTable maxp) {
        super(1735162214);
        this.loca = loca;
        int numGlyphs = maxp.getNumGlyphsUnsigned();
        this.glyphs = new Object[numGlyphs];
    }

    public GlyfTable(LocaTable loca, int numGlyphs) {
        super(1735162214);
        this.loca = loca;
        this.glyphs = new Glyf[numGlyphs];
    }

    public Glyf getGlyph(int index) {
        if (index >= this.glyphs.length) {
            return null;
        }
        Object o = this.glyphs[index];
        if (o == null) {
            return null;
        }
        if (o instanceof IDataBuffer) {
            Glyf g = Glyf.getGlyf((IDataBuffer)o);
            this.glyphs[index] = g;
            return g;
        }
        return (Glyf)o;
    }

    public void setGlyph(int glyphID, Glyf glyph) {
        this.glyphs[glyphID] = glyph;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        int size = this.getLength();
        ByteBuffer buf = ByteBuffer.allocate(size);
        for (int i = 0; i < this.glyphs.length; ++i) {
            Object glyfData;
            Object o = this.glyphs[i];
            this.loca.setOffset(i, buf.position());
            if (o == null) continue;
            if (o instanceof IDataBuffer) {
                glyfData = (IDataBuffer)o;
                glyfData.rewind();
                byte[] content = new byte[glyfData.capacity()];
                glyfData.get(content);
                glyfData.flip();
                buf.put(content);
                continue;
            }
            glyfData = ((Glyf)o).toByteBuffer();
            ((ByteBuffer)glyfData).rewind();
            buf.put((ByteBuffer)glyfData);
            ((ByteBuffer)glyfData).flip();
        }
        this.loca.setOffset(this.glyphs.length, buf.position());
        buf.flip();
        return buf;
    }

    @Override
    public void setData(IDataBuffer data) {
        for (int i = 0; i < this.glyphs.length; ++i) {
            int location = this.loca.getOffset(i);
            int length = this.loca.getSize(i);
            if (length == 0) continue;
            data.position(location);
            IDataBuffer glyfData = data.slice();
            glyfData.limit(Math.min(length, data.remaining()));
            this.glyphs[i] = glyfData;
        }
    }

    @Override
    public int getLength() {
        int length = 0;
        for (int i = 0; i < this.glyphs.length; ++i) {
            Object o = this.glyphs[i];
            if (o == null) continue;
            if (o instanceof ByteBuffer) {
                length += ((ByteBuffer)o).remaining();
                continue;
            }
            length += ((Glyf)o).getLength();
        }
        return length;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String indent = "    ";
        buf.append(indent + "Glyf Table: (" + this.glyphs.length + " glyphs)\n");
        for (int i = 0; i < Math.min(10, this.glyphs.length); ++i) {
            buf.append(indent + "  Glyf " + i + ": " + String.valueOf(this.getGlyph(i)) + "\n");
        }
        return buf.toString();
    }

    public int getGlyphCount() {
        return this.glyphs.length;
    }
}

